/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.search.similarities;

import org.apache.lucene.ars_nouveau.search.CollectionStatistics;
import org.apache.lucene.ars_nouveau.search.Explanation;
import org.apache.lucene.ars_nouveau.search.TermStatistics;
import org.apache.lucene.ars_nouveau.search.similarities.TFIDFSimilarity;

public class ClassicSimilarity
extends TFIDFSimilarity {
    public ClassicSimilarity() {
    }

    public ClassicSimilarity(boolean discountOverlaps) {
        super(discountOverlaps);
    }

    @Override
    public float lengthNorm(int numTerms) {
        return (float)(1.0 / Math.sqrt(numTerms));
    }

    @Override
    public float tf(float freq) {
        return (float)Math.sqrt(freq);
    }

    @Override
    public Explanation idfExplain(CollectionStatistics collectionStats, TermStatistics termStats) {
        long df = termStats.docFreq();
        long docCount = collectionStats.docCount();
        float idf = this.idf(df, docCount);
        return Explanation.match((Number)Float.valueOf(idf), "idf, computed as log((docCount+1)/(docFreq+1)) + 1 from:", Explanation.match((Number)df, "docFreq, number of documents containing term", new Explanation[0]), Explanation.match((Number)docCount, "docCount, total number of documents with field", new Explanation[0]));
    }

    @Override
    public float idf(long docFreq, long docCount) {
        return (float)(Math.log((double)(docCount + 1L) / (double)(docFreq + 1L)) + 1.0);
    }

    public String toString() {
        return "ClassicSimilarity";
    }
}

