/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.mixin.core.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayDeque;
import java.util.Deque;
import org.embeddedt.embeddium.impl.render.matrix_stack.CachingPoseStack;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={PoseStack.class}, priority=900)
public abstract class MatrixStackMixin
implements CachingPoseStack {
    @Shadow
    @Final
    private Deque<PoseStack.Pose> poseStack;
    @Unique
    private final Deque<PoseStack.Pose> cache = new ArrayDeque<PoseStack.Pose>();
    private int cacheEnabled = 0;

    @Overwrite
    public void pushPose() {
        PoseStack.Pose entry;
        PoseStack.Pose prev = this.poseStack.getLast();
        if (this.cacheEnabled > 0 && !this.cache.isEmpty()) {
            entry = this.cache.removeLast();
            entry.pose().set((Matrix4fc)prev.pose());
            entry.normal().set((Matrix3fc)prev.normal());
        } else {
            entry = new PoseStack.Pose(new Matrix4f((Matrix4fc)prev.pose()), new Matrix3f((Matrix3fc)prev.normal()));
        }
        entry.trustedNormals = prev.trustedNormals;
        this.poseStack.addLast(entry);
    }

    @Overwrite
    public void popPose() {
        PoseStack.Pose pose = this.poseStack.removeLast();
        if (this.cacheEnabled > 0) {
            this.cache.addLast(pose);
        }
    }

    @Override
    public void embeddium$setCachingEnabled(boolean flag) {
        this.cacheEnabled += flag ? 1 : -1;
    }
}

