/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.mixin.features.textures.mipmaps;

import com.mojang.blaze3d.platform.NativeImage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import org.embeddedt.embeddium.impl.render.chunk.sprite.SpriteTransparencyLevel;
import org.embeddedt.embeddium.impl.render.chunk.sprite.SpriteTransparencyLevelHolder;
import org.embeddedt.embeddium.impl.util.NativeImageHelper;
import org.embeddedt.embeddium.impl.util.color.ColorSRGB;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={SpriteContents.class})
public class SpriteContentsMixin
implements SpriteTransparencyLevelHolder {
    @Mutable
    @Shadow
    @Final
    private NativeImage originalImage;
    @Shadow
    @Final
    private ResourceLocation name;
    @Unique
    private SpriteTransparencyLevel embeddium$transparencyLevel;

    @Redirect(method={"<init>"}, at=@At(value="FIELD", target="Lnet/minecraft/client/renderer/texture/SpriteContents;originalImage:Lcom/mojang/blaze3d/platform/NativeImage;", opcode=181))
    private void sodium$beforeGenerateMipLevels(SpriteContents instance, NativeImage nativeImage, ResourceLocation identifier) {
        this.embeddium$processTransparentImages(nativeImage, (Integer)Minecraft.getInstance().options.mipmapLevels().get() > 0 && !this.name.getPath().contains("leaves"));
        this.originalImage = nativeImage;
    }

    @Unique
    private void embeddium$processTransparentImages(NativeImage nativeImage, boolean shouldRewriteColors) {
        long ppPixel = NativeImageHelper.getPointerRGBA(nativeImage);
        int pixelCount = nativeImage.getHeight() * nativeImage.getWidth();
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        float totalWeight = 0.0f;
        SpriteTransparencyLevel level = SpriteTransparencyLevel.OPAQUE;
        for (int pixelIndex = 0; pixelIndex < pixelCount; ++pixelIndex) {
            long pPixel = ppPixel + (long)(pixelIndex * 4);
            int color = MemoryUtil.memGetInt((long)pPixel);
            int alpha = FastColor.ABGR32.alpha((int)color);
            if (alpha > 0) {
                level = alpha < 255 ? level.chooseNextLevel(SpriteTransparencyLevel.TRANSLUCENT) : level.chooseNextLevel(SpriteTransparencyLevel.OPAQUE);
                if (!shouldRewriteColors) continue;
                float weight = alpha;
                r += ColorSRGB.srgbToLinear(FastColor.ABGR32.red((int)color)) * weight;
                g += ColorSRGB.srgbToLinear(FastColor.ABGR32.green((int)color)) * weight;
                b += ColorSRGB.srgbToLinear(FastColor.ABGR32.blue((int)color)) * weight;
                totalWeight += weight;
                continue;
            }
            level = level.chooseNextLevel(SpriteTransparencyLevel.TRANSPARENT);
        }
        this.embeddium$transparencyLevel = level;
        if (!shouldRewriteColors || totalWeight == 0.0f) {
            return;
        }
        int averageColor = ColorSRGB.linearToSrgb(r /= totalWeight, g /= totalWeight, b /= totalWeight, 0);
        for (int pixelIndex = 0; pixelIndex < pixelCount; ++pixelIndex) {
            long pPixel = ppPixel + (long)(pixelIndex * 4);
            int color = MemoryUtil.memGetInt((long)pPixel);
            int alpha = FastColor.ABGR32.alpha((int)color);
            if (alpha != 0) continue;
            MemoryUtil.memPutInt((long)pPixel, (int)averageColor);
        }
    }

    @Override
    public SpriteTransparencyLevel embeddium$getTransparencyLevel() {
        return this.embeddium$transparencyLevel;
    }
}

