/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.compile;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.embeddedt.embeddium.impl.gl.util.VertexRange;
import org.embeddedt.embeddium.impl.model.quad.properties.ModelQuadFacing;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBufferSorter;
import org.embeddedt.embeddium.impl.render.chunk.compile.buffers.BakedChunkModelBuilder;
import org.embeddedt.embeddium.impl.render.chunk.compile.buffers.ChunkModelBuilder;
import org.embeddedt.embeddium.impl.render.chunk.data.BuiltSectionInfo;
import org.embeddedt.embeddium.impl.render.chunk.data.BuiltSectionMeshParts;
import org.embeddedt.embeddium.impl.render.chunk.sorting.TranslucentQuadAnalyzer;
import org.embeddedt.embeddium.impl.render.chunk.terrain.DefaultTerrainRenderPasses;
import org.embeddedt.embeddium.impl.render.chunk.terrain.TerrainRenderPass;
import org.embeddedt.embeddium.impl.render.chunk.terrain.material.Material;
import org.embeddedt.embeddium.impl.render.chunk.vertex.builder.ChunkMeshBufferBuilder;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkVertexType;
import org.embeddedt.embeddium.impl.util.NativeBuffer;

public class ChunkBuildBuffers {
    private static final ModelQuadFacing[] ONLY_UNASSIGNED = new ModelQuadFacing[]{ModelQuadFacing.UNASSIGNED};
    private final Reference2ReferenceOpenHashMap<TerrainRenderPass, BakedChunkModelBuilder> builders = new Reference2ReferenceOpenHashMap();
    private final ChunkVertexType vertexType;

    public ChunkBuildBuffers(ChunkVertexType vertexType) {
        this.vertexType = vertexType;
        for (TerrainRenderPass pass : DefaultTerrainRenderPasses.ALL) {
            ChunkMeshBufferBuilder[] vertexBuffers = new ChunkMeshBufferBuilder[ModelQuadFacing.COUNT];
            for (int facing = 0; facing < ModelQuadFacing.COUNT; ++facing) {
                vertexBuffers[facing] = new ChunkMeshBufferBuilder(this.vertexType, 65536, pass.isSorted() && facing == ModelQuadFacing.UNASSIGNED.ordinal());
            }
            this.builders.put((Object)pass, (Object)new BakedChunkModelBuilder(vertexBuffers, !pass.isSorted()));
        }
    }

    public void init(BuiltSectionInfo.Builder renderData, int sectionIndex) {
        for (BakedChunkModelBuilder builder : this.builders.values()) {
            builder.begin(renderData, sectionIndex);
        }
    }

    public ChunkModelBuilder get(Material material) {
        return (ChunkModelBuilder)this.builders.get((Object)material.pass);
    }

    public ChunkModelBuilder get(TerrainRenderPass pass) {
        return (ChunkModelBuilder)this.builders.get((Object)pass);
    }

    public BuiltSectionMeshParts createMesh(TerrainRenderPass pass) {
        NativeBuffer mergedIndexBuffer;
        BakedChunkModelBuilder builder = (BakedChunkModelBuilder)this.builders.get((Object)pass);
        ArrayList<ByteBuffer> vertexBuffers = new ArrayList<ByteBuffer>();
        VertexRange[] vertexRanges = new VertexRange[ModelQuadFacing.COUNT];
        int vertexCount = 0;
        ModelQuadFacing[] facingsToUpload = pass.isSorted() ? ONLY_UNASSIGNED : ModelQuadFacing.VALUES;
        TranslucentQuadAnalyzer.SortState sortState = pass.isSorted() ? builder.getVertexBuffer(ModelQuadFacing.UNASSIGNED).getSortState() : null;
        for (ModelQuadFacing facing : facingsToUpload) {
            ChunkMeshBufferBuilder buffer = builder.getVertexBuffer(facing);
            if (buffer.isEmpty()) continue;
            vertexBuffers.add(buffer.slice());
            vertexRanges[facing.ordinal()] = new VertexRange(vertexCount, buffer.count());
            vertexCount += buffer.count();
        }
        if (vertexCount == 0) {
            return null;
        }
        NativeBuffer mergedBuffer = new NativeBuffer(vertexCount * this.vertexType.getVertexFormat().getStride());
        ByteBuffer mergedBufferBuilder = mergedBuffer.getDirectBuffer();
        for (ByteBuffer buffer : vertexBuffers) {
            mergedBufferBuilder.put(buffer);
        }
        mergedBufferBuilder.flip();
        if (pass.isSorted()) {
            mergedIndexBuffer = new NativeBuffer(vertexCount / 4 * 6 * 4);
            int bufOffset = 0;
            for (ModelQuadFacing facing : facingsToUpload) {
                ChunkMeshBufferBuilder buffer = builder.getVertexBuffer(facing);
                if (buffer.isEmpty()) continue;
                int numPrimitives = buffer.count() / 4;
                ChunkBufferSorter.generateSimpleIndexBuffer(mergedIndexBuffer, numPrimitives, bufOffset);
                bufOffset += numPrimitives * 6;
            }
        } else {
            mergedIndexBuffer = null;
        }
        return new BuiltSectionMeshParts(mergedBuffer, mergedIndexBuffer, sortState, vertexRanges);
    }

    public void destroy() {
        for (BakedChunkModelBuilder builder : this.builders.values()) {
            builder.destroy();
        }
    }

    public ChunkVertexType getVertexType() {
        return this.vertexType;
    }
}

