/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.compile;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBuildBuffers;
import org.embeddedt.embeddium.impl.render.chunk.compile.pipeline.BlockRenderCache;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkVertexType;

public class ChunkBuildContext {
    public final ChunkBuildBuffers buffers;
    public final BlockRenderCache cache;
    private final ObjectOpenHashSet<TextureAtlasSprite> additionalCapturedSprites;
    private boolean captureAdditionalSprites;

    public ChunkBuildContext(ClientLevel world, ChunkVertexType vertexType) {
        this.buffers = new ChunkBuildBuffers(vertexType);
        this.cache = new BlockRenderCache(Minecraft.getInstance(), world);
        this.additionalCapturedSprites = new ObjectOpenHashSet();
    }

    public void cleanup() {
        this.buffers.destroy();
        this.cache.cleanup();
        this.additionalCapturedSprites.clear();
        this.captureAdditionalSprites = false;
    }

    public void setCaptureAdditionalSprites(boolean flag) {
        this.captureAdditionalSprites = flag;
        if (!flag) {
            this.additionalCapturedSprites.clear();
        }
    }

    public Iterable<TextureAtlasSprite> getAdditionalCapturedSprites() {
        return this.additionalCapturedSprites.isEmpty() ? Collections.emptySet() : this.additionalCapturedSprites;
    }

    public void captureAdditionalSprite(TextureAtlasSprite sprite) {
        if (this.captureAdditionalSprites) {
            this.additionalCapturedSprites.add((Object)sprite);
        }
    }
}

