/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.vertex.builder;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.embeddedt.embeddium.impl.render.chunk.sorting.TranslucentQuadAnalyzer;
import org.embeddedt.embeddium.impl.render.chunk.terrain.material.Material;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkVertexEncoder;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkVertexType;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;

public class ChunkMeshBufferBuilder {
    private final ChunkVertexEncoder encoder;
    private final int stride;
    private final int initialCapacity;
    private final TranslucentQuadAnalyzer analyzer;
    private ByteBuffer buffer;
    private int count;
    private int capacity;
    private int sectionIndex;

    public ChunkMeshBufferBuilder(ChunkVertexType vertexType, int initialCapacity, boolean collectSortState) {
        this.encoder = vertexType.getEncoder();
        this.stride = vertexType.getVertexFormat().getStride();
        this.buffer = null;
        this.capacity = 0;
        this.initialCapacity = initialCapacity;
        this.analyzer = collectSortState ? new TranslucentQuadAnalyzer() : null;
    }

    public void push(ChunkVertexEncoder.Vertex[] vertices, Material material) {
        int vertexStart = this.count * this.stride;
        int vertexSize = vertices.length * this.stride;
        if (vertexStart + vertexSize >= this.capacity) {
            this.grow(vertexSize);
        }
        long ptr = MemoryUtil.memAddress((ByteBuffer)this.buffer, (int)vertexStart);
        if (this.analyzer != null) {
            for (ChunkVertexEncoder.Vertex vertex : vertices) {
                this.analyzer.capture(vertex);
            }
        }
        for (ChunkVertexEncoder.Vertex vertex : vertices) {
            ptr = this.encoder.write(ptr, material, vertex, this.sectionIndex);
        }
        this.count += vertices.length;
    }

    private void grow(int bytesNeeded) {
        int newCapacity = Math.max(this.capacity * 2, this.capacity + bytesNeeded);
        newCapacity = Math.max(newCapacity, this.initialCapacity);
        this.buffer = MemoryUtil.memRealloc((ByteBuffer)this.buffer, (int)newCapacity);
        this.capacity = newCapacity;
    }

    public void start(int sectionIndex) {
        this.count = 0;
        this.sectionIndex = sectionIndex;
        if (this.analyzer != null) {
            this.analyzer.clear();
        }
    }

    @Nullable
    public TranslucentQuadAnalyzer.SortState getSortState() {
        return this.analyzer != null ? this.analyzer.getSortState() : null;
    }

    public void destroy() {
        if (this.buffer != null) {
            MemoryUtil.memFree((Buffer)this.buffer);
        }
        this.buffer = null;
        this.capacity = 0;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public ByteBuffer slice() {
        if (this.isEmpty()) {
            throw new IllegalStateException("No vertex data in buffer");
        }
        return MemoryUtil.memSlice((ByteBuffer)this.buffer, (int)0, (int)(this.stride * this.count));
    }

    public int count() {
        return this.count;
    }
}

