/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.vertex.serializers;

import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.locks.StampedLock;
import org.embeddedt.embeddium.api.vertex.format.VertexFormatDescription;
import org.embeddedt.embeddium.api.vertex.serializer.VertexSerializer;
import org.embeddedt.embeddium.api.vertex.serializer.VertexSerializerRegistry;
import org.embeddedt.embeddium.impl.render.vertex.serializers.generated.VertexSerializerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertexSerializerRegistryImpl
implements VertexSerializerRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(VertexSerializerRegistryImpl.class);
    private static final Path CLASS_DUMP_PATH;
    private final Long2ReferenceMap<VertexSerializer> cache = new Long2ReferenceOpenHashMap();
    private final StampedLock lock = new StampedLock();

    @Override
    public VertexSerializer get(VertexFormatDescription srcFormat, VertexFormatDescription dstFormat) {
        long identifier = VertexSerializerRegistryImpl.createKey(srcFormat, dstFormat);
        VertexSerializer serializer = this.find(identifier);
        if (serializer == null) {
            serializer = this.create(identifier, srcFormat, dstFormat);
        }
        return serializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VertexSerializer create(long identifier, VertexFormatDescription srcFormat, VertexFormatDescription dstFormat) {
        long stamp = this.lock.writeLock();
        try {
            VertexSerializer cached = (VertexSerializer)this.cache.get(identifier);
            if (cached != null) {
                VertexSerializer vertexSerializer = cached;
                return vertexSerializer;
            }
            VertexSerializer serializer = VertexSerializerRegistryImpl.createSerializer(srcFormat, dstFormat);
            this.cache.put(identifier, (Object)serializer);
            VertexSerializer vertexSerializer = serializer;
            return vertexSerializer;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VertexSerializer find(long identifier) {
        long stamp = this.lock.readLock();
        try {
            VertexSerializer vertexSerializer = (VertexSerializer)this.cache.get(identifier);
            return vertexSerializer;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    private static VertexSerializer createSerializer(VertexFormatDescription srcVertexFormat, VertexFormatDescription dstVertexFormat) {
        VertexSerializer serializer;
        Object instance;
        Constructor<?> constructor;
        String identifier = String.format("%04X$%04X", srcVertexFormat.id(), dstVertexFormat.id());
        VertexSerializerFactory.Bytecode bytecode = VertexSerializerFactory.generate(srcVertexFormat, dstVertexFormat, identifier);
        if (CLASS_DUMP_PATH != null) {
            VertexSerializerRegistryImpl.dumpClass(identifier, bytecode);
        }
        Class<?> clazz = VertexSerializerFactory.define(bytecode);
        try {
            constructor = clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to find constructor of generated class", e);
        }
        try {
            instance = constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Failed to instantiate generated class", e);
        }
        try {
            serializer = (VertexSerializer)instance;
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Failed to cast generated class to interface type", e);
        }
        return serializer;
    }

    private static void dumpClass(String id, VertexSerializerFactory.Bytecode bytecode) {
        Path path = CLASS_DUMP_PATH.resolve("VertexSerializer$Impl$%s.class".formatted(id));
        try {
            Files.write(path, bytecode.copy(), new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.warn("Could not dump bytecode to location: {}", (Object)path, (Object)e);
        }
    }

    private static long createKey(VertexFormatDescription a, VertexFormatDescription b) {
        return (long)a.id() & 0xFFFFFFFFL | ((long)b.id() & 0xFFFFFFFFL) << 32;
    }

    static {
        String classDumpPath = System.getProperty("sodium.codegen.dump", null);
        CLASS_DUMP_PATH = classDumpPath != null ? Path.of(classDumpPath, new String[0]) : null;
    }
}

