/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import gripe._90.megacells.misc.LavaTransformLogic;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class}, priority=500)
public abstract class ItemEntityMixin
extends Entity {
    @Unique
    private boolean mega$lavaImmune;
    @Unique
    private int mega$lavaTicks;

    public ItemEntityMixin(EntityType<?> type, Level level) {
        super(type, level);
    }

    @ModifyReturnValue(method={"fireImmune"}, at={@At(value="RETURN")})
    private boolean lavaImmune(boolean original) {
        return original || this.mega$lavaImmune;
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void lavaTimeout(CallbackInfo ci) {
        ItemEntity self = (ItemEntity)this;
        if (LavaTransformLogic.canTransformInLava(self)) {
            int x = Mth.floor((double)this.getX());
            int y = Mth.floor((double)((this.getBoundingBox().minY + this.getBoundingBox().maxY) / 2.0));
            int z = Mth.floor((double)this.getZ());
            FluidState state = this.level().getFluidState(new BlockPos(x, y, z));
            if (state.is(FluidTags.LAVA)) {
                boolean bl = this.mega$lavaImmune = this.mega$lavaTicks <= 200;
                if (this.mega$lavaTicks++ > 200 && LavaTransformLogic.allIngredientsPresent(self)) {
                    this.mega$lavaTicks = 0;
                }
            }
        }
    }
}

