/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.ftb.packcompanion.PackCompanionClient;
import dev.ftb.packcompanion.PackCompanionDataGen;
import dev.ftb.packcompanion.config.PCClientConfig;
import dev.ftb.packcompanion.config.PCCommonConfig;
import dev.ftb.packcompanion.config.PCServerConfig;
import dev.ftb.packcompanion.core.Feature;
import dev.ftb.packcompanion.features.actionpad.ActionPadFeature;
import dev.ftb.packcompanion.features.buffs.MobEntityBuffFeature;
import dev.ftb.packcompanion.features.loot.RandomNameLootFeature;
import dev.ftb.packcompanion.features.onboarding.shadernotice.ShaderNotice;
import dev.ftb.packcompanion.features.spawners.SpawnerFeature;
import dev.ftb.packcompanion.features.structures.StructuresFeature;
import dev.ftb.packcompanion.features.triggerblock.TriggerBlockFeature;
import dev.ftb.packcompanion.features.villager.NoWanderingTraderInvisPotions;
import dev.ftb.packcompanion.integrations.Integrations;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="ftbpc")
public class PackCompanion {
    public static final String MOD_ID = "ftbpc";
    private static final String KEY_CATEGORY = "ftbpackcompanion.key.category";
    public static final Map<ResourceKey<? extends Registry<?>>, DeferredRegister<?>> REGISTRIES = new HashMap();
    private static final List<BiFunction<IEventBus, ModContainer, Feature>> FEATURES = List.of(RandomNameLootFeature::new, MobEntityBuffFeature::new, SpawnerFeature::new, StructuresFeature::new, ShaderNotice::new, NoWanderingTraderInvisPotions::new, TriggerBlockFeature::new, ActionPadFeature::new);
    private final List<Feature> createdFeatures = new ArrayList<Feature>();
    private final PackCompanionDataGen dataGen;

    public PackCompanion(IEventBus modEventBus, ModContainer container) {
        FEATURES.forEach(featureConstructor -> {
            Feature feature = (Feature)featureConstructor.apply(modEventBus, container);
            this.createdFeatures.add(feature);
        });
        PCCommonConfig.init();
        PCServerConfig.init();
        PCClientConfig.init();
        Integrations.instantInit();
        this.dataGen = new PackCompanionDataGen(this);
        modEventBus.addListener(this.dataGen::onInitializeDataGenerator);
        modEventBus.addListener(this::onSetup);
        modEventBus.addListener(this::onClientInit);
        modEventBus.addListener(this::registerNetwork);
        NeoForge.EVENT_BUS.addListener(this::registerCommands);
        NeoForge.EVENT_BUS.addListener(this::serverBeforeStart);
        NeoForge.EVENT_BUS.addListener(this::serverStarted);
        NeoForge.EVENT_BUS.addListener(this::addReloadListeners);
        REGISTRIES.forEach((k, e) -> e.register(modEventBus));
    }

    private void onClientInit(FMLClientSetupEvent event) {
        PackCompanionClient.init(this.createdFeatures.stream().filter(e -> e instanceof Feature.Client).map(e -> (Feature.Client)e).toList());
    }

    private void onSetup(FMLCommonSetupEvent event) {
        Integrations.commonInit();
        this.runForFeatures(feature -> feature instanceof Feature.Common, feature -> ((Feature.Common)feature).onCommonInit());
    }

    private void serverBeforeStart(ServerAboutToStartEvent event) {
        Integrations.serverInit();
    }

    private void serverStarted(ServerStartedEvent event) {
        this.runForFeatures(feature -> feature instanceof Feature.Server, feature -> ((Feature.Server)feature).onServerInit(event.getServer()));
    }

    private void registerCommands(RegisterCommandsEvent event) {
        LiteralArgumentBuilder companionRootCommand = Commands.literal((String)MOD_ID);
        this.runForFeatures(feature -> feature instanceof Feature.Common || feature instanceof Feature.Server, feature -> {
            List<LiteralArgumentBuilder<CommandSourceStack>> commands = feature instanceof Feature.Common ? ((Feature.Common)feature).commands(event.getBuildContext(), event.getCommandSelection()) : ((Feature.Server)feature).commands(event.getBuildContext(), event.getCommandSelection());
            commands.forEach(arg_0 -> ((LiteralArgumentBuilder)companionRootCommand).then(arg_0));
        });
        event.getDispatcher().register(companionRootCommand);
    }

    public void registerNetwork(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        this.runForFeatures(feature -> feature instanceof Feature.Common, feature -> ((Feature.Common)feature).registerPackets(registrar));
    }

    @SubscribeEvent
    public void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new ServerDataReloader());
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    private void runForFeatures(Predicate<Feature> test, Consumer<Feature> action) {
        for (Feature feature : this.createdFeatures) {
            if (!test.test(feature)) continue;
            action.accept(feature);
        }
    }

    public List<Feature> features() {
        return this.createdFeatures;
    }

    public static String getKeyCategory() {
        return KEY_CATEGORY;
    }

    private class ServerDataReloader
    implements ResourceManagerReloadListener {
        private ServerDataReloader() {
        }

        public void onResourceManagerReload(ResourceManager resourceManager) {
            PackCompanion.this.runForFeatures(feature -> feature instanceof Feature.Common || feature instanceof Feature.Server, feature -> feature.onReload(resourceManager));
        }
    }
}

