/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.features.actionpad;

import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.packcompanion.core.DataGatherCollector;
import dev.ftb.packcompanion.core.Feature;
import dev.ftb.packcompanion.features.actionpad.ActionPadItem;
import dev.ftb.packcompanion.features.actionpad.PadActions;
import dev.ftb.packcompanion.features.actionpad.client.ActionPadClient;
import dev.ftb.packcompanion.features.actionpad.net.OpenActionPadPacket;
import dev.ftb.packcompanion.features.actionpad.net.OpenTPAPacket;
import dev.ftb.packcompanion.features.actionpad.net.RunActionPacket;
import dev.ftb.packcompanion.features.actionpad.net.TryOpenActionPadFromItemPacket;
import dev.ftb.packcompanion.features.actionpad.net.TryOpenActionTPAPacket;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import top.theillusivec4.curios.api.CuriosTags;

public class ActionPadFeature
extends Feature.Common {
    private static final DeferredRegister<Item> ITEM_REGISTRY = ActionPadFeature.getRegistry(Registries.ITEM);
    public static final DeferredHolder<Item, ActionPadItem> ACTION_PAD = ITEM_REGISTRY.register("action_pad", () -> new ActionPadItem(new Item.Properties().stacksTo(1)));

    public ActionPadFeature(IEventBus modEventBus, ModContainer container) {
        super(modEventBus, container);
        modEventBus.addListener(this::onClientInit);
        modEventBus.addListener(this::creativeTab);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modEventBus.addListener(ActionPadClient::onRegisterKeyBindings);
        }
    }

    private void creativeTab(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == FTBLibrary.getCreativeModeTab().get()) {
            event.accept((ItemLike)ACTION_PAD.get());
        }
    }

    private void onClientInit(FMLClientSetupEvent event) {
        NeoForge.EVENT_BUS.addListener(ActionPadClient::onInputEvent);
    }

    @Override
    public void onReload(ResourceManager resourceManager) {
        PadActions.get().load();
    }

    @Override
    public void registerPackets(PayloadRegistrar registrar) {
        registrar.playToClient(OpenActionPadPacket.TYPE, OpenActionPadPacket.STREAM_CODEC, OpenActionPadPacket::handle);
        registrar.playToClient(OpenTPAPacket.TYPE, OpenTPAPacket.STREAM_CODEC, OpenTPAPacket::handle);
        registrar.playToServer(RunActionPacket.TYPE, RunActionPacket.STREAM_CODEC, RunActionPacket::handle);
        registrar.playToServer(TryOpenActionPadFromItemPacket.TYPE, TryOpenActionPadFromItemPacket.STREAM_CODEC, TryOpenActionPadFromItemPacket::handle);
        registrar.playToServer(TryOpenActionTPAPacket.TYPE, TryOpenActionTPAPacket.STREAM_CODEC, TryOpenActionTPAPacket::handle);
    }

    @Override
    public void onDataGather(DataGatherCollector collector) {
        DataGatherCollector.TranslationCollector translations = collector.translationCollector();
        translations.addItem(ACTION_PAD, "Action Pad");
        translations.prefixed("home", "Home");
        translations.prefixed("spawn", "Spawn");
        translations.prefixed("tpa", "Request Teleport");
        translations.prefixed("actionpad.tpa.request_sent", "TP request sent to");
        translations.prefixed("key.category", "Pack Companion");
        translations.prefixed("key.open_action_pad", "Open Action Pad");
        collector.addItemModelProvider(provider -> provider.basicItem((Item)ACTION_PAD.get()));
        collector.addItemTagProvider(provider -> provider.appendItemTag((TagKey<Item>)CuriosTags.CURIO).add((Object)((Item)ACTION_PAD.get())));
    }
}

