/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.features.actionpad;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.packcompanion.core.utils.ExtraCodecs;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.level.Level;
import org.joml.Vector2f;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record PadAction(String name, Icon icon, Optional<String> unlockedAt, Optional<CommandAction> commandAction, Optional<TeleportAction> teleportAction, boolean autoclose) {
    public static final Codec<PadAction> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("name").forGetter(PadAction::name), (App)Icon.CODEC.fieldOf("icon").forGetter(PadAction::icon), (App)Codec.STRING.optionalFieldOf("unlocked_at").forGetter(PadAction::unlockedAt), (App)CommandAction.CODEC.optionalFieldOf("command_action").forGetter(PadAction::commandAction), (App)TeleportAction.CODEC.optionalFieldOf("teleport_action").forGetter(PadAction::teleportAction), (App)Codec.BOOL.optionalFieldOf("autoclose", (Object)true).forGetter(PadAction::autoclose)).apply((Applicative)builder, PadAction::new));
    public static final StreamCodec<FriendlyByteBuf, PadAction> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, PadAction::name, (StreamCodec)Icon.STREAM_CODEC, PadAction::icon, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), PadAction::unlockedAt, (StreamCodec)ByteBufCodecs.optional(CommandAction.STREAM_CODEC), PadAction::commandAction, (StreamCodec)ByteBufCodecs.optional(TeleportAction.STREAM_CODEC), PadAction::teleportAction, (StreamCodec)ByteBufCodecs.BOOL, PadAction::autoclose, PadAction::new);

    public record CommandAction(String command, int executionLevel, boolean executeAsServer) implements ActionRunner
    {
        public static final Codec<CommandAction> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("command").forGetter(CommandAction::command), (App)Codec.INT.optionalFieldOf("execution_level", (Object)2).forGetter(CommandAction::executionLevel), (App)Codec.BOOL.optionalFieldOf("execute_as_server", (Object)false).forGetter(CommandAction::executeAsServer)).apply((Applicative)builder, CommandAction::new));
        public static final StreamCodec<FriendlyByteBuf, CommandAction> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, CommandAction::command, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.INT).map(opt -> opt.orElse(2), Optional::of), CommandAction::executionLevel, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.BOOL).map(opt -> opt.orElse(false), Optional::of), CommandAction::executeAsServer, CommandAction::new);

        @Override
        public void run(ServerPlayer player) {
            Level level = player.level();
            CommandSourceStack sourceStack = this.executeAsServer ? Objects.requireNonNull(level.getServer()).createCommandSourceStack().withPermission(this.executionLevel) : player.createCommandSourceStack().withPermission(this.executionLevel);
            Objects.requireNonNull(level.getServer()).getCommands().performPrefixedCommand(sourceStack, this.command);
        }
    }

    public record TeleportAction(BlockPos position, ResourceKey<Level> dimension, Optional<Vector2f> rotation) implements ActionRunner
    {
        private static final Logger LOGGER = LoggerFactory.getLogger(PadAction.class);
        public static final Codec<TeleportAction> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockPos.CODEC.fieldOf("position").forGetter(TeleportAction::position), (App)ResourceKey.codec((ResourceKey)Registries.DIMENSION).fieldOf("dimension").forGetter(TeleportAction::dimension), (App)ExtraCodecs.VECTOR2F_CODEC.optionalFieldOf("rotation").forGetter(TeleportAction::rotation)).apply((Applicative)builder, TeleportAction::new));
        public static final StreamCodec<FriendlyByteBuf, TeleportAction> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, TeleportAction::position, (StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION), TeleportAction::dimension, (StreamCodec)ByteBufCodecs.optional(ExtraCodecs.VECTOR2F_STREAM_CODEC), TeleportAction::rotation, TeleportAction::new);

        @Override
        public void run(ServerPlayer player) {
            ServerLevel level = player.getServer().getLevel(this.dimension());
            if (level == null) {
                LOGGER.warn("Failed to teleport player {}: dimension {} not found", (Object)player.getName().getString(), (Object)this.dimension().location());
                return;
            }
            float yaw = this.rotation().map(e -> Float.valueOf(e.x)).orElse(Float.valueOf(player.getYRot())).floatValue();
            float pitch = this.rotation().map(e -> Float.valueOf(e.y)).orElse(Float.valueOf(player.getXRot())).floatValue();
            BlockPos pos = this.position();
            player.teleportTo(level, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, RelativeMovement.ALL, yaw, pitch);
        }
    }

    @FunctionalInterface
    public static interface ActionRunner {
        default public ActionRunner asActionRunner() {
            return this;
        }

        public void run(ServerPlayer var1);
    }
}

