/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.features.onboarding.shadernotice;

import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.PanelScrollBar;
import dev.ftb.mods.ftblibrary.ui.ScrollBar;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.TextField;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.packcompanion.config.PCCommonConfig;
import dev.ftb.packcompanion.features.onboarding.shadernotice.ShaderNotice;
import dev.ftb.packcompanion.integrations.iris.ShadersIntegration;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShaderNoticeScreen
extends BaseScreen {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShaderNoticeScreen.class);
    private final ShaderNotice shaderNotice;
    private Option shadersOffPanel;
    private Option shadersOnPanel;

    public ShaderNoticeScreen(ShaderNotice shaderNotice) {
        super(null);
        this.shaderNotice = shaderNotice;
        this.setWidth(300);
        this.setHeight(190);
        if (!ShadersIntegration.get().isAvailable()) {
            this.closeGui();
        }
    }

    public void addWidgets() {
        this.shadersOffPanel = new Option((Panel)this, (Component)Component.translatable((String)"ftbpackcompanion.shaders_notice.no_shaders.title"), (Component)Component.translatable((String)"ftbpackcompanion.shaders_notice.shaders_btn.disable"), Icons.CANCEL, (Component)Component.translatable((String)"ftbpackcompanion.shaders_notice.no_shaders.description"), accepted -> {
            boolean isAvailable = ShadersIntegration.get().isAvailable();
            if (isAvailable) {
                ShadersIntegration.get().provider().disabledShaders();
            }
            this.shaderNotice.hasOnboarded.set((Object)true);
            this.shaderNotice.shaderData.save();
            this.closeGui();
        });
        this.add((Widget)this.shadersOffPanel);
        this.shadersOnPanel = new Option((Panel)this, (Component)Component.translatable((String)"ftbpackcompanion.shaders_notice.shaders.title"), (Component)Component.translatable((String)"ftbpackcompanion.shaders_notice.shaders_btn.enable"), Icons.CHECK, (Component)Component.translatable((String)"ftbpackcompanion.shaders_notice.shaders.description"), accepted -> {
            boolean isAvailable = ShadersIntegration.get().isAvailable();
            if (isAvailable) {
                ShadersIntegration.get().provider().applyShaderPack((String)PCCommonConfig.SHADER_PACK_TO_USE.get());
            }
            this.shaderNotice.hasOnboarded.set((Object)true);
            this.shaderNotice.shaderData.save();
            this.closeGui();
        }).withAlt(true);
        this.add((Widget)this.shadersOnPanel);
    }

    public void alignWidgets() {
        this.shadersOffPanel.setSize(150, 190);
        this.shadersOffPanel.alignWidgets();
        this.shadersOnPanel.setSize(150, 190);
        this.shadersOnPanel.alignWidgets();
        this.align(WidgetLayout.HORIZONTAL);
    }

    public void drawForeground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        super.drawForeground(graphics, theme, x, y, w, h);
        MutableComponent text = Component.translatable((String)"ftbpackcompanion.shaders_notice.title").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.AQUA);
        int stringWidth = this.getTheme().getStringWidth((FormattedText)text);
        graphics.drawString(this.getTheme().getFont(), (Component)text, x + (this.width - stringWidth) / 2, y - 16, Color4I.WHITE.rgb());
    }

    public boolean usePreviousScreenOnBack() {
        return false;
    }

    private static class Option
    extends Panel {
        private final Component title;
        private final Component description;
        private final Component btnText;
        private final Icon btnIcon;
        private final BooleanConsumer onSelect;
        private boolean isAlt = false;
        private TextField titleField;
        private PanelScrollBar scrollBar;
        private DescriptionPanel descriptionPanel;
        private Button acceptButton;

        public Option(Panel panel, Component title, Component btnText, Icon btnIcon, Component description, BooleanConsumer onSelect) {
            super(panel);
            this.title = title;
            this.onSelect = onSelect;
            this.description = description;
            this.btnText = btnText;
            this.btnIcon = btnIcon;
        }

        public Option withAlt(boolean withAlt) {
            this.isAlt = withAlt;
            return this;
        }

        public void addWidgets() {
            this.titleField = new TextField((Panel)this);
            this.titleField.setText((Component)this.title.copy().withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.UNDERLINE));
            this.add((Widget)this.titleField);
            this.descriptionPanel = new DescriptionPanel(this, this.description);
            this.add((Widget)this.descriptionPanel);
            this.acceptButton = SimpleTextButton.create((Panel)this, (Component)this.btnText, (Icon)this.btnIcon, mouseButton -> this.onSelect.accept(true), (Component[])new Component[0]);
            this.add((Widget)this.acceptButton);
            this.scrollBar = new PanelScrollBar((Panel)this, ScrollBar.Plane.VERTICAL, (Panel)this.descriptionPanel);
            this.add((Widget)this.scrollBar);
        }

        public void alignWidgets() {
            this.titleField.setPosAndSize(5, 0, this.width - 10, 12);
            this.acceptButton.setSize(this.width - 6, 18);
            this.acceptButton.setPos(3, 0);
            this.align((WidgetLayout)new WidgetLayout.Vertical(5, 5, 0));
            this.descriptionPanel.alignWidgets();
            this.scrollBar.setPosAndSize(this.descriptionPanel.getPosX() + this.descriptionPanel.getWidth() - 6, this.descriptionPanel.getPosY(), 6, this.descriptionPanel.getHeight());
        }

        public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            if (this.isAlt) {
                Color4I.WHITE.withAlphaf(0.1f).draw(graphics, x, y, w, h);
            }
        }
    }

    private static class DescriptionPanel
    extends Panel {
        private final Component description;
        private TextField descriptionField;

        public DescriptionPanel(Panel panel, Component description) {
            super(panel);
            this.setSize(148, 142);
            this.description = description;
        }

        public void addWidgets() {
            this.descriptionField = new TextField((Panel)this);
            this.add((Widget)this.descriptionField);
            this.descriptionField.setText(this.description);
        }

        public void alignWidgets() {
            this.descriptionField.setSize(this.width - 10, this.height);
            this.descriptionField.setPos(5, 0);
            this.descriptionField.setMinWidth(this.width - 10);
            this.descriptionField.setMaxWidth(this.width - 10);
            this.descriptionField.reflow();
        }
    }
}

