/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.features.spawners;

import com.google.common.base.Suppliers;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.packcompanion.config.PCServerConfig;
import dev.ftb.packcompanion.core.Feature;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpawnerFeature
extends Feature.Server {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpawnerFeature.class);
    private DataStore dataStore;
    private final Supplier<List<EntityType<?>>> randomEntities = Suppliers.memoize(() -> {
        List randomEntities = (List)PCServerConfig.SPAWNERS_USE_RANDOM_ENTITY.get();
        ArrayList<EntityType> entities = new ArrayList<EntityType>();
        for (String entity : randomEntities) {
            EntityType entityType;
            ResourceLocation resourceLocation = ResourceLocation.tryParse((String)entity);
            if (resourceLocation == null || (entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(resourceLocation)) == EntityType.PIG && !entity.endsWith("pig")) continue;
            entities.add(entityType);
        }
        return entities;
    });

    public SpawnerFeature(IEventBus modEventBus, ModContainer container) {
        super(modEventBus, container);
        if (!((Boolean)PCServerConfig.SPAWNERS_ALLOW_RESPAWN.get()).booleanValue()) {
            return;
        }
        modEventBus.addListener(this::onBlockBroken);
        NeoForge.EVENT_BUS.addListener(this::onServerTick);
    }

    @Override
    public void onServerInit(MinecraftServer server) {
        this.dataStore = DataStore.create(server);
    }

    @Override
    public List<LiteralArgumentBuilder<CommandSourceStack>> commands(CommandBuildContext commandBuildContext, Commands.CommandSelection commandSelection) {
        return List.of((LiteralArgumentBuilder)Commands.literal((String)"spawner_manager").then(Commands.literal((String)"clear").executes(this::clearBrokenSpawners)));
    }

    public void onBlockBroken(BlockEvent.BreakEvent event) {
        LevelAccessor level = event.getLevel();
        BlockState state = event.getState();
        BlockPos pos = event.getPos();
        Player player = event.getPlayer();
        if (level.getServer() == null || level.isClientSide() || this.dataStore == null) {
            return;
        }
        if (state.getBlock() != Blocks.SPAWNER) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof SpawnerBlockEntity)) {
            return;
        }
        SpawnerBlockEntity spawnerBlockEntity = (SpawnerBlockEntity)blockEntity;
        CompoundTag compound = spawnerBlockEntity.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
        DataStore dataStore = this.dataStore;
        dataStore.brokenSpawners.add(new MobSpawnerData(pos, compound, (ResourceKey<Level>)((ServerLevel)level).dimension()));
        dataStore.setDirty();
        if (((Boolean)PCServerConfig.PUNISH_BREAKING_SPAWNER.get()).booleanValue()) {
            this.spawnPunishment((ServerPlayer)player, (Level)level, pos, compound);
        }
    }

    private void spawnPunishment(ServerPlayer player, Level level, BlockPos spawnerPos, CompoundTag compound) {
        if (!compound.contains("SpawnData")) {
            return;
        }
        SpawnData spawnData = SpawnData.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compound.getCompound("SpawnData")).resultOrPartial(string -> LOGGER.warn("Invalid SpawnData: {}", string)).orElseGet(SpawnData::new);
        CompoundTag entityCompound = spawnData.getEntityToSpawn();
        BoundingBox box = new BoundingBox(spawnerPos).inflatedBy(3);
        box = box.moved(0, spawnerPos.getY() - box.minY(), 0);
        ArrayList<BlockPos> airBlocks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> toCheck = new ArrayList<BlockPos>();
        toCheck.add(spawnerPos);
        while (!toCheck.isEmpty()) {
            BlockPos currentPos = (BlockPos)toCheck.remove(0);
            BlockState currentState = level.getBlockState(currentPos);
            if (!currentState.isAir() && !currentState.canBeReplaced() && currentState.getBlock() != Blocks.SPAWNER) continue;
            airBlocks.add(currentPos);
            List<BlockPos> nextLocations = List.of(currentPos.north(), currentPos.south(), currentPos.east(), currentPos.west(), currentPos.below(), currentPos.above());
            for (BlockPos nextLocation : nextLocations) {
                if (toCheck.contains(nextLocation) || airBlocks.contains(nextLocation) || !box.isInside((Vec3i)nextLocation)) continue;
                toCheck.add(nextLocation);
            }
        }
        List<BlockPos> validBlocks = airBlocks.stream().filter(e -> e.getY() < spawnerPos.getY() + 2).toList();
        if (validBlocks.isEmpty()) {
            return;
        }
        ArrayList<BlockPos> alreadyTaken = new ArrayList<BlockPos>();
        int mobsToSpawn = level.random.nextInt(2, 8);
        int tries = 0;
        while (++tries < 15 && alreadyTaken.size() < mobsToSpawn) {
            BlockPos randomPos = validBlocks.get(level.random.nextInt(validBlocks.size()));
            if (alreadyTaken.contains(randomPos)) continue;
            alreadyTaken.add(randomPos);
            Entity entity = EntityType.loadEntityRecursive((CompoundTag)entityCompound, (Level)level, Function.identity());
            if (entity == null) continue;
            entity.setPos((double)randomPos.getX() + 0.5, (double)randomPos.getY(), (double)randomPos.getZ() + 0.5);
            level.addFreshEntity(entity);
            Holder sound = BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)SoundEvents.ZOMBIE_ATTACK_WOODEN_DOOR);
            player.connection.send((Packet)new ClientboundSoundPacket(sound, SoundSource.AMBIENT, (double)randomPos.getX(), (double)randomPos.getY(), (double)randomPos.getZ(), 0.3f, 0.4f, (long)level.random.nextInt()));
        }
    }

    private void onServerTick(LevelTickEvent event) {
        Level serverLevel = event.getLevel();
        if (event.getLevel().isClientSide) {
            return;
        }
        if (serverLevel.getGameTime() % 200L != 0L) {
            return;
        }
        DataStore dataStore = this.getDataStore();
        if (dataStore == null || dataStore.brokenSpawners.isEmpty()) {
            return;
        }
        List<MobSpawnerData> dimensionSpawners = dataStore.brokenSpawners.stream().filter(e -> e.dimension().equals((Object)serverLevel.dimension())).toList();
        if (dimensionSpawners.isEmpty()) {
            return;
        }
        Instant currentTime = Instant.now();
        int respawnInterval = (Integer)PCServerConfig.SPAWNERS_RESPAWN_INTERVAL.get();
        for (MobSpawnerData spawnerData : dimensionSpawners) {
            if (currentTime.isBefore(spawnerData.breakTime.plus((long)respawnInterval, ChronoUnit.MINUTES))) continue;
            BlockState state = serverLevel.getBlockState(spawnerData.pos);
            if (!state.isAir() || !state.canBeReplaced()) {
                dataStore.brokenSpawners.remove(spawnerData);
                dataStore.setDirty();
                continue;
            }
            serverLevel.setBlock(spawnerData.pos, Blocks.SPAWNER.defaultBlockState(), 3);
            BlockEntity blockEntity = serverLevel.getBlockEntity(spawnerData.pos);
            if (!(blockEntity instanceof SpawnerBlockEntity)) continue;
            SpawnerBlockEntity spawnerBlockEntity = (SpawnerBlockEntity)blockEntity;
            CompoundTag compound = spawnerData.spawnerData;
            List<EntityType<?>> randomEntities = this.randomEntities.get();
            if (!randomEntities.isEmpty()) {
                EntityType<?> foundEntity = randomEntities.size() == 1 ? randomEntities.get(0) : randomEntities.get(serverLevel.random.nextInt(randomEntities.size()));
                CompoundTag entityCompound = (CompoundTag)Util.make((Object)new CompoundTag(), tag -> tag.put("entity", (Tag)Util.make((Object)new CompoundTag(), entityTag -> entityTag.putString("id", Objects.requireNonNull(foundEntity.builtInRegistryHolder().key().location()).toString()))));
                compound.put("SpawnData", (Tag)entityCompound);
            }
            spawnerBlockEntity.loadWithComponents(compound, (HolderLookup.Provider)serverLevel.registryAccess());
            spawnerBlockEntity.setChanged();
            dataStore.brokenSpawners.remove(spawnerData);
            dataStore.setDirty();
        }
    }

    private int clearBrokenSpawners(CommandContext<CommandSourceStack> context) {
        List<MobSpawnerData> spawners = Objects.requireNonNull(this.dataStore).getBrokenSpawners();
        int cleared = spawners.size();
        this.dataStore.getBrokenSpawners().clear();
        this.dataStore.setDirty();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)(cleared + " broken spawners cleared")), false);
        return 0;
    }

    @Nullable
    public DataStore getDataStore() {
        return this.dataStore;
    }

    public static class DataStore
    extends SavedData {
        private final List<MobSpawnerData> brokenSpawners = new ArrayList<MobSpawnerData>();

        private DataStore() {
        }

        private static DataStore load(CompoundTag tag, HolderLookup.Provider provider) {
            if (!tag.contains("broken_spawners")) {
                return new DataStore();
            }
            DataStore ds = new DataStore();
            ds.brokenSpawners.addAll(MobSpawnerData.CODEC.listOf().parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)tag.getCompound("broken_spawners"))).result().orElse(new ArrayList()));
            return ds;
        }

        public static DataStore create(MinecraftServer server) {
            return (DataStore)server.getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(DataStore::new, DataStore::load, DataFixTypes.SAVED_DATA_COMMAND_STORAGE), "ftbpc-spawner-manager");
        }

        @NotNull
        public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
            compoundTag.put("broken_spawners", (Tag)MobSpawnerData.CODEC.listOf().encodeStart((DynamicOps)NbtOps.INSTANCE, this.brokenSpawners).result().orElse(new CompoundTag()));
            return compoundTag;
        }

        public List<MobSpawnerData> getBrokenSpawners() {
            return this.brokenSpawners;
        }
    }

    public record MobSpawnerData(BlockPos pos, CompoundTag spawnerData, Instant breakTime, ResourceKey<Level> dimension) {
        private static final Codec<ResourceKey<Level>> DIMENSION_CODEC = ResourceKey.codec((ResourceKey)Registries.DIMENSION);
        private static final Codec<Instant> INSTANT_CODEC = Codec.LONG.xmap(Instant::ofEpochMilli, Instant::toEpochMilli);
        public static final Codec<MobSpawnerData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.CODEC.fieldOf("pos").forGetter(MobSpawnerData::pos), (App)CompoundTag.CODEC.fieldOf("spawner_data").forGetter(MobSpawnerData::spawnerData), (App)INSTANT_CODEC.fieldOf("break_time").forGetter(MobSpawnerData::breakTime), (App)DIMENSION_CODEC.fieldOf("dimension").forGetter(MobSpawnerData::dimension)).apply((Applicative)instance, MobSpawnerData::new));

        public MobSpawnerData(BlockPos pos, CompoundTag spawnerData, ResourceKey<Level> dimension) {
            this(pos, spawnerData, Instant.now(), dimension);
        }
    }
}

