/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.packcompanion.features.triggerblock;

import dev.ftb.packcompanion.features.triggerblock.TriggerBlockEntity;
import dev.ftb.packcompanion.features.triggerblock.TriggerBlockEvent;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public enum TriggerBlockController {
    INSTANCE;

    private final Map<TriggerId, Instant> playersInTriggers = Collections.synchronizedMap(new HashMap());
    private short tickTracker = 0;

    void onTick() {
        this.tickTracker = (short)(this.tickTracker + 1);
        if (this.tickTracker % 20 != 0) {
            return;
        }
        HashMap<TriggerId, Instant> mapCopy = new HashMap<TriggerId, Instant>(this.playersInTriggers);
        for (Map.Entry<TriggerId, Instant> entry : mapCopy.entrySet()) {
            if (!entry.getValue().isBefore(Instant.now().minusSeconds(5L))) continue;
            this.playersInTriggers.remove(entry.getKey());
        }
    }

    public void onPlayerIn(Player player, BlockPos pos) {
        BlockEntity entity = player.level().getBlockEntity(pos);
        if (!(entity instanceof TriggerBlockEntity)) {
            return;
        }
        TriggerBlockEntity triggerBlockEntity = (TriggerBlockEntity)entity;
        String name = triggerBlockEntity.name();
        TriggerId key = new TriggerId(player, name);
        if (this.playersInTriggers.containsKey(key)) {
            return;
        }
        this.playersInTriggers.put(key, Instant.now());
        if (triggerBlockEntity.ignorePlayersWithTag() != null && player.getTags().contains(triggerBlockEntity.ignorePlayersWithTag())) {
            return;
        }
        NeoForge.EVENT_BUS.post((Event)new TriggerBlockEvent(player, pos, name));
    }

    record TriggerId(UUID playerId, String id) {
        TriggerId(Player player, String id) {
            this(player.getUUID(), id);
        }
    }
}

