/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.datagen.client.lang;

import com.jerry.datagen.client.lang.ConvertibleLanguageProvider;
import com.jerry.datagen.client.lang.FormatSplitter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.Util;
import net.minecraft.data.PackOutput;

public class NonAmericanLanguageProvider
extends ConvertibleLanguageProvider {
    private static final List<WordConversion> CONVERSIONS = ((HashMap)Util.make(new HashMap(), map -> {
        NonAmericanLanguageProvider.addEntry(map, "Pressurized", "Pressurised");
        NonAmericanLanguageProvider.addEntry(map, "Stabilizer", "Stabiliser");
        NonAmericanLanguageProvider.addEntry(map, "Stabilizing", "Stabilising");
        NonAmericanLanguageProvider.addEntry(map, "Stabilization", "Stabilisation");
        NonAmericanLanguageProvider.addEntry(map, "Crystallizer", "Crystalliser");
        NonAmericanLanguageProvider.addEntry(map, "Nucleosynthesizer", "Nucleosynthesiser");
        NonAmericanLanguageProvider.addEntry(map, "Color", "Colour");
        NonAmericanLanguageProvider.addEntry(map, "Oxidizer", "Oxidiser");
        NonAmericanLanguageProvider.addEntry(map, "Oxidizing", "Oxidising");
        NonAmericanLanguageProvider.addEntry(map, "Formulas", "Formulae");
        NonAmericanLanguageProvider.addEntry(map, "Energized", "Energised");
        NonAmericanLanguageProvider.addEntry(map, "Energize", "Energise");
        NonAmericanLanguageProvider.addEntry(map, "Energizing", "Energising");
        NonAmericanLanguageProvider.addEntry(map, "Utilizes", "Utilises");
        NonAmericanLanguageProvider.addEntry(map, "Motorized", "Motorised");
        NonAmericanLanguageProvider.addEntry(map, "Bodyarmor", "Bodyarmour");
        NonAmericanLanguageProvider.addEntry(map, "Armor", "Armour");
        NonAmericanLanguageProvider.addEntry(map, "Armored", "Armoured");
        NonAmericanLanguageProvider.addEntry(map, "Gray", "Grey");
        NonAmericanLanguageProvider.addEntry(map, "Whooshes", "Wooshes");
    })).entrySet().stream().map(entry -> new WordConversion((String)entry.getKey(), (String)entry.getValue())).toList();

    private static void addEntry(Map<String, String> map, String key, String value) {
        map.put(key, value);
        map.put(key.toLowerCase(Locale.ROOT), value.toLowerCase(Locale.ROOT));
    }

    public NonAmericanLanguageProvider(PackOutput output, String modid, String locale) {
        super(output, modid, locale);
    }

    @Override
    public void convert(String key, String raw, List<FormatSplitter.Component> splitEnglish) {
        StringBuilder builder = new StringBuilder();
        boolean foundMatch = false;
        for (FormatSplitter.Component component : splitEnglish) {
            if (component instanceof FormatSplitter.FormatComponent) {
                builder.append(component.contents());
                continue;
            }
            String contents = component.contents();
            ArrayList<WordConversion> matched = new ArrayList<WordConversion>();
            for (WordConversion conversion : CONVERSIONS) {
                if (!conversion.match(contents).find()) continue;
                matched.add(conversion);
            }
            if (!matched.isEmpty()) {
                foundMatch = true;
                for (WordConversion conversion : matched) {
                    contents = conversion.replace(contents);
                }
            }
            builder.append(contents);
        }
        if (foundMatch) {
            this.add(key, builder.toString());
        }
    }

    private record WordConversion(Pattern matcher, String replacement) {
        private WordConversion(String toReplace, String replacement) {
            this(Pattern.compile("\\b" + toReplace + "\\b"), replacement);
        }

        public Matcher match(String contents) {
            return this.matcher.matcher(contents);
        }

        public String replace(String contents) {
            return this.match(contents).replaceAll(this.replacement);
        }
    }
}

