/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RenderLineHelper {
    private static final ResourceLocation WHITE_TEX = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/misc/white.png");

    public static void renderLine(PoseStack poseStack, MultiBufferSource buffers, Vector3f start, Vector3f end, float r, float g, float b, float thickness) {
        Vector3f dir = new Vector3f((Vector3fc)end).sub((Vector3fc)start);
        float len = dir.length();
        if ((double)len <= 1.0E-5) {
            return;
        }
        dir.div(len);
        poseStack.pushPose();
        poseStack.translate(start.x(), start.y(), start.z());
        Matrix4f matrix = poseStack.last().pose();
        VertexConsumer vc = buffers.getBuffer(RenderType.entityTranslucentEmissive((ResourceLocation)WHITE_TEX));
        Vector3f u = new Vector3f();
        if (Math.abs(dir.y()) < 0.99f) {
            u.set(0.0f, 1.0f, 0.0f).cross((Vector3fc)dir).normalize();
        } else {
            u.set(1.0f, 0.0f, 0.0f).cross((Vector3fc)dir).normalize();
        }
        Vector3f v = new Vector3f((Vector3fc)dir).cross((Vector3fc)u).normalize();
        float rHalf = thickness / 2.0f;
        int light = 0xF000F0;
        int overlay = 0;
        int segments = 4;
        for (int i = 0; i < segments; ++i) {
            double a0 = Math.PI * 2 * (double)i / (double)segments;
            double a1 = Math.PI * 2 * (double)(i + 1) / (double)segments;
            Vector3f p0 = new Vector3f((Vector3fc)u).mul((float)Math.cos(a0) * rHalf).add((Vector3fc)new Vector3f((Vector3fc)v).mul((float)Math.sin(a0) * rHalf));
            Vector3f p1 = new Vector3f((Vector3fc)u).mul((float)Math.cos(a1) * rHalf).add((Vector3fc)new Vector3f((Vector3fc)v).mul((float)Math.sin(a1) * rHalf));
            Vector3f s0 = new Vector3f((Vector3fc)p0);
            Vector3f s1 = new Vector3f((Vector3fc)p1);
            Vector3f e0 = new Vector3f((Vector3fc)p0).add((Vector3fc)new Vector3f((Vector3fc)dir).mul(len));
            Vector3f e1 = new Vector3f((Vector3fc)p1).add((Vector3fc)new Vector3f((Vector3fc)dir).mul(len));
            RenderLineHelper.addQuad(vc, matrix, s0, s1, e1, e0, r, g, b, 1.0f, light, overlay);
        }
        poseStack.popPose();
    }

    private static void addQuad(VertexConsumer vc, Matrix4f matrix, Vector3f p1, Vector3f p2, Vector3f p3, Vector3f p4, float r, float g, float b, float a, int light, int overlay) {
        vc.addVertex(matrix, p1.x(), p1.y(), p1.z()).setColor(r, g, b, a).setUv(0.0f, 0.0f).setLight(light).setOverlay(overlay).setNormal(0.0f, 0.0f, 0.0f);
        vc.addVertex(matrix, p2.x(), p2.y(), p2.z()).setColor(r, g, b, a).setUv(1.0f, 0.0f).setLight(light).setOverlay(overlay).setNormal(0.0f, 0.0f, 0.0f);
        vc.addVertex(matrix, p3.x(), p3.y(), p3.z()).setColor(r, g, b, a).setUv(1.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(0.0f, 0.0f, 0.0f);
        vc.addVertex(matrix, p4.x(), p4.y(), p4.z()).setColor(r, g, b, a).setUv(0.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(0.0f, 0.0f, 0.0f);
    }
}

