/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.tile.machine;

import com.jerry.mekmm.api.recipes.basic.MMBasicItemStackChemicalToItemStackRecipe;
import com.jerry.mekmm.api.recipes.cache.ReplicatorCachedRecipe;
import com.jerry.mekmm.client.recipe_viewer.MMRecipeViewerRecipeType;
import com.jerry.mekmm.common.config.MoreMachineConfig;
import com.jerry.mekmm.common.recipe.impl.ReplicatorIRecipeSingle;
import com.jerry.mekmm.common.registries.MoreMachineBlocks;
import com.jerry.mekmm.common.registries.MoreMachineChemicals;
import com.jerry.mekmm.common.util.MoreMachineUtils;
import com.jerry.mekmm.common.util.ValidatorUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.tile.prefab.TileEntityProgressMachine;
import mekanism.common.upgrade.AdvancedMachineUpgradeData;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.RegistryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityReplicator
extends TileEntityProgressMachine<MMBasicItemStackChemicalToItemStackRecipe> {
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    public static final int BASE_TICKS_REQUIRED = 200;
    public static final long MAX_GAS = 10000L;
    public static HashMap<String, Integer> customRecipeMap = ValidatorUtils.getRecipeFromConfig((List)MoreMachineConfig.general.itemReplicatorRecipe.get());
    public IChemicalTank chemicalTank;
    private MachineEnergyContainer<TileEntityReplicator> energyContainer;
    protected final IInputHandler<@NotNull ItemStack> itemInputHandler;
    private final IOutputHandler<ItemStack> outputHandler;
    private final ILongInputHandler<ChemicalStack> chemicalInputHandler;
    InputInventorySlot inputSlot;
    OutputInventorySlot outputSlot;
    ChemicalInventorySlot chemicalSlot;
    EnergyInventorySlot energySlot;

    public TileEntityReplicator(BlockPos pos, BlockState state) {
        super(MoreMachineBlocks.REPLICATOR, pos, state, TRACKED_ERROR_TYPES, 200);
        this.configComponent.setupItemIOExtraConfig((IInventorySlot)this.inputSlot, (IInventorySlot)this.outputSlot, (IInventorySlot)this.chemicalSlot, (IInventorySlot)this.energySlot);
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.configComponent.setupInputConfig(TransmissionType.CHEMICAL, (Object)this.chemicalTank);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM});
        this.chemicalInputHandler = InputHelper.getConstantInputHandler((IChemicalTank)this.chemicalTank);
        this.itemInputHandler = InputHelper.getInputHandler((IInventorySlot)this.inputSlot, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT);
        this.outputHandler = OutputHelper.getOutputHandler((IInventorySlot)this.outputSlot, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE);
    }

    @NotNull
    public IChemicalTankHolder getInitialChemicalTanks(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideWithConfig((ISideConfiguration)this);
        this.chemicalTank = BasicChemicalTank.inputModern((long)10000L, TileEntityReplicator::isValidChemicalInput, (IContentsListener)recipeCacheListener);
        builder.addTank(this.chemicalTank);
        return builder.build();
    }

    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig((ISideConfiguration)this);
        this.energyContainer = MachineEnergyContainer.input((TileEntityMekanism)this, (IContentsListener)recipeCacheUnpauseListener);
        builder.addContainer((IEnergyContainer)this.energyContainer);
        return builder.build();
    }

    @Nullable
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig((ISideConfiguration)this);
        this.inputSlot = InputInventorySlot.at(TileEntityReplicator::isValidItemInput, (IContentsListener)recipeCacheListener, (int)29, (int)32);
        ((InputInventorySlot)builder.addSlot((IInventorySlot)this.inputSlot)).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_MATCHING_RECIPE, this.getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT)));
        this.outputSlot = OutputInventorySlot.at((IContentsListener)recipeCacheUnpauseListener, (int)131, (int)32);
        ((OutputInventorySlot)builder.addSlot((IInventorySlot)this.outputSlot)).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_SPACE_IN_OUTPUT, this.getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE)));
        this.chemicalSlot = ChemicalInventorySlot.fillOrConvert((IChemicalTank)this.chemicalTank, () -> ((TileEntityReplicator)this).getLevel(), (IContentsListener)listener, (int)8, (int)65);
        builder.addSlot((IInventorySlot)this.chemicalSlot);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityReplicator)this).getLevel(), (IContentsListener)listener, (int)152, (int)65);
        builder.addSlot((IInventorySlot)this.energySlot);
        this.chemicalSlot.setSlotOverlay(SlotOverlay.MINUS);
        return builder.build();
    }

    public static boolean isValidChemicalInput(ChemicalStack stack) {
        return stack.is(MoreMachineChemicals.UU_MATTER);
    }

    public static boolean isValidItemInput(ItemStack stack) {
        if (customRecipeMap != null) {
            return customRecipeMap.containsKey(Objects.requireNonNull(RegistryUtils.getName((Holder)stack.getItemHolder())).toString());
        }
        return false;
    }

    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.chemicalSlot.fillTankOrConvert();
        this.recipeCacheLookupMonitor.updateAndProcess();
        return sendUpdatePacket;
    }

    @Nullable
    public MachineEnergyContainer<TileEntityReplicator> getEnergyContainer() {
        return this.energyContainer;
    }

    @NotNull
    public IMekanismRecipeTypeProvider<?, MMBasicItemStackChemicalToItemStackRecipe, ?> getRecipeType() {
        return null;
    }

    @Nullable
    public MMBasicItemStackChemicalToItemStackRecipe getRecipe(int cacheIndex) {
        return TileEntityReplicator.getRecipe((ItemStack)this.itemInputHandler.getInput(), (ChemicalStack)this.chemicalInputHandler.getInput());
    }

    @NotNull
    public CachedRecipe<MMBasicItemStackChemicalToItemStackRecipe> createNewCachedRecipe(@NotNull MMBasicItemStackChemicalToItemStackRecipe recipe, int cacheIndex) {
        return ReplicatorCachedRecipe.createItemReplicator(recipe, this.recheckAllRecipeErrors, this.itemInputHandler, this.chemicalInputHandler, this.outputHandler).setErrorsChanged(x$0 -> this.onErrorsChanged((Set)x$0)).setCanHolderFunction(() -> ((TileEntityReplicator)this).canFunction()).setActive(arg_0 -> ((TileEntityReplicator)this).setActive(arg_0)).setEnergyRequirements(() -> this.energyContainer.getEnergyPerTick(), this.energyContainer).setRequiredTicks(() -> ((TileEntityReplicator)this).getTicksRequired()).setOnFinish(() -> ((TileEntityReplicator)this).markForSave()).setOperatingTicksChanged(x$0 -> this.setOperatingTicks(x$0)).setBaselineMaxOperations(() -> ((TileEntityReplicator)this).getOperationsPerTick());
    }

    @Nullable
    public IRecipeViewerRecipeType<MMBasicItemStackChemicalToItemStackRecipe> recipeViewerType() {
        return MMRecipeViewerRecipeType.REPLICATOR;
    }

    public static MMBasicItemStackChemicalToItemStackRecipe getRecipe(ItemStack itemStack, ChemicalStack chemicalStack) {
        if (chemicalStack.isEmpty() || itemStack.isEmpty()) {
            return null;
        }
        if (customRecipeMap != null) {
            Holder itemHolder = itemStack.getItemHolder();
            int amount = customRecipeMap.getOrDefault(RegistryUtils.getName((Holder)itemHolder).toString(), 0);
            if (amount == 0) {
                return null;
            }
            return new ReplicatorIRecipeSingle((ItemStackIngredient)IngredientCreatorAccess.item().fromHolder(itemHolder, 1), IngredientCreatorAccess.chemicalStack().fromHolder(MoreMachineChemicals.UU_MATTER, amount), new ItemStack(itemHolder, 1));
        }
        return null;
    }

    public boolean isConfigurationDataCompatible(Block type) {
        return super.isConfigurationDataCompatible(type) || MoreMachineUtils.isSameMMTypeFactory((Holder<Block>)this.getBlockHolder(), type);
    }

    public void parseUpgradeData(HolderLookup.Provider provider, @NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof AdvancedMachineUpgradeData) {
            AdvancedMachineUpgradeData data = (AdvancedMachineUpgradeData)upgradeData;
            super.parseUpgradeData(provider, upgradeData);
            this.chemicalTank.deserializeNBT(provider, data.stored.serializeNBT(provider));
            this.chemicalSlot.deserializeNBT(provider, data.chemicalSlot.serializeNBT(provider));
        } else {
            Mekanism.logger.warn("Unhandled upgrade data.", new Throwable());
        }
    }

    @Nullable
    public IUpgradeData getUpgradeData(HolderLookup.Provider provider) {
        return new AdvancedMachineUpgradeData(provider, this.redstone, this.getControlType(), this.getEnergyContainer(), this.getOperatingTicks(), 0L, this.chemicalTank, this.chemicalSlot, this.energySlot, this.inputSlot, this.outputSlot, this.getComponents());
    }
}

