/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.world.content.registries;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import tv.soaryn.xycraft.core.content.registries.IRegister;
import tv.soaryn.xycraft.world.XyWorld;
import tv.soaryn.xycraft.world.content.generation.CaveGeyserPiece;
import tv.soaryn.xycraft.world.content.generation.CaveGeyserStructure;
import tv.soaryn.xycraft.world.content.generation.SurfaceGeyserPiece;
import tv.soaryn.xycraft.world.content.generation.SurfaceGeyserStructure;

public interface WorldStructures {
    public static final IRegister Instance = new IRegister(){

        public void register(IEventBus bus) {
            StructureTypeMap.register(bus);
            StructurePieceTypeMap.register(bus);
        }
    };
    public static final DeferredRegister<StructureType<?>> StructureTypeMap = DeferredRegister.create((ResourceKey)Registries.STRUCTURE_TYPE, (String)"xycraft_world");
    public static final DeferredRegister<StructurePieceType> StructurePieceTypeMap = DeferredRegister.create((ResourceKey)Registries.STRUCTURE_PIECE, (String)"xycraft_world");
    public static final DeferredHolder<StructurePieceType, StructurePieceType> SurfaceNodePiece = StructurePieceTypeMap.register("surface_node_piece", () -> SurfaceGeyserPiece::new);
    public static final DeferredHolder<StructurePieceType, StructurePieceType> CaveNodePiece = StructurePieceTypeMap.register("cave_node_piece", () -> CaveGeyserPiece::new);
    public static final DeferredHolder<StructureType<?>, StructureType<SurfaceGeyserStructure>> SurfaceGeyserType = StructureTypeMap.register("surface_geyser_type", () -> () -> SurfaceGeyserStructure.CODEC);
    public static final DeferredHolder<StructureType<?>, StructureType<CaveGeyserStructure>> CaveGeyserType = StructureTypeMap.register("cave_geyser_type", () -> () -> CaveGeyserStructure.CODEC);
    public static final ResourceKey<Structure> SurfaceGeyser = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)XyWorld.resource("surface_geyser"));
    public static final ResourceKey<Structure> UndergroundGeyser = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)XyWorld.resource("underground_geyser"));
    public static final ResourceKey<StructureSet> HarvestableNodeSet = ResourceKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)XyWorld.resource("harvestable_node_set"));
}

