/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client.gui;

import dev.ftb.mods.ftblibrary.config.ColorConfig;
import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.ImageResourceConfig;
import dev.ftb.mods.ftblibrary.config.ListConfig;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.RainbowIcon;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.ColorSelectorPanel;
import dev.ftb.mods.ftblibrary.ui.ContextMenu;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.MultilineTextBox;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.PanelScrollBar;
import dev.ftb.mods.ftblibrary.ui.ScrollBar;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.KeyModifiers;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.NordColors;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.client.ImageComponent;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.client.gui.FTBQuestsTheme;
import dev.ftb.mods.ftbquests.client.gui.SelectQuestObjectScreen;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.client.gui.quests.ViewQuestPanel;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.util.ConfigQuestObject;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Whence;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultilineTextEditorScreen
extends BaseScreen {
    public static final Icon LINK_ICON = Icon.getIcon((ResourceLocation)FTBQuestsAPI.rl("textures/gui/chain_link.png")).withPadding(2);
    public static final Icon CLEAR_FORMATTING_ICON = Icon.getIcon((ResourceLocation)FTBQuestsAPI.rl("textures/gui/eraser.png")).withPadding(2);
    private static final Pattern STRIP_FORMATTING_PATTERN = Pattern.compile("(?i)([&\\u00A7])([0-9A-FK-ORZ]|#[0-9A-Fa-f]{6})");
    private static final int MAX_UNDO = 10;
    protected static final String LINK_TEXT_TEMPLATE = "{ \"text\": \"%s\", \"underlined\": true, \"clickEvent\": { \"action\": \"change_page\", \"value\": \"%016X\" } }";
    private final Component title;
    private final ListConfig<String, StringConfig> config;
    private final ConfigCallback callback;
    private final Panel outerPanel;
    private final Panel toolbarPanel;
    private final Panel textBoxPanel;
    private final MultilineTextBox textBox;
    private final PanelScrollBar scrollBar;
    private long ticksOpen = 0L;
    private final String initialText;
    private long lastChange = 0L;
    private final Deque<HistoryElement> redoStack = new ArrayDeque<HistoryElement>();
    private final Map<Integer, Runnable> hotKeys = Map.of(66, () -> this.insertFormatting(ChatFormatting.BOLD), 73, () -> this.insertFormatting(ChatFormatting.ITALIC), 85, () -> this.insertFormatting(ChatFormatting.UNDERLINE), 83, () -> this.insertFormatting(ChatFormatting.STRIKETHROUGH), 82, this::resetFormatting, 80, () -> this.insertAtEndOfLine("\n{@pagebreak}"), 77, this::openImageSelector, 90, this::undoLast, 76, this::openLinkInsert);

    public MultilineTextEditorScreen(Component title, ListConfig<String, StringConfig> config, ConfigCallback callback) {
        this.title = title;
        this.config = config;
        this.callback = callback;
        this.outerPanel = new OuterPanel(this);
        this.toolbarPanel = new ToolbarPanel(this.outerPanel);
        this.textBoxPanel = new TextBoxPanel(this.outerPanel);
        this.textBox = new MultilineTextBox(this.textBoxPanel);
        this.textBox.setText(String.join((CharSequence)"\n", (Iterable)config.getValue()));
        this.textBox.setFocused(true);
        this.textBox.setValueListener(this::onValueChanged);
        this.textBox.seekCursor(Whence.ABSOLUTE, 0);
        this.redoStack.addLast(new HistoryElement(this.textBox.getText(), this.textBox.cursorPos()));
        this.scrollBar = new PanelScrollBar(this.outerPanel, ScrollBar.Plane.VERTICAL, this.textBoxPanel);
        this.scrollBar.setScrollStep((double)this.getTheme().getFontHeight());
        this.initialText = this.textBox.getText();
    }

    private void onValueChanged(String newValue) {
        this.lastChange = Minecraft.getInstance().level.getGameTime();
    }

    public void tick() {
        super.tick();
        ++this.ticksOpen;
        if (this.lastChange > 0L && Minecraft.getInstance().level.getGameTime() - this.lastChange > 5L) {
            this.redoStack.addLast(new HistoryElement(this.textBox.getText(), this.textBox.cursorPos()));
            while (this.redoStack.size() > 10) {
                this.redoStack.removeFirst();
            }
            this.lastChange = 0L;
        }
    }

    public boolean onInit() {
        this.setWidth(this.getScreen().getGuiScaledWidth() / 5 * 4);
        this.setHeight(this.getScreen().getGuiScaledHeight() / 5 * 4);
        this.ticksOpen = 0L;
        return true;
    }

    public void addWidgets() {
        this.add((Widget)this.outerPanel);
    }

    public void alignWidgets() {
        this.outerPanel.setPosAndSize(0, 0, this.width, this.height);
        this.toolbarPanel.setPosAndSize(2, 2, this.width - 4, 18);
        this.toolbarPanel.alignWidgets();
        this.textBoxPanel.setPosAndSize(2, this.toolbarPanel.height + 4, this.width - 18, this.height - this.toolbarPanel.height - 6);
        this.textBoxPanel.alignWidgets();
        this.scrollBar.setPosAndSize(this.width - 14, this.textBoxPanel.posY, 12, this.height - this.textBoxPanel.posY - 4);
    }

    public void drawBackground(GuiGraphics matrixStack, Theme theme, int x, int y, int w, int h) {
        super.drawBackground(matrixStack, theme, x, y, w, h);
        theme.drawString(matrixStack, (Object)this.title, x + (this.width - theme.getStringWidth((FormattedText)this.title)) / 2, y - theme.getFontHeight() - 2, 2);
    }

    public boolean keyPressed(Key key) {
        if (key.esc()) {
            this.cancel();
            return true;
        }
        if (key.enter() && Screen.hasShiftDown()) {
            this.saveAndExit();
            return true;
        }
        if (this.textBox.isFocused()) {
            this.textBox.keyPressed(key);
            return true;
        }
        return false;
    }

    public void keyReleased(Key key) {
        this.executeHotkey(key.keyCode, true);
    }

    private void executeHotkey(int keycode, boolean checkModifier) {
        if (this.hotKeys.containsKey(keycode) && (!checkModifier || MultilineTextEditorScreen.isHotKeyModifierPressed(keycode))) {
            this.hotKeys.get(keycode).run();
            this.textBox.setFocused(true);
        }
    }

    public boolean charTyped(char c, KeyModifiers modifiers) {
        if (this.ticksOpen < 2L) {
            return true;
        }
        char keyCode = Character.toUpperCase(c);
        if (MultilineTextEditorScreen.isHotKeyModifierPressed(keyCode) && this.hotKeys.containsKey(keyCode)) {
            return false;
        }
        return super.charTyped(c, modifiers);
    }

    private static boolean isHotKeyModifierPressed(int keycode) {
        return keycode == 90 || Util.getPlatform() == Util.OS.OSX ? Screen.hasControlDown() : Screen.hasAltDown();
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    private void openLinkInsert() {
        ConfigQuestObject config = new ConfigQuestObject(QuestObjectType.QUEST.or(QuestObjectType.QUEST_LINK));
        new SelectQuestObjectScreen(config, accepted -> {
            int pos = this.textBox.cursorPos();
            if (accepted) {
                this.doLinkInsertion(((QuestObject)config.getValue()).id);
            }
            this.run();
            this.textBox.seekCursor(Whence.ABSOLUTE, pos);
        }).openGui();
    }

    private void doLinkInsertion(long questID) {
        String text = this.textBox.getSelectedText();
        if (!text.contains("\n")) {
            MultilineTextBox.StringExtents lineExtents = this.getPhysicalLineExtents();
            MultilineTextBox.StringExtents selectionExtents = this.textBox.getSelected();
            if (lineExtents.start() == lineExtents.end() || selectionExtents.start() == selectionExtents.end()) {
                return;
            }
            String thisLine = this.textBox.getText().substring(lineExtents.start(), lineExtents.end());
            if (thisLine.startsWith("[") && thisLine.endsWith("]")) {
                this.errorToPlayer("ftbquests.gui.error.already_component", new Object[0]);
                return;
            }
            List<String> parts = List.of(this.textBox.getText().substring(lineExtents.start(), selectionExtents.start()), this.textBox.getText().substring(selectionExtents.start(), selectionExtents.end()), this.textBox.getText().substring(selectionExtents.end(), lineExtents.end()));
            StringBuilder builder = new StringBuilder("[ ");
            if (!parts.get(0).isEmpty()) {
                builder.append("\"").append(parts.get(0)).append("\", ");
            }
            builder.append(String.format(LINK_TEXT_TEMPLATE, parts.get(1).isEmpty() ? "EDIT HERE" : parts.get(1), questID));
            if (!parts.get(2).isEmpty()) {
                builder.append(", ").append("\"").append(parts.get(2)).append("\"");
            }
            builder.append(" ]");
            this.textBox.setSelecting(false);
            this.textBox.seekCursor(Whence.ABSOLUTE, lineExtents.start());
            this.textBox.setSelecting(true);
            this.textBox.seekCursor(Whence.ABSOLUTE, lineExtents.end());
            this.textBox.insertText(builder.toString());
        } else {
            this.errorToPlayer("ftbquests.gui.error.selection_multiple_lines", new Object[0]);
        }
    }

    private MultilineTextBox.StringExtents getPhysicalLineExtents() {
        int pos = 0;
        String thisLine = "";
        for (String line : this.textBox.getText().split("\\n")) {
            if (this.textBox.cursorPos() >= pos && this.textBox.cursorPos() < pos + line.length()) {
                thisLine = line;
                break;
            }
            pos += line.length() + 1;
        }
        return new MultilineTextBox.StringExtents(pos, pos + thisLine.length());
    }

    private void errorToPlayer(String msg, Object ... args) {
        QuestScreen.displayError((Component)Component.translatable((String)String.format(msg, args)).withStyle(ChatFormatting.RED));
    }

    private void openImageSelector() {
        int cursor = this.textBox.cursorPos();
        ImageComponent component = new ImageComponent();
        ConfigGroup group = new ConfigGroup("ftbquests", accepted -> {
            this.openGui();
            if (accepted) {
                this.textBox.seekCursor(Whence.ABSOLUTE, cursor);
                this.insertAtEndOfLine("\n" + String.valueOf(component));
            }
        });
        group.add("image", (ConfigValue)new ImageResourceConfig(), (Object)ImageResourceConfig.getResourceLocation((Icon)component.getImage()), v -> component.setImage(Icon.getIcon((ResourceLocation)v)), (Object)ImageResourceConfig.NONE);
        group.addInt("width", component.getWidth(), arg_0 -> ((ImageComponent)component).setWidth(arg_0), 0, 1, 1000);
        group.addInt("height", component.getHeight(), arg_0 -> ((ImageComponent)component).setHeight(arg_0), 0, 1, 1000);
        group.addEnum("align", (Object)component.getAlign(), arg_0 -> ((ImageComponent)component).setAlign(arg_0), ImageComponent.ImageAlign.NAME_MAP, (Object)ImageComponent.ImageAlign.CENTER);
        group.addBool("fit", component.isFit(), arg_0 -> ((ImageComponent)component).setFit(arg_0), false);
        new EditConfigScreen(group).openGui();
    }

    private void cancel() {
        if (!this.textBox.getText().equals(this.initialText)) {
            this.getGui().openYesNo((Component)Component.translatable((String)"ftbquests.gui.confirm_esc"), (Component)Component.empty(), () -> this.callback.save(false));
        } else {
            this.callback.save(false);
        }
    }

    private void saveAndExit() {
        ((List)this.config.getValue()).clear();
        Collections.addAll((Collection)this.config.getValue(), this.textBox.getText().split("\n"));
        this.closeGui();
        this.callback.save(true);
    }

    private void insertFormatting(ChatFormatting c) {
        this.insertFormatting(String.valueOf(c.getChar()));
    }

    private void insertFormatting(ColorConfig color) {
        this.insertFormatting(((Color4I)color.getValue()).toString());
    }

    private void insertFormatting(String formatting) {
        if (this.textBox.hasSelection()) {
            this.textBox.insertText("&" + formatting + this.textBox.getSelectedText() + "&r");
        } else {
            this.textBox.insertText("&" + formatting);
        }
        this.textBox.setFocused(true);
    }

    private void resetFormatting() {
        if (this.textBox.hasSelection()) {
            this.textBox.insertText(MultilineTextEditorScreen.stripFormatting(this.textBox.getSelectedText()));
        } else {
            this.textBox.insertText("&r");
        }
    }

    private static String stripFormatting(@NotNull String selectedText) {
        return STRIP_FORMATTING_PATTERN.matcher(selectedText).replaceAll("");
    }

    private void insertAtEndOfLine(String toInsert) {
        this.textBox.keyPressed(new Key(269, -1, 0));
        this.textBox.insertText(toInsert);
    }

    private void undoLast() {
        if (this.redoStack.size() > 1) {
            this.redoStack.removeLast();
            HistoryElement h = this.redoStack.peekLast();
            this.textBox.setValueListener(s -> {});
            this.textBox.setText(Objects.requireNonNull(h).text());
            this.textBox.setValueListener(this::onValueChanged);
            this.textBox.setSelecting(false);
            this.textBox.seekCursor(Whence.ABSOLUTE, h.cursorPos());
        }
    }

    private class OuterPanel
    extends Panel {
        public OuterPanel(MultilineTextEditorScreen screen) {
            super((Panel)screen);
        }

        public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            theme.drawPanelBackground(graphics, x, y, w, h);
        }

        public void addWidgets() {
            this.addAll(List.of(MultilineTextEditorScreen.this.toolbarPanel, MultilineTextEditorScreen.this.textBoxPanel, MultilineTextEditorScreen.this.scrollBar));
        }

        public void alignWidgets() {
        }
    }

    private class ToolbarPanel
    extends Panel {
        private final ToolbarButton acceptButton;
        private final ToolbarButton cancelButton;
        private final ToolbarButton boldButton;
        private final ToolbarButton italicButton;
        private final ToolbarButton underlineButton;
        private final ToolbarButton strikethroughButton;
        private final ToolbarButton colorButton;
        private final ToolbarButton resetButton;
        private final ToolbarButton pageBreakButton;
        private final ToolbarButton imageButton;
        private final ToolbarButton undoButton;
        private final ToolbarButton linkButton;

        public ToolbarPanel(Panel outerPanel) {
            super(outerPanel);
            this.acceptButton = new ToolbarButton(this, (Component)Component.translatable((String)"gui.accept"), Icons.ACCEPT, MultilineTextEditorScreen.this::saveAndExit).withTooltip(ToolbarPanel.hotkey("Enter", "Shift"));
            this.cancelButton = new ToolbarButton(this, (Component)Component.translatable((String)"gui.cancel"), Icons.CANCEL, MultilineTextEditorScreen.this::cancel).withTooltip(ToolbarPanel.hotkey("Escape", null));
            this.boldButton = new ToolbarButton(this, (Component)Component.literal((String)"B").withStyle(ChatFormatting.BOLD), () -> MultilineTextEditorScreen.this.executeHotkey(66, false)).withTooltip(ToolbarPanel.hotkey("B", "Alt"));
            this.italicButton = new ToolbarButton(this, (Component)Component.literal((String)"I").withStyle(ChatFormatting.ITALIC), () -> MultilineTextEditorScreen.this.executeHotkey(73, false)).withTooltip(ToolbarPanel.hotkey("I", "Alt"));
            this.underlineButton = new ToolbarButton(this, (Component)Component.literal((String)"U").withStyle(ChatFormatting.UNDERLINE), () -> MultilineTextEditorScreen.this.executeHotkey(85, false)).withTooltip(ToolbarPanel.hotkey("U", "Alt"));
            this.strikethroughButton = new ToolbarButton(this, (Component)Component.literal((String)"S").withStyle(ChatFormatting.STRIKETHROUGH), () -> MultilineTextEditorScreen.this.executeHotkey(83, false)).withTooltip(ToolbarPanel.hotkey("S", "Alt"));
            this.colorButton = new ToolbarButton(this, (Component)Component.empty(), Icons.COLOR_RGB.withPadding(2), this::openColorContextMenu);
            this.linkButton = new ToolbarButton(this, (Component)Component.empty(), LINK_ICON, () -> MultilineTextEditorScreen.this.executeHotkey(76, false)).withTooltip(new Component[]{Component.translatable((String)"ftbquests.gui.insert_link"), ToolbarPanel.hotkey("L", "Alt")}).withActivePredicate(this::isOkForLinkInsertion);
            this.resetButton = new ToolbarButton(this, (Component)Component.empty(), CLEAR_FORMATTING_ICON, () -> MultilineTextEditorScreen.this.executeHotkey(82, false)).withTooltip(new Component[]{Component.translatable((String)"ftbquests.gui.clear_formatting"), ToolbarPanel.hotkey("R", "Alt")});
            this.pageBreakButton = new ToolbarButton(this, (Component)Component.empty(), ViewQuestPanel.PAGEBREAK_ICON.withPadding(2), () -> MultilineTextEditorScreen.this.executeHotkey(80, false)).withTooltip(new Component[]{Component.translatable((String)"ftbquests.gui.page_break"), ToolbarPanel.hotkey("P", "Alt")});
            this.imageButton = new ToolbarButton(this, (Component)Component.empty(), Icons.ART.withPadding(2), () -> MultilineTextEditorScreen.this.executeHotkey(77, false)).withTooltip(new Component[]{Component.translatable((String)"ftbquests.chapter.image"), ToolbarPanel.hotkey("M", "Alt")});
            this.undoButton = new ToolbarButton(this, (Component)Component.empty(), Icons.REFRESH, () -> MultilineTextEditorScreen.this.executeHotkey(90, false)).withTooltip(new Component[]{Component.translatable((String)"ftbquests.gui.undo"), ToolbarPanel.hotkey("Z", "Ctrl")});
        }

        private boolean isOkForLinkInsertion() {
            return MultilineTextEditorScreen.this.textBox.hasSelection() && !MultilineTextEditorScreen.this.textBox.getSelectedText().contains("\n");
        }

        private static Component hotkey(String key, @Nullable String modifier) {
            boolean isMac;
            boolean bl = isMac = Util.getPlatform() == Util.OS.OSX;
            String adaptedModifier = modifier != null && modifier.equalsIgnoreCase("alt") ? (isMac ? "Ctrl" : "Alt") : modifier;
            Object modifierDisplay = modifier == null ? "" : adaptedModifier + " + ";
            return Component.literal((String)("[" + (String)modifierDisplay + key + "]")).withStyle(ChatFormatting.DARK_GRAY);
        }

        private void openColorContextMenu() {
            ArrayList<ContextMenuItem> items = new ArrayList<ContextMenuItem>();
            for (ChatFormatting cf : ChatFormatting.values()) {
                if (cf.getColor() == null) continue;
                items.add(new ContextMenuItem((Component)Component.empty(), (Icon)Color4I.rgb((int)cf.getColor()), b -> MultilineTextEditorScreen.this.insertFormatting(cf)));
            }
            ColorConfig colorConfig = new ColorConfig();
            items.add(new ContextMenuItem((Component)Component.empty(), Icons.COLOR_HSB, btn -> ColorSelectorPanel.popupAtMouse((BaseScreen)this.parent.getGui(), (ColorConfig)colorConfig, b -> {
                if (b) {
                    MultilineTextEditorScreen.this.insertFormatting(colorConfig);
                }
            })));
            items.add(new ContextMenuItem((Component)Component.empty(), (Icon)new RainbowIcon(), btn -> MultilineTextEditorScreen.this.insertFormatting("z")));
            ContextMenu cMenu = new ContextMenu((Panel)MultilineTextEditorScreen.this, items);
            cMenu.setMaxRows(4);
            cMenu.setDrawVerticalSeparators(false);
            MultilineTextEditorScreen.this.openContextMenu(cMenu);
        }

        public void tick() {
            this.undoButton.setVisible(MultilineTextEditorScreen.this.redoStack.size() > 1);
        }

        public void addWidgets() {
            this.addAll(List.of(this.acceptButton, this.cancelButton, this.boldButton, this.italicButton, this.underlineButton, this.strikethroughButton, this.colorButton, this.linkButton, this.resetButton, this.pageBreakButton, this.imageButton, this.undoButton));
        }

        public void alignWidgets() {
            this.acceptButton.setPosAndSize(1, 1, 16, 16);
            this.boldButton.setPosAndSize(27, 1, 16, 16);
            this.italicButton.setPosAndSize(43, 1, 16, 16);
            this.underlineButton.setPosAndSize(59, 1, 16, 16);
            this.strikethroughButton.setPosAndSize(75, 1, 16, 16);
            this.colorButton.setPosAndSize(91, 1, 16, 16);
            this.linkButton.setPosAndSize(107, 1, 16, 16);
            this.resetButton.setPosAndSize(123, 1, 16, 16);
            this.pageBreakButton.setPosAndSize(149, 1, 16, 16);
            this.imageButton.setPosAndSize(165, 1, 16, 16);
            this.undoButton.setPosAndSize(191, 1, 16, 16);
            this.cancelButton.setPosAndSize(this.width - 17, 1, 16, 16);
        }

        public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            NordColors.POLAR_NIGHT_0.draw(graphics, x, y, w, h);
            theme.drawPanelBackground(graphics, x, y, w, h);
        }
    }

    private class TextBoxPanel
    extends Panel {
        private int cursorPos;

        public TextBoxPanel(Panel outerPanel) {
            super(outerPanel);
        }

        public void addWidgets() {
            this.add((Widget)MultilineTextEditorScreen.this.textBox);
        }

        public void refreshWidgets() {
            this.cursorPos = MultilineTextEditorScreen.this.textBox.cursorPos();
            super.refreshWidgets();
        }

        public void alignWidgets() {
            MultilineTextEditorScreen.this.textBox.setWidth(this.width - 3);
            this.setScrollY(0.0);
            MultilineTextEditorScreen.this.textBox.seekCursor(Whence.ABSOLUTE, this.cursorPos);
        }

        public boolean mousePressed(MouseButton button) {
            boolean res = super.mousePressed(button);
            MultilineTextEditorScreen.this.textBox.setFocused(this.isMouseOver());
            return res;
        }
    }

    private record HistoryElement(@NotNull String text, int cursorPos) {
    }

    private static class ToolbarButton
    extends SimpleTextButton {
        private final Runnable onClick;
        private final List<Component> tooltip = new ArrayList<Component>();
        private boolean visible = true;
        private BooleanSupplier activePredicate = () -> true;

        public ToolbarButton(Panel panel, Component txt, Icon icon, Runnable onClick) {
            super(panel, txt, icon);
            this.onClick = onClick;
        }

        public ToolbarButton(Panel panel, Component txt, Runnable onClick) {
            this(panel, txt, (Icon)Color4I.empty(), onClick);
        }

        public Component getTitle() {
            return this.activePredicate.getAsBoolean() ? super.getTitle() : super.getTitle().copy().withStyle(ChatFormatting.DARK_GRAY);
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        public void onClicked(MouseButton button) {
            if (this.visible && this.activePredicate.getAsBoolean()) {
                this.onClick.run();
            }
        }

        public void addMouseOverText(TooltipList list) {
            if (this.getGui().getTheme().getStringWidth((FormattedText)this.title) > 0) {
                super.addMouseOverText(list);
            }
            if (this.visible) {
                this.tooltip.forEach(arg_0 -> ((TooltipList)list).add(arg_0));
            }
        }

        public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            if (this.visible) {
                super.draw(graphics, theme, x, y, w, h);
            }
        }

        public ToolbarButton withTooltip(Component ... lines) {
            this.tooltip.addAll(Arrays.asList(lines));
            return this;
        }

        public ToolbarButton withActivePredicate(BooleanSupplier predicate) {
            this.activePredicate = predicate;
            return this;
        }
    }
}

