/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client.gui.quests;

import com.mojang.datafixers.util.Pair;
import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.ImageResourceConfig;
import dev.ftb.mods.ftblibrary.config.ListConfig;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.config.ui.EditStringConfigOverlay;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.BlankPanel;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.ColorWidget;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.CursorType;
import dev.ftb.mods.ftblibrary.ui.ModalPanel;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.TextField;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.VerticalSpaceWidget;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.CompactGridLayout;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.client.ImageComponent;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.FTBQuestsClientConfig;
import dev.ftb.mods.ftbquests.client.gui.ImageComponentWidget;
import dev.ftb.mods.ftbquests.client.gui.MultilineTextEditorScreen;
import dev.ftb.mods.ftbquests.client.gui.quests.AddRewardButton;
import dev.ftb.mods.ftbquests.client.gui.quests.AddTaskButton;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.client.gui.quests.RewardButton;
import dev.ftb.mods.ftbquests.client.gui.quests.TaskButton;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.net.ReorderItemMessage;
import dev.ftb.mods.ftbquests.net.TogglePinnedMessage;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestLink;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardAutoClaim;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.theme.QuestTheme;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import dev.ftb.mods.ftbquests.quest.translation.TranslationKey;
import dev.ftb.mods.ftbquests.util.TextUtils;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewQuestPanel
extends ModalPanel {
    public static final Icon PAGEBREAK_ICON = Icon.getIcon((ResourceLocation)FTBQuestsAPI.rl("textures/gui/pagebreak.png"));
    private final QuestScreen questScreen;
    private Quest quest = null;
    private Icon icon = Color4I.empty();
    private Button buttonOpenDependencies;
    private BlankPanel panelContent;
    private BlankPanel panelTasks;
    private BlankPanel panelRewards;
    private BlankPanel panelText;
    private TextField titleField;
    private final List<Pair<Integer, Integer>> pageIndices = new ArrayList<Pair<Integer, Integer>>();
    private final Long2IntMap currentPages = new Long2IntOpenHashMap();
    private long lastScrollTime = 0L;

    public ViewQuestPanel(QuestScreen questScreen) {
        super((Panel)questScreen);
        this.questScreen = questScreen;
        this.setPosAndSize(-1, -1, 0, 0);
        this.setOnlyRenderWidgetsInside(true);
        this.setOnlyInteractWithWidgetsInside(true);
        this.setExtraZlevel(1250);
    }

    public void onClosed() {
        this.quest = null;
        this.updateMouseOver(this.getMouseX(), this.getMouseY());
    }

    public boolean checkMouseOver(int mouseX, int mouseY) {
        return this.quest != null && super.checkMouseOver(mouseX, mouseY);
    }

    public Quest getViewedQuest() {
        return this.quest;
    }

    public void setViewedQuest(Quest newQuest) {
        if (this.quest != newQuest) {
            this.quest = newQuest;
            this.refreshWidgets();
        }
    }

    public boolean canEdit() {
        return this.quest.getQuestFile().canEdit();
    }

    private void buildPageIndices() {
        this.pageIndices.clear();
        if (this.quest != null) {
            this.pageIndices.addAll(this.quest.buildDescriptionIndex());
        }
    }

    private int getCurrentPage() {
        if (this.quest == null) {
            return 0;
        }
        int page = this.currentPages.getOrDefault(this.quest.id, 0);
        if (page < 0 || page >= this.pageIndices.size()) {
            page = 0;
            this.currentPages.put(this.quest.id, 0);
        }
        return page;
    }

    private void setCurrentPage(int page) {
        if (this.quest != null) {
            this.currentPages.put(this.quest.id, page);
        }
    }

    public void addWidgets() {
        SimpleButton buttonOpenDependants;
        this.setPosAndSize(-1, -1, 1, 1);
        if (this.quest == null) {
            return;
        }
        QuestObjectBase prev = QuestTheme.currentObject;
        QuestTheme.currentObject = this.quest;
        this.setScrollX(0.0);
        this.setScrollY(0.0);
        this.icon = this.quest.getIcon();
        boolean canEdit = this.questScreen.file.canEdit();
        this.titleField = new QuestDescriptionField((Panel)this, canEdit, TranslationKey.TITLE, (b, clickedW) -> this.editTitle()).addFlags(4).setMinWidth(150).setMaxWidth(500).setSpacing(9).setText((Component)Component.empty().withColor(((Color4I)ThemeProperties.QUEST_VIEW_TITLE.get()).rgb()).append(this.quest.getTitle()));
        int w = Math.max(200, this.titleField.width + 54);
        if (this.quest.getMinWidth() > 0) {
            w = Math.max(this.quest.getMinWidth(), w);
        } else if (this.questScreen.selectedChapter.getDefaultMinWidth() > 0) {
            w = Math.max(this.questScreen.selectedChapter.getDefaultMinWidth(), w);
        }
        this.titleField.setPosAndSize(27, 4, w - 54, this.titleField.height);
        this.add((Widget)this.titleField);
        this.panelContent = new BlankPanel((Panel)this, "ContentPanel");
        this.add((Widget)this.panelContent);
        this.panelTasks = new BlankPanel((Panel)this.panelContent, "TasksPanel");
        this.panelContent.add((Widget)this.panelTasks);
        this.panelRewards = new BlankPanel((Panel)this.panelContent, "RewardsPanel");
        this.panelContent.add((Widget)this.panelRewards);
        this.panelText = new BlankPanel((Panel)this.panelContent, "TextPanel");
        this.panelContent.add((Widget)this.panelText);
        int bsize = 18;
        boolean seq = this.quest.getRequireSequentialTasks();
        for (Task task : this.quest.getTasks()) {
            TaskButton taskButton = new TaskButton((Panel)this.panelTasks, task);
            this.panelTasks.add((Widget)taskButton);
            taskButton.setSize(bsize, bsize);
            if (canEdit || !seq || this.questScreen.file.selfTeamData.isCompleted(task)) continue;
            break;
        }
        if (!canEdit && this.panelTasks.getWidgets().isEmpty()) {
            Object noTasks = new DisabledButtonTextField((Panel)this.panelTasks, (Component)Component.translatable((String)"ftbquests.gui.no_tasks"));
            noTasks.setSize(((DisabledButtonTextField)((Object)noTasks)).width + 8, bsize);
            noTasks.setColor((Color4I)ThemeProperties.DISABLED_TEXT_COLOR.get(this.quest));
            this.panelTasks.add(noTasks);
        }
        for (Reward reward : this.quest.getRewards()) {
            if (!canEdit && (this.questScreen.file.selfTeamData.isRewardBlocked(reward) || reward.getAutoClaimType() == RewardAutoClaim.INVISIBLE)) continue;
            RewardButton b2 = new RewardButton((Panel)this.panelRewards, reward);
            this.panelRewards.add((Widget)b2);
            b2.setSize(bsize, bsize);
        }
        if (!canEdit && this.panelRewards.getWidgets().isEmpty()) {
            DisabledButtonTextField noRewards = new DisabledButtonTextField((Panel)this.panelRewards, (Component)Component.translatable((String)"ftbquests.gui.no_rewards"));
            noRewards.setSize(noRewards.width + 8, bsize);
            noRewards.setColor((Color4I)ThemeProperties.DISABLED_TEXT_COLOR.get(this.quest));
            this.panelRewards.add((Widget)noRewards);
        }
        if (this.questScreen.file.canEdit()) {
            this.panelTasks.add((Widget)new AddTaskButton((Panel)this.panelTasks, this.quest));
            this.panelRewards.add((Widget)new AddRewardButton((Panel)this.panelRewards, this.quest));
        }
        int ww = 0;
        for (Widget widget2 : this.panelTasks.getWidgets()) {
            ww = Math.max(ww, widget2.width);
        }
        for (Widget widget2 : this.panelRewards.getWidgets()) {
            ww = Math.max(ww, widget2.width);
        }
        Color4I color4I = (Color4I)ThemeProperties.QUEST_VIEW_BORDER.get(this.questScreen.selectedChapter);
        ww = Mth.clamp((int)ww, (int)70, (int)140);
        w = Math.max(w, ww * 2 + 10);
        if ((Integer)ThemeProperties.FULL_SCREEN_QUEST.get(this.quest) == 1) {
            w = this.questScreen.width - 1;
        }
        if (w % 2 == 0) {
            ++w;
        }
        this.setWidth(w);
        this.panelContent.setPosAndSize(0, Math.max(16, this.titleField.height + 8), w, 0);
        int iconSize = Math.min(16, this.titleField.height + 2);
        CloseViewQuestButton buttonClose = new CloseViewQuestButton();
        this.add((Widget)buttonClose);
        buttonClose.setPosAndSize(w - iconSize - 2, 4, iconSize, iconSize);
        PinViewQuestButton buttonPin = new PinViewQuestButton();
        this.add((Widget)buttonPin);
        buttonPin.setPosAndSize(w - iconSize * 2 - 4, 4, iconSize, iconSize);
        if (this.questScreen.selectedChapter.id != this.quest.getChapter().id) {
            GotoLinkedQuestButton b3 = new GotoLinkedQuestButton();
            this.add((Widget)b3);
            b3.setPosAndSize(iconSize + 4, 0, iconSize, iconSize);
        }
        ArrayList<QuestLink> links = new ArrayList<QuestLink>();
        this.questScreen.file.forAllChapters(chapter -> chapter.getQuestLinks().stream().filter(link -> chapter != this.questScreen.selectedChapter && link.linksTo(this.quest)).forEach(links::add));
        ViewQuestLinksButton linksButton = new ViewQuestLinksButton(links);
        this.add((Widget)linksButton);
        linksButton.setPosAndSize(w - iconSize * 3 - 4, 0, iconSize, iconSize);
        if (!this.quest.hasDependencies()) {
            this.buttonOpenDependencies = new SimpleButton((Panel)this, (Component)Component.translatable((String)"ftbquests.gui.no_dependencies"), Icon.getIcon((String)"ftbquests:textures/gui/arrow_left.png").withTint(color4I), (widget, button) -> {});
            this.add((Widget)this.buttonOpenDependencies);
        } else {
            this.buttonOpenDependencies = new SimpleButton((Panel)this, (Component)Component.translatable((String)"ftbquests.gui.view_dependencies"), Icon.getIcon((String)"ftbquests:textures/gui/arrow_left.png").withTint((Color4I)ThemeProperties.QUEST_VIEW_TITLE.get()), (widget, button) -> this.showList(this.quest.streamDependencies().toList(), true));
            this.add((Widget)this.buttonOpenDependencies);
        }
        if (this.quest.getDependants().isEmpty()) {
            buttonOpenDependants = new SimpleButton((Panel)this, (Component)Component.translatable((String)"ftbquests.gui.no_dependants"), Icon.getIcon((String)"ftbquests:textures/gui/arrow_right.png").withTint(color4I), (widget, button) -> {});
            this.add((Widget)buttonOpenDependants);
        } else {
            buttonOpenDependants = new SimpleButton((Panel)this, (Component)Component.translatable((String)"ftbquests.gui.view_dependants"), Icon.getIcon((String)"ftbquests:textures/gui/arrow_right.png").withTint((Color4I)ThemeProperties.QUEST_VIEW_TITLE.get()), (widget, button) -> this.showList(this.quest.getDependants(), false));
            this.add((Widget)buttonOpenDependants);
        }
        this.buttonOpenDependencies.setPosAndSize(0, this.panelContent.posY + 2, 13, 13);
        buttonOpenDependants.setPosAndSize(w - 13, this.panelContent.posY + 2, 13, 13);
        TextField textFieldTasks = new TextField(this, (Panel)this.panelContent){

            public TextField resize(Theme theme) {
                return this;
            }
        };
        int w2 = w / 2;
        textFieldTasks.setPosAndSize(2, 2, w2 - 3, 13);
        textFieldTasks.setMaxWidth(w);
        textFieldTasks.addFlags(36);
        textFieldTasks.setText((Component)Component.translatable((String)"ftbquests.tasks"));
        textFieldTasks.setColor((Color4I)ThemeProperties.TASKS_TEXT_COLOR.get(this.quest));
        this.panelContent.add((Widget)textFieldTasks);
        TextField textFieldRewards = new TextField(this, (Panel)this.panelContent){

            public TextField resize(Theme theme) {
                return this;
            }
        };
        textFieldRewards.setPosAndSize(w2 + 2, 2, w2 - 3, 13);
        textFieldRewards.setMaxWidth(w);
        textFieldRewards.addFlags(36);
        textFieldRewards.setText((Component)Component.translatable((String)"ftbquests.rewards"));
        textFieldRewards.setColor((Color4I)ThemeProperties.REWARDS_TEXT_COLOR.get(this.quest));
        this.panelContent.add((Widget)textFieldRewards);
        this.panelTasks.setPosAndSize(2, 16, w2 - 3, 0);
        this.panelRewards.setPosAndSize(w2 + 2, 16, w2 - 3, 0);
        int at = this.panelTasks.align((WidgetLayout)new CompactGridLayout(bsize + 2));
        int ar = this.panelRewards.align((WidgetLayout)new CompactGridLayout(bsize + 2));
        int h = Math.max(at, ar);
        this.panelTasks.setHeight(h);
        this.panelRewards.setHeight(h);
        int tox = (this.panelTasks.width - this.panelTasks.getContentWidth()) / 2;
        int rox = (this.panelRewards.width - this.panelRewards.getContentWidth()) / 2;
        int toy = (this.panelTasks.height - this.panelTasks.getContentHeight()) / 2;
        int roy = (this.panelRewards.height - this.panelRewards.getContentHeight()) / 2;
        for (Widget widget3 : this.panelTasks.getWidgets()) {
            widget3.setX(widget3.posX + tox);
            widget3.setY(widget3.posY + toy);
        }
        for (Widget widget3 : this.panelRewards.getWidgets()) {
            widget3.setX(widget3.posX + rox);
            widget3.setY(widget3.posY + roy);
        }
        this.panelText.setPosAndSize(3, 16 + h + 12, w - 6, 0);
        Component subtitle = this.quest.getSubtitle();
        if (TextUtils.isComponentEmpty(subtitle) && canEdit) {
            subtitle = Component.literal((String)"[No Subtitle]");
        }
        if (!TextUtils.isComponentEmpty(subtitle)) {
            this.panelText.add((Widget)new QuestDescriptionField((Panel)this.panelText, canEdit, TranslationKey.QUEST_SUBTITLE, (b, clickedW) -> this.editSubtitle()).addFlags(4).setMinWidth(this.panelText.width).setMaxWidth(this.panelText.width).setSpacing(9).setText((Component)Component.empty().withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}).append(subtitle)));
        }
        boolean showText = !this.quest.getHideTextUntilComplete().get(false) || this.questScreen.file.selfTeamData != null && this.questScreen.file.selfTeamData.isCompleted(this.quest);
        this.buildPageIndices();
        if (showText) {
            if (!this.pageIndices.isEmpty()) {
                this.addDescriptionText(canEdit, subtitle);
            }
            if (!this.quest.getGuidePage().isEmpty()) {
                if (!TextUtils.isComponentEmpty(subtitle)) {
                    this.panelText.add((Widget)new VerticalSpaceWidget((Panel)this.panelText, 7));
                }
                this.panelText.add((Widget)new OpenInGuideButton((Panel)this.panelText, this.quest));
            }
        }
        if (this.pageIndices.size() > 1 || canEdit) {
            this.addButtonBar(canEdit);
        }
        if (this.panelText.getWidgets().isEmpty()) {
            this.panelContent.add(new ColorWidget((Panel)this.panelContent, color4I, null).setPosAndSize(w2, 0, 1, h + 40));
            this.panelText.setHeight(0);
            this.setHeight(Math.min(this.panelContent.getContentHeight(), this.parent.height - 10));
        } else {
            this.panelContent.add(new ColorWidget((Panel)this.panelContent, color4I, null).setPosAndSize(w2, 0, 1, 16 + h + 6));
            this.panelContent.add(new ColorWidget((Panel)this.panelContent, color4I, null).setPosAndSize(1, 16 + h + 6, w - 2, 1));
            this.panelText.setHeight(this.panelText.align((WidgetLayout)new WidgetLayout.Vertical(0, 1, 2)));
            this.setHeight(Math.min(this.panelContent.getContentHeight() + this.titleField.height + 12, this.parent.height - 10));
        }
        if ((Integer)ThemeProperties.FULL_SCREEN_QUEST.get(this.quest) == 1) {
            this.height = this.questScreen.height;
        }
        this.setPos((this.parent.width - this.width) / 2, (this.parent.height - this.height) / 2);
        this.panelContent.setHeight(this.height - 17);
        QuestTheme.currentObject = prev;
    }

    private void addDescriptionText(boolean canEdit, Component subtitle) {
        Pair<Integer, Integer> pageSpan = this.pageIndices.get(this.getCurrentPage());
        if (!TextUtils.isComponentEmpty(subtitle)) {
            this.panelText.add((Widget)new VerticalSpaceWidget((Panel)this.panelText, 7));
        }
        for (int i = ((Integer)pageSpan.getFirst()).intValue(); i <= (Integer)pageSpan.getSecond() && i < this.quest.getDescription().size(); ++i) {
            Component component = this.quest.getDescription().get(i);
            ImageComponent img = this.findImageComponent(component);
            if (img != null) {
                this.panelText.add((Widget)this.makeImageComponentWidget(img, i));
                continue;
            }
            int line = i;
            TextField field = new QuestDescriptionField((Panel)this.panelText, canEdit, TranslationKey.QUEST_DESC, (context, clickedW) -> this.editDescLine((Widget)clickedW, line, (boolean)context, null)).setMaxWidth(this.panelText.width).setSpacing(9).setText(component);
            field.setWidth(this.panelText.width);
            this.panelText.add((Widget)field);
        }
    }

    @NotNull
    private ImageComponentWidget makeImageComponentWidget(ImageComponent img, int idx) {
        ImageComponentWidget cw = new ImageComponentWidget(this, (Panel)this.panelText, img, idx);
        if (cw.getComponent().isFit()) {
            double scale = (double)this.panelText.width / (double)cw.width;
            cw.setSize((int)((double)cw.width * scale), (int)((double)cw.height * scale));
        } else if (cw.getComponent().getAlign() == ImageComponent.ImageAlign.CENTER) {
            cw.setX((this.panelText.width - cw.width) / 2);
        } else if (cw.getComponent().getAlign() == ImageComponent.ImageAlign.RIGHT) {
            cw.setX(this.panelText.width - cw.width);
        } else {
            cw.setX(0);
        }
        return cw;
    }

    private void addButtonBar(boolean canEdit) {
        this.panelText.add((Widget)new VerticalSpaceWidget((Panel)this.panelText, 3));
        BlankPanel buttonPanel = new BlankPanel((Panel)this.panelText);
        buttonPanel.setSize(this.panelText.width, 15);
        this.panelText.add((Widget)buttonPanel);
        int currentPage = this.getCurrentPage();
        MutableComponent page = Component.literal((String)(currentPage + 1 + "/" + this.pageIndices.size())).withStyle(ChatFormatting.GRAY);
        int labelWidth = this.questScreen.getTheme().getStringWidth((FormattedText)page);
        if (currentPage > 0) {
            buttonPanel.add((Widget)this.makePrevPageButton((Panel)buttonPanel, currentPage, labelWidth));
        }
        if (this.pageIndices.size() > 1) {
            TextField pageLabel = new TextField((Panel)buttonPanel);
            pageLabel.setText((Component)page);
            pageLabel.setPosAndSize(this.panelText.width - 24 - labelWidth, 3, 20, 14);
            buttonPanel.add((Widget)pageLabel);
        }
        if (currentPage < this.pageIndices.size() - 1) {
            buttonPanel.add((Widget)this.makeNextPageButton((Panel)buttonPanel, currentPage));
        }
        if (canEdit) {
            SimpleTextButton edit = new SimpleTextButton((Panel)buttonPanel, (Component)Component.translatable((String)"ftbquests.gui.edit").append(" \u25bc"), (Icon)ThemeProperties.EDIT_ICON.get()){

                public void onClicked(MouseButton mouseButton) {
                    ViewQuestPanel.this.openEditButtonContextMenu();
                }
            };
            edit.setX((this.panelText.width - edit.width) / 2);
            edit.setHeight(14);
            buttonPanel.add((Widget)edit);
        }
    }

    @NotNull
    private SimpleTextButton makeNextPageButton(Panel buttonPanel, final int currentPage) {
        SimpleTextButton nextPage = new SimpleTextButton(buttonPanel, (Component)Component.empty(), (Icon)ThemeProperties.RIGHT_ARROW.get()){

            public void onClicked(MouseButton mouseButton) {
                ViewQuestPanel.this.setCurrentPage(Math.min(ViewQuestPanel.this.pageIndices.size() + 1, currentPage + 1));
                ViewQuestPanel.this.refreshWidgets();
            }

            public void addMouseOverText(TooltipList list) {
                list.add((Component)Component.literal((String)"[Page Down]").withStyle(ChatFormatting.DARK_GRAY));
                list.add((Component)Component.literal((String)"[Mousewheel Down]").withStyle(ChatFormatting.DARK_GRAY));
            }
        };
        nextPage.setPosAndSize(this.panelText.width - 21, nextPage.getPosY(), 16, 14);
        return nextPage;
    }

    @NotNull
    private SimpleTextButton makePrevPageButton(Panel buttonPanel, final int currentPage, int labelWidth) {
        SimpleTextButton prevPage = new SimpleTextButton(buttonPanel, (Component)Component.empty(), (Icon)ThemeProperties.LEFT_ARROW.get()){

            public void onClicked(MouseButton mouseButton) {
                ViewQuestPanel.this.setCurrentPage(Math.max(0, currentPage - 1));
                ViewQuestPanel.this.refreshWidgets();
            }

            public void addMouseOverText(TooltipList list) {
                list.add((Component)Component.literal((String)"[Page Up]").withStyle(ChatFormatting.DARK_GRAY));
                list.add((Component)Component.literal((String)"[Mousewheel Up]").withStyle(ChatFormatting.DARK_GRAY));
            }
        };
        prevPage.setPosAndSize(this.panelText.width - 43 - labelWidth, prevPage.getPosY(), 16, 14);
        return prevPage;
    }

    private ImageComponent findImageComponent(Component c) {
        ComponentContents componentContents = c.getContents();
        if (componentContents instanceof ImageComponent) {
            ImageComponent img = (ImageComponent)componentContents;
            return img;
        }
        Iterator iterator = c.getSiblings().iterator();
        if (iterator.hasNext()) {
            Component c1 = (Component)iterator.next();
            ComponentContents componentContents2 = c1.getContents();
            if (componentContents2 instanceof ImageComponent) {
                ImageComponent img = (ImageComponent)componentContents2;
                return img;
            }
            return this.findImageComponent(c1);
        }
        return null;
    }

    public void alignWidgets() {
    }

    public void tick() {
        super.tick();
        if (this.quest != null && this.quest.hasDependencies() && !this.questScreen.file.selfTeamData.canStartTasks(this.quest) && this.buttonOpenDependencies != null) {
            float red = Mth.sin((float)((float)(System.currentTimeMillis() % 1200L) * 0.0026179939f));
            Color4I col = Color4I.rgb((int)((int)(red * 127.0f + 63.0f)), (int)0, (int)0);
            this.buttonOpenDependencies.setIcon(Icon.getIcon((String)"ftbquests:textures/gui/arrow_left.png").withTint(col));
        }
    }

    private void syncQuestToServer() {
        NetworkManager.sendToServer((CustomPacketPayload)EditObjectMessage.forQuestObject(this.quest));
    }

    private void showList(Collection<QuestObject> c, boolean dependencies) {
        int hidden = 0;
        ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
        if (dependencies && this.quest.getMinRequiredDependencies() > 0) {
            contextMenu.add(new ContextMenuItem((Component)Component.translatable((String)"ftbquests.quest.min_required_header", (Object[])new Object[]{this.quest.getMinRequiredDependencies()}).withStyle(ChatFormatting.UNDERLINE), (Icon)Color4I.empty(), null).setEnabled(false));
        }
        for (QuestObject object : c) {
            if (this.questScreen.file.canEdit() || object.isSearchable(this.questScreen.file.selfTeamData)) {
                MutableComponent title = object.getMutableTitle();
                if (object.getQuestChapter() != null && object.getQuestChapter() != this.quest.getQuestChapter()) {
                    MutableComponent suffix = Component.literal((String)" [").append(object.getQuestChapter().getTitle()).append("]").withStyle(ChatFormatting.GRAY);
                    title.append((Component)suffix);
                }
                contextMenu.add(new ContextMenuItem((Component)title, (Icon)Color4I.empty(), button -> this.questScreen.open(object, true)));
                continue;
            }
            ++hidden;
        }
        if (hidden > 0) {
            MutableComponent prefix = hidden == c.size() ? Component.empty() : Component.literal((String)"+ ");
            contextMenu.add(new ContextMenuItem((Component)prefix.append((Component)Component.translatable((String)"ftbquests.quest.hidden_quests_footer", (Object[])new Object[]{hidden})), (Icon)Color4I.empty(), null).setEnabled(false));
        }
        this.getGui().openContextMenu(contextMenu);
    }

    public void keyReleased(Key key) {
        if (this.quest == null) {
            return;
        }
        if (this.questScreen.file.canEdit()) {
            switch (key.keyCode) {
                case 83: {
                    this.editSubtitle();
                    break;
                }
                case 84: {
                    this.editTitle();
                    break;
                }
                case 68: {
                    this.editDescription();
                    break;
                }
                case 80: {
                    this.addPageBreak();
                    break;
                }
                case 76: {
                    this.editDescLine0((Widget)this, -1, null);
                    break;
                }
                case 73: {
                    this.editDescLine0((Widget)this, -1, new ImageComponent());
                    break;
                }
                case 81: {
                    this.quest.onEditButtonClicked((Runnable)((Object)this.questScreen));
                    break;
                }
                case 263: {
                    this.moveTasksAndRewards(false);
                    break;
                }
                case 262: {
                    this.moveTasksAndRewards(true);
                }
            }
        } else {
            switch (key.keyCode) {
                case 263: 
                case 266: {
                    this.setCurrentPage(Math.max(0, this.getCurrentPage() - 1));
                    this.refreshWidgets();
                    break;
                }
                case 262: 
                case 267: {
                    this.setCurrentPage(Math.min(this.pageIndices.size() - 1, this.getCurrentPage() + 1));
                    this.refreshWidgets();
                }
            }
        }
    }

    private void moveTasksAndRewards(boolean moveRight) {
        for (Panel panel : List.of(this.panelTasks, this.panelRewards)) {
            for (Widget w : panel.getWidgets()) {
                RewardButton b;
                TaskButton b2;
                if (w instanceof TaskButton && (b2 = (TaskButton)w).isMouseOver()) {
                    NetworkManager.sendToServer((CustomPacketPayload)new ReorderItemMessage(b2.task.getId(), moveRight));
                    return;
                }
                if (!(w instanceof RewardButton) || !(b = (RewardButton)w).isMouseOver()) continue;
                NetworkManager.sendToServer((CustomPacketPayload)new ReorderItemMessage(b.reward.getId(), moveRight));
                return;
            }
        }
        int newPage = Mth.clamp((int)(this.getCurrentPage() + (moveRight ? 1 : -1)), (int)0, (int)(this.pageIndices.size() - 1));
        this.setCurrentPage(newPage);
        this.refreshWidgets();
    }

    private void editTitle() {
        StringConfig c = new StringConfig(null);
        QuestObject qo = this.panelTasks.getWidgets().stream().filter(w -> {
            TaskButton b;
            return w instanceof TaskButton && (b = (TaskButton)((Object)w)).isMouseOver();
        }).map(w -> (TaskButton)((Object)w)).findFirst().map(b -> b.task).orElse(this.quest);
        c.setValue((Object)qo.getRawTitle());
        EditStringConfigOverlay overlay = new EditStringConfigOverlay((Panel)this.getGui(), (ConfigFromString)c, accepted -> {
            if (accepted) {
                qo.setRawTitle((String)c.getValue());
                NetworkManager.sendToServer((CustomPacketPayload)EditObjectMessage.forQuestObject(qo));
            }
        }, (Component)Component.translatable((String)"ftbquests.title.tooltip")).atPosition(this.titleField.getX(), this.titleField.getY() - 14);
        overlay.setWidth(Math.max(150, overlay.getWidth()));
        this.getGui().pushModalPanel((ModalPanel)overlay);
    }

    private void editSubtitle() {
        StringConfig c = new StringConfig(null);
        c.setValue((Object)this.quest.getRawSubtitle());
        EditStringConfigOverlay overlay = new EditStringConfigOverlay((Panel)this.getGui(), (ConfigFromString)c, accepted -> {
            if (accepted) {
                this.quest.setRawSubtitle((String)c.getValue());
                this.syncQuestToServer();
            }
        }, (Component)Component.translatable((String)"ftbquests.chapter.subtitle"));
        overlay.setWidth(Mth.clamp((int)overlay.getWidth(), (int)150, (int)(this.getScreen().getGuiScaledWidth() - 20)));
        overlay.setPos(this.panelText.getX() + (this.panelText.width - overlay.width) / 2, this.panelText.getY() - 14);
        this.getGui().pushModalPanel((ModalPanel)overlay);
    }

    private void editDescription() {
        ListConfig lc = new ListConfig((ConfigValue)new StringConfig());
        lc.setValue(new ArrayList<String>(this.quest.getRawDescription()));
        new MultilineTextEditorScreen((Component)Component.translatable((String)"ftbquests.gui.edit_description"), (ListConfig<String, StringConfig>)lc, accepted -> {
            if (accepted) {
                this.quest.setRawDescription((List)lc.getValue());
                this.refreshWidgets();
            }
            this.openGui();
        }).openGui();
    }

    private void openEditButtonContextMenu() {
        ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
        contextMenu.add(new ContextMenuItem((Component)Component.translatable((String)"ftbquests.title").append(ViewQuestPanel.hotkey("T")), Icons.NOTES, b -> this.editTitle()));
        contextMenu.add(new ContextMenuItem((Component)Component.translatable((String)"ftbquests.quest.subtitle").append(ViewQuestPanel.hotkey("S")), Icons.NOTES, b -> this.editSubtitle()));
        contextMenu.add(new ContextMenuItem((Component)Component.translatable((String)"ftbquests.quest.description").append(ViewQuestPanel.hotkey("D")), Icons.NOTES, b -> this.editDescription()));
        contextMenu.add(ContextMenuItem.SEPARATOR);
        contextMenu.add(new ContextMenuItem((Component)Component.translatable((String)"ftbquests.gui.line").append(ViewQuestPanel.hotkey("L")), Icons.NOTES, b -> this.editDescLine0((Widget)this, -1, null)));
        contextMenu.add(new ContextMenuItem((Component)Component.translatable((String)"ftbquests.gui.page_break").append(ViewQuestPanel.hotkey("P")), PAGEBREAK_ICON, b -> this.addPageBreak()));
        contextMenu.add(new ContextMenuItem((Component)Component.translatable((String)"ftbquests.gui.image").append(ViewQuestPanel.hotkey("I")), Icons.ART, b -> this.editDescLine0((Widget)this, -1, new ImageComponent())));
        contextMenu.add(ContextMenuItem.SEPARATOR);
        contextMenu.add(new ContextMenuItem((Component)Component.translatable((String)"ftbquests.gui.edit_quest_props").append(ViewQuestPanel.hotkey("Q")), Icons.SETTINGS, b -> this.quest.onEditButtonClicked((Runnable)((Object)this.questScreen))));
        this.getGui().openContextMenu(contextMenu);
    }

    private static Component hotkey(String key) {
        return Component.literal((String)(" [" + key + "]")).withStyle(ChatFormatting.DARK_GRAY);
    }

    private void addPageBreak() {
        this.quest.modifyTranslatableListValue(TranslationKey.QUEST_DESC, desc -> this.appendToPage((List<String>)desc, List.of("{@pagebreak}", "(new page placeholder text)"), this.getCurrentPage()));
        this.setCurrentPage(Math.min(this.pageIndices.size() - 1, this.getCurrentPage() + 1));
        this.refreshWidgets();
    }

    private void editDescLine0(Widget clickedWidget, int line, @Nullable Object type) {
        if (type instanceof ImageComponent) {
            ImageComponent img = (ImageComponent)type;
            this.editImage(line, img);
        } else {
            ArrayList<String> mutableRawDesc = new ArrayList<String>(this.quest.getRawDescription());
            StringConfig c = new StringConfig(null);
            c.setValue((Object)(line == -1 ? "" : mutableRawDesc.get(line)));
            EditStringConfigOverlay overlay = new EditStringConfigOverlay((Panel)this.getGui(), (ConfigFromString)c, accepted -> {
                if (accepted) {
                    if (line == -1) {
                        this.appendToPage(mutableRawDesc, List.of((String)c.getValue()), this.getCurrentPage());
                    } else {
                        mutableRawDesc.set(line, (String)c.getValue());
                    }
                    this.quest.setRawDescription(List.copyOf(mutableRawDesc));
                    this.refreshWidgets();
                }
            }).atPosition(clickedWidget.getX(), clickedWidget.getY());
            overlay.setWidth(Mth.clamp((int)overlay.getWidth(), (int)150, (int)(this.getScreen().getGuiScaledWidth() - clickedWidget.getX() - 20)));
            this.getGui().pushModalPanel((ModalPanel)overlay);
        }
    }

    private void editImage(int line, ImageComponent component) {
        ConfigGroup group = new ConfigGroup("ftbquests.chapter.image", accepted -> {
            this.openGui();
            if (accepted) {
                this.quest.modifyTranslatableListValue(TranslationKey.QUEST_DESC, mutableRawDesc -> {
                    if (line == -1) {
                        this.appendToPage((List<String>)mutableRawDesc, List.of(component.toString()), this.getCurrentPage());
                    } else {
                        mutableRawDesc.set(line, component.toString());
                    }
                });
                this.refreshWidgets();
            }
        });
        group.add("image", (ConfigValue)new ImageResourceConfig(), (Object)ImageResourceConfig.getResourceLocation((Icon)component.getImage()), v -> component.setImage(Icon.getIcon((ResourceLocation)v)), (Object)ImageResourceConfig.NONE);
        group.addInt("width", component.getWidth(), arg_0 -> ((ImageComponent)component).setWidth(arg_0), 0, 1, 1000);
        group.addInt("height", component.getHeight(), arg_0 -> ((ImageComponent)component).setHeight(arg_0), 0, 1, 1000);
        group.addEnum("align", (Object)component.getAlign(), arg_0 -> ((ImageComponent)component).setAlign(arg_0), ImageComponent.ImageAlign.NAME_MAP, (Object)ImageComponent.ImageAlign.CENTER);
        group.addBool("fit", component.isFit(), arg_0 -> ((ImageComponent)component).setFit(arg_0), false);
        new EditConfigScreen(group).openGui();
    }

    private void appendToPage(List<String> list, List<String> toAdd, int pageNumber) {
        if (this.pageIndices.isEmpty()) {
            list.addAll(toAdd);
            this.buildPageIndices();
        } else {
            int idx = (Integer)this.pageIndices.get(pageNumber).getSecond() + 1;
            for (String line : toAdd) {
                list.add(idx, line);
                ++idx;
            }
        }
    }

    public void editDescLine(Widget clickedWidget, int line, boolean context, @Nullable Object type) {
        if (context) {
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            contextMenu.add(new ContextMenuItem((Component)Component.translatable((String)"selectServer.edit"), (Icon)ThemeProperties.EDIT_ICON.get(), b -> this.editDescLine0(clickedWidget, line, type)));
            contextMenu.add(new ContextMenuItem((Component)Component.translatable((String)"selectServer.delete"), (Icon)ThemeProperties.DELETE_ICON.get(), b -> {
                this.quest.modifyTranslatableListValue(TranslationKey.QUEST_DESC, mutableDesc -> mutableDesc.remove(line));
                this.refreshWidgets();
            }));
            this.getGui().openContextMenu(contextMenu);
        } else {
            this.editDescLine0(clickedWidget, line, type);
        }
    }

    public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        if (this.quest != null) {
            QuestObjectBase prev = QuestTheme.currentObject;
            QuestTheme.currentObject = this.quest;
            super.draw(graphics, theme, x, y, w, h);
            QuestTheme.currentObject = prev;
        }
    }

    public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        ((Icon)ThemeProperties.QUEST_VIEW_BACKGROUND.get()).draw(graphics, x, y, w, h);
        if (this.titleField != null && this.panelContent != null) {
            int iconSize = Math.min(16, this.titleField.height + 2);
            this.icon.draw(graphics, x + 4, y + 4, iconSize, iconSize);
            ((Color4I)ThemeProperties.QUEST_VIEW_BORDER.get()).draw(graphics, x + 1, this.panelContent.getY(), w - 2, 1);
        }
    }

    public boolean mousePressed(MouseButton button) {
        return super.mousePressed(button) || this.isMouseOver();
    }

    public boolean mouseScrolled(double scroll) {
        long now = System.currentTimeMillis();
        if (super.mouseScrolled(scroll)) {
            this.lastScrollTime = now;
            return true;
        }
        if (now - this.lastScrollTime > 500L) {
            if (scroll < 0.0 && this.getCurrentPage() < this.pageIndices.size() - 1) {
                this.setCurrentPage(this.getCurrentPage() + 1);
                this.refreshWidgets();
                this.lastScrollTime = now;
                return true;
            }
            if (scroll > 0.0 && this.getCurrentPage() > 0) {
                this.setCurrentPage(this.getCurrentPage() - 1);
                this.refreshWidgets();
                this.lastScrollTime = now;
                return true;
            }
        }
        return false;
    }

    private class QuestDescriptionField
    extends TextField {
        private final boolean canEdit;
        private final boolean xlateWarning;
        private final BiConsumer<Boolean, Widget> editCallback;
        private final TranslationKey key;

        QuestDescriptionField(Panel panel, boolean canEdit, TranslationKey key, BiConsumer<Boolean, Widget> editCallback) {
            super(panel);
            this.canEdit = canEdit;
            this.editCallback = editCallback;
            this.key = key;
            this.xlateWarning = (Boolean)FTBQuestsClientConfig.HILITE_MISSING.get() != false && ViewQuestPanel.this.quest.getQuestFile().getTranslationManager().hasMissingTranslation(ViewQuestPanel.this.quest, key);
        }

        public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            if (this.xlateWarning) {
                Color4I.RED.withAlpha(40).draw(graphics, x, y, w, h);
            }
            super.draw(graphics, theme, x, y, w, h);
        }

        public boolean mousePressed(MouseButton button) {
            if (this.isMouseOver()) {
                Optional style;
                if (this.canEdit && button.isRight()) {
                    this.editCallback.accept(true, (Widget)this);
                    return true;
                }
                if (button.isLeft() && Minecraft.getInstance().screen != null && (style = this.getComponentStyleAt(ViewQuestPanel.this.questScreen.getTheme(), this.getMouseX(), this.getMouseY())).isPresent()) {
                    return this.handleCustomClickEvent((Style)style.get()) || Minecraft.getInstance().screen.handleComponentClicked((Style)style.get());
                }
            }
            return super.mousePressed(button);
        }

        private boolean handleCustomClickEvent(Style style) {
            if (style == null) {
                return false;
            }
            ClickEvent clickEvent = style.getClickEvent();
            if (clickEvent == null) {
                return false;
            }
            if (clickEvent.getAction() == ClickEvent.Action.CHANGE_PAGE) {
                String[] fields = clickEvent.getValue().split("/");
                QuestObjectBase.parseHexId(fields[0]).ifPresentOrElse(questId -> {
                    QuestObject qo = ViewQuestPanel.this.quest.getQuestFile().get((long)questId);
                    if (qo != null) {
                        if (qo instanceof Quest && fields.length >= 2 && StringUtils.isNumeric((CharSequence)fields[1])) {
                            ViewQuestPanel.this.currentPages.put(questId.longValue(), Integer.parseInt(fields[1]) - 1);
                        }
                        ViewQuestPanel.this.questScreen.open(qo, false);
                    } else {
                        this.errorToPlayer("Unknown quest object id: %s", clickEvent.getValue());
                    }
                }, () -> this.errorToPlayer("Invalid quest object id: %s", clickEvent.getValue()));
                return true;
            }
            if (clickEvent.getAction() == ClickEvent.Action.OPEN_URL) {
                try {
                    URI uri = new URI(clickEvent.getValue());
                    String scheme = uri.getScheme();
                    if (scheme == null) {
                        throw new URISyntaxException(clickEvent.getValue(), "Missing protocol");
                    }
                    if (!scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https")) {
                        throw new URISyntaxException(clickEvent.getValue(), "Unsupported protocol: " + scheme.toLowerCase(Locale.ROOT));
                    }
                    Screen curScreen = Minecraft.getInstance().screen;
                    Minecraft.getInstance().setScreen((Screen)new ConfirmLinkScreen(accepted -> {
                        if (accepted) {
                            Util.getPlatform().openUri(uri);
                        }
                        Minecraft.getInstance().setScreen(curScreen);
                    }, clickEvent.getValue(), false));
                    return true;
                }
                catch (URISyntaxException e) {
                    this.errorToPlayer("Can't open url for %s (%s)", clickEvent.getValue(), e.getMessage());
                    return true;
                }
            }
            return false;
        }

        private void errorToPlayer(String msg, Object ... args) {
            QuestScreen.displayError((Component)Component.literal((String)String.format(msg, args)).withStyle(ChatFormatting.RED));
        }

        public boolean mouseDoubleClicked(MouseButton button) {
            if (this.isMouseOver() && this.canEdit) {
                this.editCallback.accept(false, (Widget)this);
                return true;
            }
            return false;
        }

        @Nullable
        public CursorType getCursor() {
            return this.canEdit ? CursorType.IBEAM : null;
        }

        public void addMouseOverText(TooltipList list) {
            if (!this.isMouseOver()) {
                return;
            }
            super.addMouseOverText(list);
            this.getComponentStyleAt(ViewQuestPanel.this.questScreen.getTheme(), this.getMouseX(), this.getMouseY()).ifPresent(style -> {
                if (style.getHoverEvent() != null) {
                    TooltipFlag.Default flag;
                    HoverEvent hoverevent = style.getHoverEvent();
                    HoverEvent.ItemStackInfo stackInfo = (HoverEvent.ItemStackInfo)hoverevent.getValue(HoverEvent.Action.SHOW_ITEM);
                    Minecraft mc = Minecraft.getInstance();
                    TooltipFlag.Default default_ = flag = mc.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL;
                    if (stackInfo != null) {
                        stackInfo.getItemStack().getTooltipLines(Item.TooltipContext.of((Level)mc.level), (Player)mc.player, (TooltipFlag)flag).forEach(arg_0 -> ((TooltipList)list).add(arg_0));
                    } else {
                        HoverEvent.EntityTooltipInfo entityInfo = (HoverEvent.EntityTooltipInfo)hoverevent.getValue(HoverEvent.Action.SHOW_ENTITY);
                        if (entityInfo != null) {
                            if (flag.isAdvanced()) {
                                entityInfo.getTooltipLines().forEach(arg_0 -> ((TooltipList)list).add(arg_0));
                            }
                        } else {
                            Component component = (Component)hoverevent.getValue(HoverEvent.Action.SHOW_TEXT);
                            if (component != null) {
                                list.add(component);
                            }
                        }
                    }
                }
            });
            if (this.xlateWarning) {
                ClientQuestFile.addTranslationWarning(list, this.key);
            }
        }
    }

    public static class DisabledButtonTextField
    extends TextField {
        public DisabledButtonTextField(Panel panel, Component text) {
            super(panel);
            this.addFlags(36);
            this.setText(text);
        }
    }

    private class CloseViewQuestButton
    extends AbstractPanelButton {
        private CloseViewQuestButton() {
            super(ViewQuestPanel.this, (Component)Component.translatable((String)"gui.close"), (Icon)ThemeProperties.CLOSE_ICON.get(ViewQuestPanel.this.quest));
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            ViewQuestPanel.this.questScreen.closeQuest();
        }
    }

    private class PinViewQuestButton
    extends AbstractPanelButton {
        private PinViewQuestButton() {
            super(ViewQuestPanel.this, (Component)Component.translatable((String)(ClientQuestFile.isQuestPinned(ViewQuestPanel.this.quest.id) ? "ftbquests.gui.unpin" : "ftbquests.gui.pin")), ClientQuestFile.isQuestPinned(ViewQuestPanel.this.quest.id) ? (Icon)ThemeProperties.PIN_ICON_ON.get() : (Icon)ThemeProperties.PIN_ICON_OFF.get());
        }

        public void onClicked(MouseButton button) {
            this.playClickSound();
            NetworkManager.sendToServer((CustomPacketPayload)new TogglePinnedMessage(ViewQuestPanel.this.quest.id));
        }
    }

    private class GotoLinkedQuestButton
    extends AbstractPanelButton {
        public GotoLinkedQuestButton() {
            super(ViewQuestPanel.this, (Component)Component.translatable((String)"ftbquests.gui.goto_linked_quest", (Object[])new Object[]{ViewQuestPanel.this.quest.getChapter().getMutableTitle().withStyle(ChatFormatting.YELLOW)}), (Icon)ThemeProperties.LINK_ICON.get());
        }

        public void onClicked(MouseButton button) {
            double qx = ViewQuestPanel.this.quest.getX() + 0.5;
            double qy = ViewQuestPanel.this.quest.getY() + 0.5;
            ViewQuestPanel.this.questScreen.selectChapter(ViewQuestPanel.this.quest.getChapter());
            ViewQuestPanel.this.questScreen.questPanel.scrollTo(qx, qy);
        }
    }

    private class ViewQuestLinksButton
    extends AbstractPanelButton {
        private final List<QuestLink> links;

        public ViewQuestLinksButton(Collection<QuestLink> links) {
            super(ViewQuestPanel.this, (Component)Component.translatable((String)"ftbquests.gui.view_quest_links"), (Icon)ThemeProperties.LINK_ICON.get());
            this.links = List.copyOf(links);
        }

        public void onClicked(MouseButton button) {
            ArrayList items = new ArrayList();
            for (QuestLink link : this.links) {
                link.getQuest().ifPresent(quest -> {
                    MutableComponent title = quest.getTitle().copy().append(": ").append((Component)link.getChapter().getTitle().copy().withStyle(ChatFormatting.YELLOW));
                    items.add(new ContextMenuItem((Component)title, quest.getIcon(), b -> this.gotoLink(link)));
                });
            }
            if (!items.isEmpty()) {
                ViewQuestPanel.this.questScreen.openContextMenu(items);
            }
        }

        private void gotoLink(QuestLink link) {
            ViewQuestPanel.this.questScreen.closeQuest();
            ViewQuestPanel.this.questScreen.selectChapter(link.getChapter());
            ViewQuestPanel.this.questScreen.questPanel.scrollTo(link.getX() + 0.5, link.getX() + 0.5);
        }

        public boolean isEnabled() {
            return !this.links.isEmpty();
        }

        public boolean shouldDraw() {
            return !this.links.isEmpty();
        }
    }

    public static class OpenInGuideButton
    extends SimpleTextButton {
        private final Quest quest;

        public OpenInGuideButton(Panel panel, Quest q) {
            super(panel, (Component)Component.translatable((String)"ftbquests.gui.open_in_guide"), ItemIcon.getItemIcon((Item)Items.BOOK));
            this.setHeight(13);
            this.setX((panel.width - this.width) / 2);
            this.quest = q;
        }

        public void onClicked(MouseButton button) {
            this.handleClick("guide", this.quest.getGuidePage());
        }

        public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        }
    }

    private abstract class AbstractPanelButton
    extends SimpleTextButton {
        public AbstractPanelButton(ViewQuestPanel viewQuestPanel, Component txt, Icon icon) {
            super((Panel)viewQuestPanel, txt, icon);
        }

        public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            this.drawIcon(graphics, theme, x + 1, y + 1, w - 2, h - 2);
        }
    }
}

