/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client.neoforge;

import dev.ftb.mods.ftbquests.client.neoforge.CamouflagingModel;
import dev.ftb.mods.ftbquests.registry.ModBlocks;
import java.util.function.Function;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ModelEvent;

public class ModelBakeEventHandler {
    private ModelBakeEventHandler() {
    }

    @SubscribeEvent
    public static void onModelBake(ModelEvent.ModifyBakingResult event) {
        ModelBakeEventHandler.override(event, (Block)ModBlocks.BARRIER.get(), CamouflagingModel::new);
        ModelBakeEventHandler.override(event, (Block)ModBlocks.STAGE_BARRIER.get(), CamouflagingModel::new);
    }

    private static void override(ModelEvent.ModifyBakingResult event, Block block, Function<BakedModel, CamouflagingModel> f) {
        for (BlockState state : block.getStateDefinition().getPossibleStates()) {
            ModelResourceLocation loc = BlockModelShaper.stateToModelLocation((BlockState)state);
            BakedModel model = (BakedModel)event.getModels().get(loc);
            if (model == null) continue;
            event.getModels().put(loc, (BakedModel)f.apply(model));
        }
    }
}

