/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gametest.tests;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.embeddedt.embeddium.impl.gametest.content.NotAnAirBlock;
import org.embeddedt.embeddium.impl.gametest.content.TestBlock;
import org.embeddedt.embeddium.impl.gametest.content.TestRegistry;
import org.embeddedt.embeddium.impl.gametest.content.client.InstrumentingModelWrapper;
import org.embeddedt.embeddium.impl.gametest.util.TestUtils;
import org.embeddedt.embeddium.impl.render.chunk.compile.pipeline.BlockOcclusionCache;

public class EmbeddiumGameTests {
    @GameTest
    public static void testBlockHidingNeighborFace(GameTestHelper helper) {
        BlockOcclusionCache cache = new BlockOcclusionCache();
        BlockPos selfPos = new BlockPos(2, 2, 2);
        BlockState selfState = ((TestBlock)((Object)TestRegistry.TEST_BLOCK.get())).defaultBlockState();
        helper.setBlock(selfPos, selfState);
        helper.setBlock(selfPos.relative(Direction.EAST), Blocks.STONE);
        helper.assertTrue(cache.shouldDrawSide(selfState, (BlockGetter)helper.getLevel(), helper.absolutePos(selfPos), Direction.EAST), "Did not show face of neighbor block as expected");
        helper.setBlock(selfPos.relative(Direction.EAST), selfState);
        helper.assertFalse(cache.shouldDrawSide(selfState, (BlockGetter)helper.getLevel(), helper.absolutePos(selfPos), Direction.EAST), "Did not hide face of neighbor block as expected");
        helper.succeed();
    }

    @GameTest
    public static void testFakeAirBlockRenders(GameTestHelper helper) {
        BlockState fakeAirState = ((NotAnAirBlock)((Object)TestRegistry.NOT_AN_AIR_BLOCK.get())).defaultBlockState();
        InstrumentingModelWrapper airBlockModel = (InstrumentingModelWrapper)Minecraft.getInstance().getModelManager().getBlockModelShaper().getBlockModel(fakeAirState);
        airBlockModel.resetCalledFlag();
        BlockPos selfPos = new BlockPos(2, 2, 2);
        helper.setBlock(selfPos.relative(Direction.DOWN), Blocks.OAK_PLANKS.defaultBlockState());
        helper.setBlock(selfPos, fakeAirState);
        TestUtils.clientBarrier();
        helper.succeedWhen(airBlockModel::hasBeenCalled);
    }
}

