/*
 * Decompiled with CFR 0.152.
 */
package com.boltflint.endergyreborn.Capacitors;

import com.boltflint.endergyreborn.data.ModDataComponents;
import com.enderio.base.api.capacitor.CapacitorData;
import java.util.function.BiFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModCapacitorItem
extends Item {
    private final BiFunction<ItemStack, @Nullable Level, CapacitorData> capacitorDataFunc;
    private final boolean dynamic;

    public ModCapacitorItem(Item.Properties properties, BiFunction<ItemStack, @Nullable Level, CapacitorData> capacitorDataFunc) {
        super(properties);
        this.capacitorDataFunc = capacitorDataFunc;
        this.dynamic = true;
    }

    public ModCapacitorItem(Item.Properties properties, CapacitorData capacitorData) {
        super(properties);
        this.capacitorDataFunc = (stack, level) -> capacitorData;
        this.dynamic = false;
    }

    @NotNull
    public CapacitorData getCapacitorData(@NotNull ItemStack stack, @Nullable Level level) {
        return this.capacitorDataFunc.apply(stack, level);
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        if (stack.get(ModDataComponents.CAPACITOR_DATA_TYPE) == null) {
            stack.set(ModDataComponents.CAPACITOR_DATA_TYPE, (Object)this.getCapacitorData(stack, null));
        }
    }

    public static CapacitorData calculateTotemic(ItemStack stack, @Nullable Level level) {
        ItemEnchantments enchants = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        Holder.Reference efficiency = level != null ? level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.EFFICIENCY) : null;
        int effLevel = efficiency != null ? enchants.getLevel((Holder)efficiency) : 0;
        float value = switch (effLevel) {
            case 1 -> 4.0f;
            case 2 -> 4.5f;
            case 3 -> 5.0f;
            case 4 -> 5.5f;
            case 5 -> 6.0f;
            default -> 3.5f;
        };
        return CapacitorData.simple((float)value);
    }

    public boolean isEnchantable(ItemStack stack) {
        return this.dynamic;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return this.dynamic;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }
}

