/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.arseng.part;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.parts.p2p.P2PModels;
import appeng.parts.p2p.P2PTunnelPart;
import com.hollingsworth.arsnouveau.api.event.SpellProjectileHitEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.advancement.ANCriteriaTriggers;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAccelerate;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDecelerate;
import gripe._90.arseng.ArsEnergistique;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class SpellP2PTunnelPart
extends P2PTunnelPart<SpellP2PTunnelPart> {
    public static final P2PModels MODELS = new P2PModels(ArsEnergistique.makeId("part/spell_p2p_tunnel"));

    public SpellP2PTunnelPart(IPartItem<?> partItem) {
        super(partItem);
    }

    protected float getPowerDrainPerTick() {
        return 0.5f;
    }

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    public static void onSpellHit(SpellProjectileHitEvent event) {
        HitResult hitResult = event.getHitResult();
        if (hitResult instanceof BlockHitResult) {
            ArrayList outputs;
            SpellP2PTunnelPart spellP2P;
            IPartHost partHost;
            IPart part;
            BlockHitResult blockHit = (BlockHitResult)hitResult;
            BlockEntity be = event.getProjectile().level().getBlockEntity(blockHit.getBlockPos());
            if (be instanceof IPartHost && (part = (partHost = (IPartHost)be).getPart(blockHit.getDirection())) instanceof SpellP2PTunnelPart && ((Object)((Object)(spellP2P = (SpellP2PTunnelPart)part))).equals(spellP2P.getInput()) && !(outputs = new ArrayList(spellP2P.getOutputs())).isEmpty()) {
                Collections.shuffle(outputs);
                spellP2P.redirectSpell(event.getProjectile(), (SpellP2PTunnelPart)((Object)outputs.getFirst()));
                event.setCanceled(true);
            }
        }
    }

    private void redirectSpell(EntityProjectileSpell spell, SpellP2PTunnelPart output) {
        Level level;
        Direction dir = output.getSide();
        BlockPos pos = output.getHost().getBlockEntity().getBlockPos();
        spell.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
        ++spell.prismRedirect;
        if (spell.prismRedirect >= 3 && (level = this.getLevel()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            ANCriteriaTriggers.rewardNearbyPlayers((PlayerTrigger)((PlayerTrigger)ANCriteriaTriggers.PRISMATIC.get()), (ServerLevel)level2, (BlockPos)pos, (int)10);
        }
        if (spell.spellResolver == null) {
            spell.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        int acceleration = spell.spellResolver.spell.getBuffsAtIndex(0, null, (AbstractAugment)AugmentAccelerate.INSTANCE);
        int deceleration = spell.spellResolver.spell.getBuffsAtIndex(0, null, (AbstractAugment)AugmentDecelerate.INSTANCE);
        double velocity = Math.max(0.1, 0.5 + 0.1 * Math.min(2.0, (double)acceleration - (double)deceleration * 0.5));
        spell.shoot((double)dir.getStepX(), (double)dir.getStepY(), (double)dir.getStepZ(), (float)velocity, 0.0f);
        BlockUtil.updateObservers((Level)this.getLevel(), (BlockPos)pos);
    }
}

