/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util;

import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import team.chisel.ctm.api.texture.ISubmap;
import team.chisel.ctm.client.util.Quad;

public class PartialTextureAtlasSprite
extends TextureAtlasSprite {
    private final float u0;
    private final float u1;
    private final float v0;
    private final float v1;

    public static TextureAtlasSprite createPartial(TextureAtlasSprite sprite, ISubmap submap) {
        if ((submap = submap.unitScale()).getXOffset() == 0.0f && submap.getYOffset() == 0.0f && submap.getWidth() == 1.0f && submap.getHeight() == 1.0f) {
            return sprite;
        }
        float width = sprite.getU1() - sprite.getU0();
        float height = sprite.getV1() - sprite.getV0();
        float atlasWidth = (float)sprite.contents().width() / width;
        float atlasHeight = (float)sprite.contents().height() / height;
        float uWidth = width * submap.getWidth();
        float vHeight = height * submap.getHeight();
        float xOffset = Quad.lerp(sprite.getU0(), sprite.getU1(), submap.getXOffset());
        float yOffset = Quad.lerp(sprite.getV0(), sprite.getV1(), submap.getYOffset());
        return new PartialTextureAtlasSprite(sprite, atlasWidth, atlasHeight, xOffset, uWidth, yOffset, vHeight);
    }

    protected PartialTextureAtlasSprite(TextureAtlasSprite sprite, float atlasWidth, float atlasHeight, float xOffset, float uWidth, float yOffset, float vHeight) {
        super(sprite.atlasLocation(), sprite.contents(), (int)atlasWidth, (int)atlasHeight, sprite.getX(), sprite.getY());
        this.u0 = xOffset;
        this.u1 = xOffset + uWidth;
        this.v0 = yOffset;
        this.v1 = yOffset + vHeight;
    }

    public float getU0() {
        return this.u0;
    }

    public float getU1() {
        return this.u1;
    }

    public float getU(float u) {
        float width = this.getU1() - this.getU0();
        return this.getU0() + width * u;
    }

    public float getUOffset(float offset) {
        float width = this.getU1() - this.getU0();
        return (offset - this.getU0()) / width;
    }

    public float getV0() {
        return this.v0;
    }

    public float getV1() {
        return this.v1;
    }

    public float getV(float v) {
        float height = this.getV1() - this.getV0();
        return this.getV0() + height * v;
    }

    public float getVOffset(float offset) {
        float height = this.getV1() - this.getV0();
        return (offset - this.getV0()) / height;
    }

    public String toString() {
        return "PartialTextureAtlasSprite{contents='" + String.valueOf(this.contents()) + "', u0=" + this.getU0() + ", u1=" + this.getU1() + ", v0=" + this.getV0() + ", v1=" + this.getV1() + "}";
    }

    private float atlasSize() {
        float atlasWidth = (float)this.contents().width() / (this.getU1() - this.getU0());
        float atlasHeight = (float)this.contents().height() / (this.getV1() - this.getV0());
        return Math.max(atlasWidth, atlasHeight);
    }

    public float uvShrinkRatio() {
        return 4.0f / this.atlasSize();
    }
}

