/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedavaritia.integration.appeng.blockentity;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnit;
import appeng.api.features.IPlayerRegistry;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import thelm.packagedavaritia.block.PackagedAvaritiaBlocks;
import thelm.packagedavaritia.block.entity.SculkCrafterBlockEntity;

public class AESculkCrafterBlockEntity
extends SculkCrafterBlockEntity
implements IInWorldGridNodeHost,
IGridNodeListener<AESculkCrafterBlockEntity>,
IActionHost {
    public boolean firstTick = true;
    public IActionSource source = IActionSource.ofMachine((IActionHost)this);
    public IManagedGridNode gridNode;

    public AESculkCrafterBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @Override
    public void tick() {
        if (this.firstTick) {
            this.firstTick = false;
            this.getMainNode().create(this.level, this.worldPosition);
        }
        super.tick();
        if (drawMEEnergy && !this.level.isClientSide && this.level.getGameTime() % 8L == 0L) {
            this.chargeMEEnergy();
        }
    }

    public void setRemoved() {
        super.setRemoved();
        if (this.gridNode != null) {
            this.gridNode.destroy();
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.gridNode != null) {
            this.gridNode.destroy();
        }
    }

    public IGridNode getGridNode(Direction dir) {
        return this.getActionableNode();
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    public void onSaveChanges(AESculkCrafterBlockEntity nodeOwner, IGridNode node) {
        this.setChanged();
    }

    public IManagedGridNode getMainNode() {
        if (this.gridNode == null) {
            this.gridNode = GridHelper.createManagedNode((Object)((Object)this), (IGridNodeListener)this);
            this.gridNode.setTagName("node");
            this.gridNode.setVisualRepresentation(PackagedAvaritiaBlocks.SCULK_CRAFTER);
            this.gridNode.setGridColor(AEColor.TRANSPARENT);
            this.gridNode.setIdlePowerUsage(1.0);
            this.gridNode.setInWorldNode(true);
            if (this.ownerUUID != null && this.level instanceof ServerLevel) {
                this.gridNode.setOwningPlayerId(IPlayerRegistry.getMapping((Level)this.level).getPlayerId(this.ownerUUID));
            }
        }
        return this.gridNode;
    }

    public IGridNode getActionableNode() {
        return this.getMainNode().getNode();
    }

    @Override
    protected void ejectItems() {
        if (this.getMainNode().isActive()) {
            IGrid grid = this.getMainNode().getGrid();
            IStorageService storageService = grid.getStorageService();
            IEnergyService energyService = grid.getEnergyService();
            MEStorage inventory = storageService.getInventory();
            int endIndex = this.isWorking ? 9 : 0;
            for (int i = 9; i >= endIndex; --i) {
                int count;
                ItemStack is = this.itemHandler.getStackInSlot(i);
                if (is.isEmpty()) continue;
                AEItemKey key = AEItemKey.of((ItemStack)is);
                int inserted = (int)StorageHelper.poweredInsert((IEnergySource)energyService, (MEStorage)inventory, (AEKey)key, (long)(count = is.getCount()), (IActionSource)this.source, (Actionable)Actionable.MODULATE);
                if (inserted == count) {
                    this.itemHandler.setStackInSlot(i, ItemStack.EMPTY);
                    continue;
                }
                this.itemHandler.setStackInSlot(i, key.toStack(count - inserted));
            }
        } else {
            super.ejectItems();
        }
    }

    protected void chargeMEEnergy() {
        if (this.getMainNode().isActive()) {
            IGrid grid = this.getMainNode().getGrid();
            IEnergyService energyService = grid.getEnergyService();
            double conversion = PowerUnit.FE.convertTo(PowerUnit.AE, 1.0);
            int request = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            double available = energyService.extractAEPower(((double)request + 0.5) * conversion, Actionable.SIMULATE, PowerMultiplier.CONFIG);
            int extract = (int)(available / conversion);
            energyService.extractAEPower((double)extract * conversion, Actionable.MODULATE, PowerMultiplier.CONFIG);
            this.energyStorage.receiveEnergy(extract, false);
        }
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        if (nbt.contains("node")) {
            this.getMainNode().loadFromNBT(nbt);
        }
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        if (this.gridNode != null) {
            this.gridNode.saveToNBT(nbt);
        }
    }
}

