/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedavaritia.inventory;

import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.inventory.BaseItemHandler;
import thelm.packagedavaritia.block.entity.NetherCrafterBlockEntity;
import thelm.packagedavaritia.inventory.NetherCrafterItemHandlerWrapper;

public class NetherCrafterItemHandler
extends BaseItemHandler<NetherCrafterBlockEntity> {
    public NetherCrafterItemHandler(NetherCrafterBlockEntity blockEntity) {
        super((BaseBlockEntity)blockEntity, 27);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot == 26) {
            return stack.getCapability(Capabilities.EnergyStorage.ITEM) != null;
        }
        return false;
    }

    public IItemHandlerModifiable getWrapperForDirection(Direction side) {
        return this.wrapperMap.computeIfAbsent(side, s -> new NetherCrafterItemHandlerWrapper(this, (Direction)s));
    }

    public int get(int id) {
        return switch (id) {
            case 0 -> ((NetherCrafterBlockEntity)this.blockEntity).remainingProgress;
            case 1 -> {
                if (((NetherCrafterBlockEntity)this.blockEntity).isWorking) {
                    yield 1;
                }
                yield 0;
            }
            case 2 -> ((NetherCrafterBlockEntity)this.blockEntity).getEnergyStorage().getEnergyStored();
            default -> 0;
        };
    }

    public void set(int id, int value) {
        switch (id) {
            case 0: {
                ((NetherCrafterBlockEntity)this.blockEntity).remainingProgress = value;
                break;
            }
            case 1: {
                ((NetherCrafterBlockEntity)this.blockEntity).isWorking = value != 0;
                break;
            }
            case 2: {
                ((NetherCrafterBlockEntity)this.blockEntity).getEnergyStorage().setEnergyStored(value);
            }
        }
    }

    public int getCount() {
        return 3;
    }
}

