/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedavaritia.inventory;

import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.inventory.BaseItemHandler;
import thelm.packagedavaritia.block.entity.SculkCrafterBlockEntity;
import thelm.packagedavaritia.inventory.SculkCrafterItemHandlerWrapper;

public class SculkCrafterItemHandler
extends BaseItemHandler<SculkCrafterBlockEntity> {
    public SculkCrafterItemHandler(SculkCrafterBlockEntity blockEntity) {
        super((BaseBlockEntity)blockEntity, 11);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot == 10) {
            return stack.getCapability(Capabilities.EnergyStorage.ITEM) != null;
        }
        return false;
    }

    public IItemHandlerModifiable getWrapperForDirection(Direction side) {
        return this.wrapperMap.computeIfAbsent(side, s -> new SculkCrafterItemHandlerWrapper(this, (Direction)s));
    }

    public int get(int id) {
        return switch (id) {
            case 0 -> ((SculkCrafterBlockEntity)this.blockEntity).remainingProgress;
            case 1 -> {
                if (((SculkCrafterBlockEntity)this.blockEntity).isWorking) {
                    yield 1;
                }
                yield 0;
            }
            case 2 -> ((SculkCrafterBlockEntity)this.blockEntity).getEnergyStorage().getEnergyStored();
            default -> 0;
        };
    }

    public void set(int id, int value) {
        switch (id) {
            case 0: {
                ((SculkCrafterBlockEntity)this.blockEntity).remainingProgress = value;
                break;
            }
            case 1: {
                ((SculkCrafterBlockEntity)this.blockEntity).isWorking = value != 0;
                break;
            }
            case 2: {
                ((SculkCrafterBlockEntity)this.blockEntity).getEnergyStorage().setEnergyStored(value);
            }
        }
    }

    public int getCount() {
        return 3;
    }
}

