/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedavaritia.recipe;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import committee.nova.mods.avaritia.common.crafting.recipe.ShapedTableCraftingRecipe;
import committee.nova.mods.avaritia.init.registry.ModBlocks;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.api.IRecipeSlotViewWrapper;
import thelm.packagedauto.api.IRecipeSlotsViewWrapper;
import thelm.packagedavaritia.recipe.SculkPackageRecipeInfo;

public class SculkPackageRecipeType
implements IPackageRecipeType {
    public static final SculkPackageRecipeType INSTANCE = new SculkPackageRecipeType();
    public static final ResourceLocation NAME = ResourceLocation.parse((String)"packagedavaritia:sculk");
    public static final IntSet SLOTS;
    public static final List<ResourceLocation> CATEGORIES;
    public static final List<ResourceLocation> CATEGORIES_EMI;
    public static final Vec3i COLOR;
    public static final Vec3i COLOR_DISABLED;

    protected SculkPackageRecipeType() {
    }

    public ResourceLocation getName() {
        return NAME;
    }

    public MutableComponent getDisplayName() {
        return Component.translatable((String)"recipe.packagedavaritia.sculk");
    }

    public MutableComponent getShortDisplayName() {
        return Component.translatable((String)"recipe.packagedavaritia.sculk.short");
    }

    public MapCodec<? extends IPackageRecipeInfo> getRecipeInfoMapCodec() {
        return SculkPackageRecipeInfo.MAP_CODEC;
    }

    public Codec<? extends IPackageRecipeInfo> getRecipeInfoCodec() {
        return SculkPackageRecipeInfo.CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, ? extends IPackageRecipeInfo> getRecipeInfoStreamCodec() {
        return SculkPackageRecipeInfo.STREAM_CODEC;
    }

    public IPackageRecipeInfo generateRecipeInfoFromStacks(List<ItemStack> inputs, List<ItemStack> outputs, Level level) {
        return new SculkPackageRecipeInfo(inputs, level);
    }

    public IntSet getEnabledSlots() {
        return SLOTS;
    }

    public List<ResourceLocation> getJEICategories() {
        return CATEGORIES;
    }

    public List<ResourceLocation> getEMICategories() {
        return CATEGORIES_EMI;
    }

    public Int2ObjectMap<ItemStack> getRecipeTransferMap(IRecipeSlotsViewWrapper recipeLayoutWrapper) {
        int heightOffset;
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        List slotViews = recipeLayoutWrapper.getRecipeSlotViews();
        int width = 3;
        int height = 3;
        int[] slotArray = SLOTS.toIntArray();
        IntArrayList slots = new IntArrayList(9);
        Object object = recipeLayoutWrapper.getRecipe();
        if (object instanceof ShapedTableCraftingRecipe) {
            ShapedTableCraftingRecipe recipe = (ShapedTableCraftingRecipe)object;
            width = recipe.getWidth();
            height = recipe.getHeight();
        }
        int widthOffset = (3 - width) / 2;
        for (int i = heightOffset = (3 - height) / 2; i < heightOffset + height; ++i) {
            for (int j = widthOffset; j < widthOffset + width; ++j) {
                slots.add(slotArray[3 * i + j]);
            }
        }
        int index = 0;
        slotArray = slots.toIntArray();
        for (IRecipeSlotViewWrapper slotView : slotViews) {
            if (slotView.isInput()) {
                ItemStack stack;
                Object displayed = slotView.getDisplayedIngredient().orElse(null);
                if (displayed instanceof ItemStack && !(stack = (ItemStack)displayed).isEmpty()) {
                    map.put(slotArray[index], (Object)stack);
                }
                ++index;
            }
            if (index < slots.size()) continue;
            break;
        }
        return map;
    }

    public Object getRepresentation() {
        return new ItemStack((ItemLike)ModBlocks.sculk_crafting_table.get());
    }

    public Vec3i getSlotColor(int slot) {
        if (!SLOTS.contains(slot) && slot != 81) {
            return COLOR_DISABLED;
        }
        return COLOR;
    }

    static {
        CATEGORIES = List.of(ResourceLocation.parse((String)"avaritia:sculk_craft"));
        CATEGORIES_EMI = List.of(ResourceLocation.parse((String)"avaritia:sculk_crafting_table"));
        COLOR = new Vec3i(139, 139, 139);
        COLOR_DISABLED = new Vec3i(64, 64, 64);
        SLOTS = new IntRBTreeSet();
        for (int i = 3; i < 6; ++i) {
            for (int j = 3; j < 6; ++j) {
                SLOTS.add(9 * i + j);
            }
        }
    }
}

