/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedavaritia.variant;

import thelm.packagedavaritia.variant.AvaritiaVariant;
import thelm.packagedavaritia.variant.VariantMismatchException;

public class VariantChecker {
    public static final AvaritiaVariant VARIANT = AvaritiaVariant.RE;
    public static final String SUPPORTED_MESSAGE = "%s only supports %s; %s is currently installed, which is supported by %s.";
    public static final String UNSUPPORTED_MESSAGE = "%s only supports %s; %s is currently installed.";
    public static final String DEFAULT_MESSAGE = "%s only supports %s; an unknown variant of Avaritia is currently installed.";

    public static void check() {
        if (VariantChecker.classExists(VariantChecker.VARIANT.mainClass)) {
            return;
        }
        for (AvaritiaVariant variant : AvaritiaVariant.values()) {
            if (variant == VARIANT || !VariantChecker.classExists(variant.mainClass)) continue;
            if (variant.modVariant != null) {
                throw new VariantMismatchException(String.format(SUPPORTED_MESSAGE, VariantChecker.VARIANT.modVariant, VariantChecker.VARIANT.avaritiaVariant, variant.avaritiaVariant, variant.modVariant));
            }
            throw new VariantMismatchException(String.format(UNSUPPORTED_MESSAGE, VariantChecker.VARIANT.modVariant, VariantChecker.VARIANT.avaritiaVariant, variant.avaritiaVariant));
        }
        throw new VariantMismatchException(String.format(DEFAULT_MESSAGE, VariantChecker.VARIANT.modVariant, VariantChecker.VARIANT.avaritiaVariant));
    }

    public static boolean classExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

