/*
 * Decompiled with CFR 0.152.
 */
package com.blackout.nofallingblocks.mixins;

import com.blackout.nofallingblocks.NoFallingBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BrushableBlock.class})
public abstract class BrushableBlockMixin
extends Block {
    public BrushableBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelFalling(BlockState blockState, ServerLevel level, BlockPos blockPos, RandomSource randomSource, CallbackInfo callbackInfo) {
        if (((GameRules.BooleanValue)level.getGameRules().getRule(NoFallingBlocks.PREVENT_BLOCK_FALLING_RULE)).get()) {
            BlockEntity blockentity = level.getBlockEntity(blockPos);
            if (blockentity instanceof BrushableBlockEntity) {
                BrushableBlockEntity brushableblockentity = (BrushableBlockEntity)blockentity;
                brushableblockentity.checkReset();
            }
            callbackInfo.cancel();
        }
    }

    @Inject(method={"animateTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelFallingParticle(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource, CallbackInfo callbackInfo) {
        if (((GameRules.BooleanValue)level.getGameRules().getRule(NoFallingBlocks.PREVENT_BLOCK_FALLING_RULE)).get()) {
            callbackInfo.cancel();
        }
    }
}

