/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.neoforge.compat;

import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.common.NeoForge;
import terrails.colorfulhearts.CColorfulHearts;
import terrails.colorfulhearts.api.heart.drawing.HeartDrawing;
import terrails.colorfulhearts.api.heart.drawing.OverlayHeart;
import terrails.colorfulhearts.api.heart.drawing.SpriteHeartDrawing;
import terrails.colorfulhearts.api.neoforge.event.NeoHeartRegistryEvent;

public class UndergardenCompat {
    private static final ResourceLocation VIRULENCE_OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"virulence_hearts");

    public UndergardenCompat(IEventBus bus) {
        NeoForge.EVENT_BUS.addListener(this::cancelOverlay);
        bus.addListener(this::registerEffectHeart);
    }

    private void cancelOverlay(RenderGuiLayerEvent.Pre event) {
        if (event.getName().equals((Object)VIRULENCE_OVERLAY)) {
            event.setCanceled(true);
        }
    }

    public void registerEffectHeart(NeoHeartRegistryEvent event) {
        BuiltInRegistries.MOB_EFFECT.getHolder(ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"virulence")).ifPresent(effectHolder -> {
            CColorfulHearts.LOGGER.info("Registering custom hearts for virulence from mod undergarden");
            ResourceLocation heartId = CColorfulHearts.location("virulence_vanilla");
            SpriteHeartDrawing vanilla = SpriteHeartDrawing.build(ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"virulence_hearts")).finish(ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"virulence_hearts/normal"), ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"virulence_hearts/normal_blinking"), ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"virulence_hearts/half"), ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"virulence_hearts/half_blinking"), ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"virulence_hearts/hardcore"), ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"virulence_hearts/hardcore_blinking"), ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"virulence_hearts/hardcore_half"), ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"virulence_hearts/hardcore_half_blinking"));
            event.registerOverlayHeart(OverlayHeart.build(CColorfulHearts.location("virulence"), player -> player.hasEffect((Holder)effectHolder)).addHealth(vanilla, 0.45f, 0.4f, 0.4f).addAbsorption(HeartDrawing.colorBlend(vanilla, heartId.withSuffix("_absorption"), 1.0f, 1.0f, 1.0f, 0.15f, 1, 771), HeartDrawing.colorBlend(vanilla, heartId.withSuffix("_absorption_2"), 1.0f, 0.85f, 0.85f, 0.5f, 1, 771)).finish());
            CColorfulHearts.LOGGER.debug("Registered custom hearts for virulence from mod undergarden");
        });
    }
}

