/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.render.atlas.sources;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceType;
import net.minecraft.client.renderer.texture.atlas.sources.LazyLoadedImage;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceMetadata;
import org.jetbrains.annotations.NotNull;
import terrails.colorfulhearts.CColorfulHearts;
import terrails.colorfulhearts.config.Configuration;
import terrails.colorfulhearts.render.ImageUtils;

public class ColoredHearts
implements SpriteSource {
    public static SpriteSourceType TYPE;
    private static final Codec<Boolean> IS_HEALTH;
    public static final MapCodec<ColoredHearts> CODEC;
    private final boolean isHealth;

    public ColoredHearts(boolean isHealth) {
        this.isHealth = isHealth;
    }

    public void run(ResourceManager resourceManager, SpriteSource.Output output) {
        if (this.isHealth) {
            this.processColors(resourceManager, output, Configuration.HEALTH.colors, "health");
            this.processColors(resourceManager, output, Configuration.HEALTH.poisonedColors, "health/poisoned");
            this.processColors(resourceManager, output, Configuration.HEALTH.witheredColors, "health/withered");
            this.processColors(resourceManager, output, Configuration.HEALTH.frozenColors, "health/frozen");
        } else {
            this.processColors(resourceManager, output, Configuration.ABSORPTION.colors, "absorbing");
            this.processColors(resourceManager, output, Configuration.ABSORPTION.poisonedColors, "absorbing/poisoned");
            this.processColors(resourceManager, output, Configuration.ABSORPTION.witheredColors, "absorbing/withered");
            this.processColors(resourceManager, output, Configuration.ABSORPTION.frozenColors, "absorbing/frozen");
        }
    }

    private void processColors(ResourceManager resMgr, SpriteSource.Output out, java.util.function.Supplier<List<Integer>> colors, String prefix) {
        Map<Integer, IntUnaryOperator> map = colors.get().stream().map(rgb -> Map.entry(rgb, ImageUtils.getColorOverlayOperator(rgb))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue));
        this.processType(resMgr, out, map, prefix, false, false, false);
        this.processType(resMgr, out, map, prefix, false, true, false);
        this.processType(resMgr, out, map, prefix, false, false, true);
        this.processType(resMgr, out, map, prefix, false, true, true);
        this.processType(resMgr, out, map, prefix, true, false, false);
        this.processType(resMgr, out, map, prefix, true, true, false);
        this.processType(resMgr, out, map, prefix, true, false, true);
        this.processType(resMgr, out, map, prefix, true, true, true);
    }

    private void processType(ResourceManager resMgr, SpriteSource.Output out, Map<Integer, IntUnaryOperator> hexARGBs, String prefix, boolean hardcore, boolean highlight, boolean half) {
        String suffix = (hardcore ? "hardcore_" : "") + (half ? "half" : "full") + (highlight ? "_blinking" : "");
        ResourceLocation baseLocation = CColorfulHearts.location("heart/" + prefix + "/" + suffix);
        Supplier blendApplier = Suppliers.memoize(() -> this.getBlendApplier(resMgr, baseLocation, hexARGBs.size()));
        ResourceLocation textureLocation = TEXTURE_ID_CONVERTER.idToFile(baseLocation);
        Optional optional = resMgr.getResource(textureLocation);
        if (optional.isEmpty()) {
            CColorfulHearts.LOGGER.warn("Missing texture: {}", (Object)textureLocation);
            return;
        }
        LazyLoadedImage lazyImage = new LazyLoadedImage(textureLocation, (Resource)optional.get(), hexARGBs.size());
        for (Map.Entry<Integer, IntUnaryOperator> entry : hexARGBs.entrySet()) {
            ResourceLocation spriteLocation = baseLocation.withSuffix("_" + String.valueOf(entry.getKey()));
            out.add(spriteLocation, (SpriteSource.SpriteSupplier)new ColoredHeartsSupplier(lazyImage, entry.getValue(), (java.util.function.Supplier<Consumer<NativeImage>>)blendApplier, spriteLocation));
        }
    }

    private Consumer<NativeImage> getBlendApplier(ResourceManager resourceManager, ResourceLocation spriteLocation, int loadCount) {
        ResourceLocation normalLocation = TEXTURE_ID_CONVERTER.idToFile(spriteLocation.withSuffix("_normal"));
        ResourceLocation multiplyLocation = TEXTURE_ID_CONVERTER.idToFile(spriteLocation.withSuffix("_multiply"));
        ResourceLocation screenLocation = TEXTURE_ID_CONVERTER.idToFile(spriteLocation.withSuffix("_screen"));
        ResourceLocation overlayLocation = TEXTURE_ID_CONVERTER.idToFile(spriteLocation.withSuffix("_overlay"));
        Optional<LazyLoadedImage> normalOptional = resourceManager.getResource(normalLocation).map(r -> new LazyLoadedImage(normalLocation, r, loadCount));
        Optional<LazyLoadedImage> multiplyOptional = resourceManager.getResource(multiplyLocation).map(r -> new LazyLoadedImage(multiplyLocation, r, loadCount));
        Optional<LazyLoadedImage> screenOptional = resourceManager.getResource(screenLocation).map(r -> new LazyLoadedImage(screenLocation, r, loadCount));
        Optional<LazyLoadedImage> overlayOptional = resourceManager.getResource(overlayLocation).map(r -> new LazyLoadedImage(overlayLocation, r, loadCount));
        return image -> {
            normalOptional.ifPresentOrElse(normal -> {
                try {
                    ImageUtils.blendNormal(image, normal.get());
                }
                catch (IOException e) {
                    CColorfulHearts.LOGGER.error((Object)e);
                }
                finally {
                    normal.release();
                }
            }, () -> CColorfulHearts.LOGGER.debug("Normal blend texture not found: {}", (Object)normalLocation));
            multiplyOptional.ifPresentOrElse(multiply -> {
                try {
                    ImageUtils.blendMultiply(image, multiply.get());
                }
                catch (IOException e) {
                    CColorfulHearts.LOGGER.error((Object)e);
                }
                finally {
                    multiply.release();
                }
            }, () -> CColorfulHearts.LOGGER.debug("Multiply blend texture not found: {}", (Object)multiplyLocation));
            screenOptional.ifPresentOrElse(screen -> {
                try {
                    NativeImage screenImg = screen.get();
                    ImageUtils.blendScreen(image, screenImg);
                }
                catch (IOException e) {
                    CColorfulHearts.LOGGER.error((Object)e);
                }
                finally {
                    screen.release();
                }
            }, () -> CColorfulHearts.LOGGER.debug("Screen blend texture not found: {}", (Object)screenLocation));
            overlayOptional.ifPresentOrElse(overlay -> {
                try {
                    ImageUtils.blendOverlay(image, overlay.get());
                }
                catch (IOException e) {
                    CColorfulHearts.LOGGER.error((Object)e);
                }
                finally {
                    overlay.release();
                }
            }, () -> CColorfulHearts.LOGGER.debug("Overlay blend texture not found: {}", (Object)overlayLocation));
        };
    }

    @NotNull
    public SpriteSourceType type() {
        return TYPE;
    }

    static {
        IS_HEALTH = Codec.STRING.comapFlatMap(s -> {
            String lc = s.toLowerCase(Locale.ROOT);
            if (lc.equals("health")) {
                return DataResult.success((Object)true);
            }
            if (lc.equals("absorption")) {
                return DataResult.success((Object)false);
            }
            return DataResult.error(() -> "Unknown heart type " + s);
        }, bool -> bool != false ? "HEALTH" : "ABSORPTION");
        CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IS_HEALTH.fieldOf("heart").forGetter(source -> source.isHealth)).apply((Applicative)instance, ColoredHearts::new));
    }

    private record ColoredHeartsSupplier(LazyLoadedImage image, IntUnaryOperator colorOperator, java.util.function.Supplier<Consumer<NativeImage>> blend, ResourceLocation spriteLocation) implements SpriteSource.SpriteSupplier
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SpriteContents apply(SpriteResourceLoader spriteResourceLoader) {
            try {
                NativeImage image = this.image.get().mappedCopy(this.colorOperator);
                this.blend.get().accept(image);
                SpriteContents spriteContents = new SpriteContents(this.spriteLocation, new FrameSize(image.getWidth(), image.getHeight()), image, ResourceMetadata.EMPTY);
                return spriteContents;
            }
            catch (IOException | IllegalArgumentException e) {
                CColorfulHearts.LOGGER.error("Unable to apply color to {}", (Object)this.spriteLocation, (Object)e);
            }
            finally {
                this.image.release();
            }
            return null;
        }

        public void discard() {
            this.image.release();
        }
    }
}

