/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.ObjectBaseContainerWidget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.trashcans.TrashCanBlockEntity;
import com.supermartijn642.trashcans.screen.TrashCanContainer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class TrashCanScreen<T extends TrashCanContainer>
extends ObjectBaseContainerWidget<TrashCanBlockEntity, T> {
    private final Component title;

    public TrashCanScreen(String title) {
        super(0, 0, 1, 1);
        this.title = TextComponents.translation((String)title).get();
    }

    protected Component getNarrationMessage(TrashCanBlockEntity object) {
        return this.title;
    }

    protected TrashCanBlockEntity getObject(TrashCanBlockEntity oldObject) {
        return ((TrashCanContainer)this.container).getBlockEntity();
    }

    protected boolean validateObject(TrashCanBlockEntity object) {
        return object != null && !object.isRemoved();
    }

    protected int width(TrashCanBlockEntity object) {
        return ((TrashCanContainer)this.container).width;
    }

    protected int height(TrashCanBlockEntity object) {
        return ((TrashCanContainer)this.container).height;
    }

    protected abstract String getBackground();

    protected void renderBackground(WidgetRenderContext context, int mouseX, int mouseY, TrashCanBlockEntity entity) {
        super.renderBackground(context, mouseX, mouseY, (Object)entity);
        ScreenUtils.bindTexture((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"trashcans", (String)("textures/" + this.getBackground())));
        ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)0.0f, (float)0.0f, (float)this.width(), (float)this.height());
    }

    protected void renderForeground(WidgetRenderContext context, int mouseX, int mouseY, TrashCanBlockEntity entity) {
        super.renderForeground(context, mouseX, mouseY, (Object)entity);
        ScreenUtils.drawCenteredString((PoseStack)context.poseStack(), (Component)this.title, (float)((float)this.width() / 2.0f), (float)6.0f);
        ScreenUtils.drawString((PoseStack)context.poseStack(), (Component)ClientUtils.getPlayer().getInventory().getName(), (float)21.0f, (float)(this.height() - 94));
        this.drawText(context.poseStack(), entity);
    }

    protected abstract void drawText(PoseStack var1, TrashCanBlockEntity var2);
}

