/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells;

import appeng.api.AECapabilities;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.parts.RegisterPartCapabilitiesEvent;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.upgrades.Upgrades;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.ItemDefinition;
import appeng.core.localization.GuiText;
import appeng.hotkeys.HotkeyActions;
import appeng.init.InitVillager;
import appeng.items.tools.powered.AbstractPortableCell;
import appeng.items.tools.powered.powersink.PoweredItemCapabilities;
import gripe._90.megacells.definition.MEGABlockEntities;
import gripe._90.megacells.definition.MEGABlocks;
import gripe._90.megacells.definition.MEGAComponents;
import gripe._90.megacells.definition.MEGAConfig;
import gripe._90.megacells.definition.MEGACreativeTab;
import gripe._90.megacells.definition.MEGADataMaps;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.definition.MEGAMenus;
import gripe._90.megacells.integration.Addons;
import gripe._90.megacells.integration.appmek.RadioactiveCellItem;
import gripe._90.megacells.item.cell.BulkCellItem;
import gripe._90.megacells.item.part.CellDockPart;
import gripe._90.megacells.item.part.MEGAInterfacePart;
import gripe._90.megacells.item.part.MEGAPatternProviderPart;
import gripe._90.megacells.misc.CompressionService;
import gripe._90.megacells.misc.SyncCompressionChainsPacket;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredHolder;

@Mod(value="megacells")
public class MEGACells {
    public static final String MODID = "megacells";

    public MEGACells(ModContainer container, IEventBus eventBus) {
        MEGABlocks.DR.register(eventBus);
        MEGAItems.DR.register(eventBus);
        MEGABlockEntities.DR.register(eventBus);
        MEGAMenus.DR.register(eventBus);
        MEGAComponents.DR.register(eventBus);
        MEGACreativeTab.DR.register(eventBus);
        eventBus.addListener(MEGADataMaps::register);
        eventBus.addListener(MEGACells::initUpgrades);
        eventBus.addListener(MEGACells::initStorageCells);
        eventBus.addListener(MEGACells::initCapabilities);
        eventBus.addListener(MEGACells::initPartCapabilities);
        eventBus.addListener(MEGACells::initPacketHandlers);
        CompressionService.init();
        NeoForge.EVENT_BUS.addListener(MEGACells::initVillagerTrades);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)MEGAConfig.SPEC);
    }

    public static ResourceLocation makeId(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    private static void initUpgrades(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            String storageCellGroup = GuiText.StorageCells.getTranslationKey();
            String portableCellGroup = GuiText.PortableCells.getTranslationKey();
            String interfaceGroup = GuiText.Interface.getTranslationKey();
            String wirelessTerminalGroup = GuiText.WirelessTerminals.getTranslationKey();
            for (MEGAItems.CellDefinition cell : MEGAItems.getTieredCells()) {
                if (!cell.keyType().equals("item") && !cell.keyType().equals("fluid")) continue;
                Upgrades.add((ItemLike)AEItems.INVERTER_CARD, cell.item(), (int)1, (String)storageCellGroup);
                Upgrades.add((ItemLike)AEItems.EQUAL_DISTRIBUTION_CARD, cell.item(), (int)1, (String)storageCellGroup);
                Upgrades.add((ItemLike)AEItems.VOID_CARD, cell.item(), (int)1, (String)storageCellGroup);
                if (cell.keyType().equals("item")) {
                    Upgrades.add((ItemLike)AEItems.FUZZY_CARD, cell.item(), (int)1, (String)storageCellGroup);
                }
                if (!cell.portable()) continue;
                Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, cell.item(), (int)2, (String)portableCellGroup);
            }
            Upgrades.add((ItemLike)AEItems.CRAFTING_CARD, MEGABlocks.MEGA_INTERFACE, (int)1, (String)interfaceGroup);
            Upgrades.add((ItemLike)AEItems.CRAFTING_CARD, MEGAItems.MEGA_INTERFACE, (int)1, (String)interfaceGroup);
            Upgrades.add((ItemLike)AEItems.FUZZY_CARD, MEGABlocks.MEGA_INTERFACE, (int)1, (String)interfaceGroup);
            Upgrades.add((ItemLike)AEItems.FUZZY_CARD, MEGAItems.MEGA_INTERFACE, (int)1, (String)interfaceGroup);
            Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, (ItemLike)AEItems.WIRELESS_TERMINAL, (int)2, (String)wirelessTerminalGroup);
            Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, (ItemLike)AEItems.WIRELESS_CRAFTING_TERMINAL, (int)2, (String)wirelessTerminalGroup);
            Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, (ItemLike)AEItems.COLOR_APPLICATOR, (int)2);
            Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, (ItemLike)AEItems.MATTER_CANNON, (int)2);
            Upgrades.add(MEGAItems.COMPRESSION_CARD, MEGAItems.BULK_ITEM_CELL, (int)1);
            for (ItemDefinition portableCell : List.of(AEItems.PORTABLE_ITEM_CELL1K, AEItems.PORTABLE_ITEM_CELL4K, AEItems.PORTABLE_ITEM_CELL16K, AEItems.PORTABLE_ITEM_CELL64K, AEItems.PORTABLE_ITEM_CELL256K, AEItems.PORTABLE_FLUID_CELL1K, AEItems.PORTABLE_FLUID_CELL4K, AEItems.PORTABLE_FLUID_CELL16K, AEItems.PORTABLE_FLUID_CELL64K, AEItems.PORTABLE_FLUID_CELL256K)) {
                Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, (ItemLike)portableCell, (int)2, (String)portableCellGroup);
            }
            for (Addons addon : Addons.values()) {
                if (!addon.isLoaded()) continue;
                addon.getHelper().initUpgrades();
            }
        });
    }

    private static void initStorageCells(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            BulkCellItem.registerHandler();
            for (MEGAItems.CellDefinition cell : MEGAItems.getTieredCells()) {
                Item patt0$temp = cell.item().asItem();
                if (!(patt0$temp instanceof AbstractPortableCell)) continue;
                AbstractPortableCell portable = (AbstractPortableCell)patt0$temp;
                HotkeyActions.register((ItemLike)portable, (arg_0, arg_1) -> ((AbstractPortableCell)portable).openFromInventory(arg_0, arg_1), (String)(cell.keyType().equals("item") ? "portable_item_cell" : "portable_fluid_cell"));
            }
            if (Addons.APPMEK.isLoaded()) {
                StorageCells.addCellHandler((ICellHandler)RadioactiveCellItem.HANDLER);
            }
        });
    }

    private static void initVillagerTrades(VillagerTradesEvent event) {
        if (event.getType() == InitVillager.PROFESSION) {
            List trades = (List)event.getTrades().get(5);
            trades.add(MEGACells.villagerTrade(MEGAItems.SKY_STEEL_INGOT, 8, 3, 20));
            trades.add(MEGACells.villagerTrade(MEGAItems.ACCUMULATION_PROCESSOR_PRESS, 40, 1, 50));
        }
    }

    private static VillagerTrades.ItemListing villagerTrade(ItemLike item, int cost, int quantity, int xp) {
        return (entity, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, cost), new ItemStack(item, quantity), 12, xp, 0.05f);
    }

    private static void initCapabilities(RegisterCapabilitiesEvent event) {
        for (DeferredHolder type : MEGABlockEntities.DR.getEntries()) {
            event.registerBlockEntity(AECapabilities.IN_WORLD_GRID_NODE_HOST, (BlockEntityType)type.get(), (be, context) -> (IInWorldGridNodeHost)be);
        }
        event.registerBlockEntity(AECapabilities.GENERIC_INTERNAL_INV, MEGABlockEntities.MEGA_INTERFACE.get(), (be, context) -> be.getInterfaceLogic().getStorage());
        event.registerBlockEntity(AECapabilities.ME_STORAGE, MEGABlockEntities.MEGA_INTERFACE.get(), (be, context) -> be.getInterfaceLogic().getInventory());
        event.registerBlockEntity(AECapabilities.GENERIC_INTERNAL_INV, MEGABlockEntities.MEGA_PATTERN_PROVIDER.get(), (be, context) -> be.getLogic().getReturnInv());
        for (MEGAItems.CellDefinition cell : MEGAItems.getTieredCells()) {
            Item item;
            if (!cell.portable() || !((item = cell.item().asItem()) instanceof IAEItemPowerStorage)) continue;
            IAEItemPowerStorage powered = (IAEItemPowerStorage)item;
            event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, context) -> new PoweredItemCapabilities(stack, powered), new ItemLike[]{cell.item()});
        }
    }

    private static void initPartCapabilities(RegisterPartCapabilitiesEvent event) {
        event.register(AECapabilities.GENERIC_INTERNAL_INV, (part, ctx) -> part.getInterfaceLogic().getStorage(), MEGAInterfacePart.class);
        event.register(AECapabilities.ME_STORAGE, (part, ctx) -> part.getInterfaceLogic().getInventory(), MEGAInterfacePart.class);
        event.register(AECapabilities.GENERIC_INTERNAL_INV, (part, ctx) -> part.getLogic().getReturnInv(), MEGAPatternProviderPart.class);
        event.register(Capabilities.ItemHandler.BLOCK, (part, ctx) -> part.getCellInventory().toItemHandler(), CellDockPart.class);
    }

    private static void initPacketHandlers(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("2");
        registrar.playToClient(SyncCompressionChainsPacket.TYPE, SyncCompressionChainsPacket.STREAM_CODEC, CompressionService::syncToClient);
    }
}

