/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.integration.appbot;

import appbot.AppliedBotanics;
import appbot.item.ManaCellItem;
import appbot.item.PortableManaCellItem;
import appeng.api.upgrades.Upgrades;
import appeng.core.definitions.AEItems;
import appeng.core.localization.GuiText;
import appeng.items.storage.StorageTier;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.integration.IntegrationHelper;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public class AppBotIntegration
implements IntegrationHelper {
    @Override
    public Function<Item.Properties, Item> createCell(StorageTier tier) {
        return p -> new ManaCellItem(p, (ItemLike)tier.componentSupplier().get(), tier.bytes() / 1024, tier.idleDrain());
    }

    @Override
    public Function<Item.Properties, Item> createPortable(StorageTier tier) {
        return p -> new PortableManaCellItem(p, tier.bytes() / 1024, tier.idleDrain());
    }

    @Override
    public void initUpgrades() {
        for (MEGAItems.CellDefinition cell : MEGAItems.getTieredCells()) {
            if (!cell.keyType().equals("mana")) continue;
            Upgrades.add((ItemLike)AEItems.VOID_CARD, cell.item(), (int)1, (String)GuiText.StorageCells.getTranslationKey());
            if (!cell.portable()) continue;
            Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, cell.item(), (int)2, (String)GuiText.PortableCells.getTranslationKey());
        }
        for (ItemLike portable : AppBotIntegration.getCells()) {
            Upgrades.add(MEGAItems.GREATER_ENERGY_CARD, (ItemLike)portable, (int)2, (String)GuiText.PortableCells.getTranslationKey());
        }
    }

    public static List<ItemLike> getCells() {
        return List.of(AppBotIntegration.portable(StorageTier.SIZE_1K), AppBotIntegration.portable(StorageTier.SIZE_4K), AppBotIntegration.portable(StorageTier.SIZE_16K), AppBotIntegration.portable(StorageTier.SIZE_64K), AppBotIntegration.portable(StorageTier.SIZE_256K));
    }

    private static ItemLike portable(StorageTier tier) {
        return (ItemLike)BuiltInRegistries.ITEM.get(AppliedBotanics.id((String)("portable_mana_storage_cell_" + tier.namePrefix())));
    }
}

