/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.arseng.definition;

import appeng.api.features.P2PTunnelAttunement;
import appeng.api.parts.PartModels;
import appeng.api.upgrades.Upgrades;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.ItemDefinition;
import appeng.core.localization.GuiText;
import appeng.items.materials.MaterialItem;
import appeng.items.parts.PartItem;
import appeng.items.parts.PartModelsHelper;
import appeng.items.storage.StorageTier;
import gripe._90.arseng.item.PortableSourceCellItem;
import gripe._90.arseng.item.SourceCellItem;
import gripe._90.arseng.part.SourceConverterPart;
import gripe._90.arseng.part.SourceP2PTunnelPart;
import gripe._90.arseng.part.SpellP2PTunnelPart;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class ArsEngItems {
    public static final DeferredRegister.Items DR = DeferredRegister.createItems((String)"arseng");
    private static final List<ItemDefinition<?>> ITEMS = new ArrayList();
    public static final ItemDefinition<MaterialItem> SOURCE_CELL_HOUSING = ArsEngItems.item("ME Source Cell Housing", "source_cell_housing", MaterialItem::new);
    public static final ItemDefinition<SourceCellItem> SOURCE_CELL_1K = ArsEngItems.cell(StorageTier.SIZE_1K);
    public static final ItemDefinition<SourceCellItem> SOURCE_CELL_4K = ArsEngItems.cell(StorageTier.SIZE_4K);
    public static final ItemDefinition<SourceCellItem> SOURCE_CELL_16K = ArsEngItems.cell(StorageTier.SIZE_16K);
    public static final ItemDefinition<SourceCellItem> SOURCE_CELL_64K = ArsEngItems.cell(StorageTier.SIZE_64K);
    public static final ItemDefinition<SourceCellItem> SOURCE_CELL_256K = ArsEngItems.cell(StorageTier.SIZE_256K);
    public static final ItemDefinition<PortableSourceCellItem> PORTABLE_SOURCE_CELL1K = ArsEngItems.portable(StorageTier.SIZE_1K);
    public static final ItemDefinition<PortableSourceCellItem> PORTABLE_SOURCE_CELL4K = ArsEngItems.portable(StorageTier.SIZE_4K);
    public static final ItemDefinition<PortableSourceCellItem> PORTABLE_SOURCE_CELL16K = ArsEngItems.portable(StorageTier.SIZE_16K);
    public static final ItemDefinition<PortableSourceCellItem> PORTABLE_SOURCE_CELL64K = ArsEngItems.portable(StorageTier.SIZE_64K);
    public static final ItemDefinition<PortableSourceCellItem> PORTABLE_SOURCE_CELL256K = ArsEngItems.portable(StorageTier.SIZE_256K);
    public static final ItemDefinition<PartItem<SourceP2PTunnelPart>> SOURCE_P2P_TUNNEL = (ItemDefinition)Util.make(() -> {
        PartModels.registerModels((Collection)PartModelsHelper.createModels(SourceP2PTunnelPart.class));
        return ArsEngItems.item("ME Source P2P Tunnel", "source_p2p_tunnel", p -> new PartItem(p, SourceP2PTunnelPart.class, SourceP2PTunnelPart::new));
    });
    public static final ItemDefinition<PartItem<SpellP2PTunnelPart>> SPELL_P2P_TUNNEL = (ItemDefinition)Util.make(() -> {
        PartModels.registerModels((Collection)PartModelsHelper.createModels(SpellP2PTunnelPart.class));
        return ArsEngItems.item("ME Spell P2P Tunnel", "spell_p2p_tunnel", p -> new PartItem(p, SpellP2PTunnelPart.class, SpellP2PTunnelPart::new));
    });
    public static final ItemDefinition<PartItem<SourceConverterPart>> SOURCE_ACCEPTOR_PART = (ItemDefinition)Util.make(() -> {
        PartModels.registerModels((Collection)PartModelsHelper.createModels(SourceConverterPart.class));
        return ArsEngItems.item("ME Source Converter", "cable_source_acceptor", p -> new PartItem(p, SourceConverterPart.class, SourceConverterPart::new));
    });

    public static List<ItemDefinition<?>> getItems() {
        return Collections.unmodifiableList(ITEMS);
    }

    public static void initCellUpgrades(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ArsEngItems.getCells().forEach(cell -> Upgrades.add((ItemLike)AEItems.VOID_CARD, (ItemLike)cell, (int)1, (String)GuiText.StorageCells.getTranslationKey()));
            ArsEngItems.getPortables().forEach(cell -> {
                Upgrades.add((ItemLike)AEItems.ENERGY_CARD, (ItemLike)cell, (int)2, (String)GuiText.PortableCells.getTranslationKey());
                Upgrades.add((ItemLike)AEItems.VOID_CARD, (ItemLike)cell, (int)1, (String)GuiText.PortableCells.getTranslationKey());
            });
        });
    }

    public static void initP2PAttunement(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            P2PTunnelAttunement.registerAttunementTag(SOURCE_P2P_TUNNEL);
            P2PTunnelAttunement.registerAttunementTag(SPELL_P2P_TUNNEL);
        });
    }

    public static List<ItemDefinition<SourceCellItem>> getCells() {
        return List.of(SOURCE_CELL_1K, SOURCE_CELL_4K, SOURCE_CELL_16K, SOURCE_CELL_64K, SOURCE_CELL_256K);
    }

    public static List<ItemDefinition<PortableSourceCellItem>> getPortables() {
        return List.of(PORTABLE_SOURCE_CELL1K, PORTABLE_SOURCE_CELL4K, PORTABLE_SOURCE_CELL16K, PORTABLE_SOURCE_CELL64K, PORTABLE_SOURCE_CELL256K);
    }

    private static ItemDefinition<SourceCellItem> cell(StorageTier tier) {
        return ArsEngItems.item(tier.namePrefix() + " ME Source Storage Cell", "source_storage_cell_" + tier.namePrefix(), p -> new SourceCellItem(p.stacksTo(1), tier));
    }

    private static ItemDefinition<PortableSourceCellItem> portable(StorageTier tier) {
        return ArsEngItems.item(tier.namePrefix() + " Portable Source Cell", "portable_source_cell_" + tier.namePrefix(), p -> new PortableSourceCellItem(p.stacksTo(1), tier));
    }

    public static <T extends Item> ItemDefinition<T> item(String englishName, String id, Function<Item.Properties, T> factory) {
        ItemDefinition definition = new ItemDefinition(englishName, DR.registerItem(id, factory));
        ITEMS.add(definition);
        return definition;
    }
}

