/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.arseng.me.misc;

import appeng.api.AECapabilities;
import appeng.api.behaviors.GenericInternalInventory;
import appeng.api.config.Actionable;
import appeng.api.stacks.AEKey;
import com.google.common.primitives.Ints;
import com.hollingsworth.arsnouveau.api.source.ISourceCap;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import gripe._90.arseng.me.key.SourceKey;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;

public record GenericStackSourceStorage(GenericInternalInventory inv) implements ISourceCap
{
    public static void registerCapability(RegisterCapabilitiesEvent event) {
        for (Block block : BuiltInRegistries.BLOCK) {
            if (!event.isBlockRegistered(AECapabilities.GENERIC_INTERNAL_INV, block)) continue;
            event.registerBlock(CapabilityRegistry.SOURCE_CAPABILITY, (level, pos, state, be, context) -> {
                GenericInternalInventory genericInv = (GenericInternalInventory)level.getCapability(AECapabilities.GENERIC_INTERNAL_INV, pos, state, be, context);
                return genericInv != null ? new GenericStackSourceStorage(genericInv) : null;
            }, new Block[]{block});
        }
    }

    public int getMaxExtract() {
        return Integer.MAX_VALUE;
    }

    public int getMaxReceive() {
        return Integer.MAX_VALUE;
    }

    public boolean canAcceptSource(int source) {
        return this.insert(1, Actionable.SIMULATE) > 0;
    }

    public boolean canProvideSource(int source) {
        return this.extract(1, Actionable.SIMULATE) > 0;
    }

    public int getSource() {
        return this.extract(Integer.MAX_VALUE, Actionable.SIMULATE);
    }

    public int getSourceCapacity() {
        int slots = 0;
        for (int i = 0; i < this.inv.size(); ++i) {
            AEKey key = this.inv.getKey(i);
            if (key != null && key != SourceKey.KEY) continue;
            ++slots;
        }
        return Ints.saturatedCast((long)((long)slots * this.inv.getMaxAmount((AEKey)SourceKey.KEY)));
    }

    public int receiveSource(int source, boolean simulate) {
        return this.insert(source, Actionable.ofSimulate((boolean)simulate));
    }

    public int extractSource(int source, boolean simulate) {
        return this.extract(source, Actionable.ofSimulate((boolean)simulate));
    }

    private int insert(int amount, Actionable mode) {
        long inserted = 0L;
        for (int i = 0; i < this.inv.size() && inserted < (long)amount; inserted += this.inv.insert(i, (AEKey)SourceKey.KEY, (long)amount - inserted, mode), ++i) {
        }
        return inserted > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)inserted;
    }

    private int extract(int amount, Actionable mode) {
        long extracted = 0L;
        for (int i = 0; i < this.inv.size() && extracted < (long)amount; extracted += this.inv.extract(i, (AEKey)SourceKey.KEY, (long)amount - extracted, mode), ++i) {
        }
        return extracted > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)extracted;
    }

    public void setMaxSource(int max) {
        throw new UnsupportedOperationException();
    }

    public void setSource(int source) {
        throw new UnsupportedOperationException();
    }
}

