/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.arseng.me.strategy;

import appeng.api.behaviors.ContainerItemStrategy;
import appeng.api.config.Actionable;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.google.common.base.Preconditions;
import com.hollingsworth.arsnouveau.common.block.CreativeSourceJar;
import com.hollingsworth.arsnouveau.common.block.SourceJar;
import com.hollingsworth.arsnouveau.common.items.data.BlockFillContents;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import gripe._90.arseng.me.key.SourceKey;
import java.util.function.Supplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class SourceContainerItemStrategy
implements ContainerItemStrategy<SourceKey, Context> {
    public static final SourceContainerItemStrategy INSTANCE = new SourceContainerItemStrategy();

    private SourceContainerItemStrategy() {
    }

    private boolean isSourceJar(ItemStack stack) {
        BlockItem blockItem;
        Item item;
        return stack != null && (item = stack.getItem()) instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof SourceJar;
    }

    private boolean isCreativeSourceJar(ItemStack stack) {
        return this.isSourceJar(stack) && ((BlockItem)stack.getItem()).getBlock() instanceof CreativeSourceJar;
    }

    private int getSource(ItemStack sourceJar) {
        Preconditions.checkArgument((boolean)this.isSourceJar(sourceJar));
        return this.isCreativeSourceJar(sourceJar) ? 10000 : BlockFillContents.get((ItemStack)sourceJar);
    }

    private void changeSource(int amount, ItemStack sourceJar) {
        Preconditions.checkArgument((boolean)this.isSourceJar(sourceJar));
        if (this.isCreativeSourceJar(sourceJar)) {
            return;
        }
        sourceJar.set((Supplier)DataComponentRegistry.BLOCK_FILL_CONTENTS, (Object)new BlockFillContents(Math.min(10000, Math.max(this.getSource(sourceJar) + amount, 0))));
    }

    @Nullable
    public GenericStack getContainedStack(ItemStack stack) {
        return this.isSourceJar(stack) ? new GenericStack((AEKey)SourceKey.KEY, (long)this.getSource(stack)) : null;
    }

    @Nullable
    public Context findCarriedContext(Player player, AbstractContainerMenu menu) {
        ItemStack carried = menu.getCarried();
        return this.isSourceJar(carried) ? new CarriedContext(player, menu) : null;
    }

    @Nullable
    public Context findPlayerSlotContext(Player player, int slot) {
        ItemStack carried = player.getInventory().getItem(slot);
        return this.isSourceJar(carried) ? new PlayerInvContext(player, slot) : null;
    }

    public long extract(Context context, SourceKey what, long amount, Actionable mode) {
        ItemStack stackCopy = context.getStack().copy();
        stackCopy.setCount(1);
        int extracted = (int)Math.min(amount, (long)this.getSource(stackCopy));
        if (extracted > 0 && mode == Actionable.MODULATE) {
            this.changeSource(-extracted, stackCopy);
            context.getStack().shrink(1);
            context.addOverflow(stackCopy);
        }
        return extracted;
    }

    public long insert(Context context, SourceKey what, long amount, Actionable mode) {
        ItemStack stackCopy = context.getStack().copy();
        stackCopy.setCount(1);
        int inserted = (int)Math.min(amount, (long)(10000 - this.getSource(stackCopy)));
        if (inserted > 0 && mode == Actionable.MODULATE) {
            this.changeSource(inserted, stackCopy);
            context.getStack().shrink(1);
            context.addOverflow(stackCopy);
        }
        return inserted;
    }

    public void playFillSound(Player player, SourceKey what) {
    }

    public void playEmptySound(Player player, SourceKey what) {
    }

    @Nullable
    public GenericStack getExtractableContent(Context context) {
        return this.getContainedStack(context.getStack());
    }

    private record CarriedContext(Player player, AbstractContainerMenu menu) implements Context
    {
        @Override
        public ItemStack getStack() {
            return this.menu.getCarried();
        }

        @Override
        public void addOverflow(ItemStack stack) {
            if (this.menu.getCarried().isEmpty()) {
                this.menu.setCarried(stack);
            } else {
                this.player.getInventory().placeItemBackInInventory(stack);
            }
        }
    }

    private record PlayerInvContext(Player player, int slot) implements Context
    {
        @Override
        public ItemStack getStack() {
            return this.player.getInventory().getItem(this.slot);
        }

        @Override
        public void addOverflow(ItemStack stack) {
            this.player.getInventory().placeItemBackInInventory(stack);
        }
    }

    public static interface Context {
        public ItemStack getStack();

        public void addOverflow(ItemStack var1);
    }
}

