/*
 * Decompiled with CFR 0.152.
 */
package giselle.gmut.common.content.gear.mekasuit;

import giselle.gmut.GravitationalModulatingUnitTweaks;
import giselle.gmut.common.GMUTCommonPlayerTickHandler;
import giselle.gmut.common.GMUTLang;
import giselle.gmut.common.content.gear.mekasuit.VerticalSpeed;
import giselle.gmut.common.registries.GMUTModules;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleContainer;
import mekanism.api.text.IHasTextComponent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

@ParametersAreNonnullByDefault
public class ModuleGravitationalModulatingAdditionalUnit
implements ICustomModule<ModuleGravitationalModulatingAdditionalUnit> {
    public static final ResourceLocation FLY_ALWAYS = GravitationalModulatingUnitTweaks.rl("fly_always");
    public static final ResourceLocation STOP_IMMEDIATELY = GravitationalModulatingUnitTweaks.rl("stop_immediately");
    public static final ResourceLocation FIX_FOV = GravitationalModulatingUnitTweaks.rl("fix_fov");
    public static final ResourceLocation VERTICAL_SPEED = GravitationalModulatingUnitTweaks.rl("vertical_speed");
    public static final ResourceLocation MUTE_MODULATING_SOUND = GravitationalModulatingUnitTweaks.rl("mute_modulating_sound");
    private boolean flyAlways;
    private boolean stopImmediately;
    private boolean fixFOV;
    private VerticalSpeed verticalSpeed;
    private boolean muteModulatingSound;

    public ModuleGravitationalModulatingAdditionalUnit(IModule<ModuleGravitationalModulatingAdditionalUnit> module) {
        this.flyAlways = module.getBooleanConfigOrFalse(FLY_ALWAYS);
        this.stopImmediately = module.getBooleanConfigOrFalse(STOP_IMMEDIATELY);
        this.fixFOV = module.getBooleanConfigOrFalse(FIX_FOV);
        this.verticalSpeed = (VerticalSpeed)((Object)module.getConfigOrThrow(VERTICAL_SPEED).get());
        this.muteModulatingSound = module.getBooleanConfigOrFalse(MUTE_MODULATING_SOUND);
    }

    public void tickServer(IModule<ModuleGravitationalModulatingAdditionalUnit> module, IModuleContainer moduleContainer, ItemStack stack, Player player) {
        boolean hasGravitationalModulator = GMUTCommonPlayerTickHandler.isGravitationalModulationReady(stack);
        if (hasGravitationalModulator && this.flyAlways && !player.isShiftKeyDown() && !player.getAbilities().flying) {
            player.getAbilities().flying = true;
            player.onUpdateAbilities();
        }
    }

    public void tickClient(IModule<ModuleGravitationalModulatingAdditionalUnit> module, IModuleContainer moduleContainer, ItemStack stack, Player player) {
        boolean hasGravitationalModulator = GMUTCommonPlayerTickHandler.isGravitationalModulationReady(stack);
        if (hasGravitationalModulator) {
            if (this.flyAlways && !player.isShiftKeyDown() && !player.getAbilities().flying) {
                player.getAbilities().flying = true;
                player.onUpdateAbilities();
            }
            if (this.stopImmediately && player.getAbilities().flying && player.zza == 0.0f && player.xxa == 0.0f) {
                Vec3 deltaMovement = player.getDeltaMovement();
                player.setDeltaMovement(deltaMovement.multiply(0.0, 1.0, 0.0));
            }
            if (player instanceof LocalPlayer) {
                LocalPlayer clientPlayer = (LocalPlayer)player;
                if (clientPlayer.getAbilities().flying && Minecraft.getInstance().getCameraEntity() == clientPlayer) {
                    float j = 0.0f;
                    if (clientPlayer.input.shiftKeyDown) {
                        j -= 1.0f;
                    }
                    if (clientPlayer.input.jumping) {
                        j += 1.0f;
                    }
                    if (j != 0.0f) {
                        Vec3 deltaMovement = clientPlayer.getDeltaMovement();
                        clientPlayer.setDeltaMovement(deltaMovement.add(0.0, (double)((j *= this.getVerticalSpeed().getSpeed() - 1.0f) * clientPlayer.getAbilities().getFlyingSpeed() * 3.0f), 0.0));
                    }
                }
            }
        }
    }

    public void changeMode(IModule<ModuleGravitationalModulatingAdditionalUnit> module, Player player, IModuleContainer moduleContainer, ItemStack stack, int shift, boolean displayChangeMessage) {
        VerticalSpeed nextSpeed;
        VerticalSpeed prevSpeed;
        if (module.isEnabled() && (prevSpeed = this.getVerticalSpeed()) != (nextSpeed = (VerticalSpeed)prevSpeed.adjust(shift))) {
            moduleContainer.replaceModuleConfig((HolderLookup.Provider)player.level().registryAccess(), stack, GMUTModules.GRAVITATIONAL_MODULATING_ADDITIONAL_UNIT, module.getConfigOrThrow(VERTICAL_SPEED).with((Object)nextSpeed));
            if (displayChangeMessage) {
                module.displayModeChange(player, (Component)GMUTLang.MODULE_VERTICAL_SPEED.translate(), (IHasTextComponent)nextSpeed);
            }
        }
    }

    public boolean getFlyAlways() {
        return this.flyAlways;
    }

    public boolean getStopImmediately() {
        return this.stopImmediately;
    }

    public boolean getFixFOV() {
        return this.fixFOV;
    }

    public VerticalSpeed getVerticalSpeed() {
        return this.verticalSpeed;
    }

    public boolean getMuteModulatingSound() {
        return this.muteModulatingSound;
    }
}

