/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="gaze", bus=EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.BooleanValue DISABLE_GAZE_RITES = BUILDER.comment("Whether to disable Gaze rites entirely.").define("disableGazeRites", false);
    private static final ModConfigSpec.BooleanValue DO_VILLAGER_UMBRALS_ON_SERVER = BUILDER.comment("Whether to allow Villagers to drop Umbral Spirits on a multiplayer server. Singleplayer is always allowed.").define("doVillagerUmbralsOnServer", false);
    private static final ModConfigSpec.ConfigValue<List<? extends String>> UMBRAL_DROP_ENTITIES = BUILDER.comment("List of entity IDs (e.g., 'minecraft:villager') that can drop Umbral Spirits when killed with a Veil Dagger. Players are always on this list.").defineListAllowEmpty("umbralDropEntities", List.of("minecraft:villager"), obj -> obj instanceof String);
    private static final ModConfigSpec.DoubleValue UMBRAL_DROP_CHANCE = BUILDER.comment("Chance (0.0 to 1.0) for configured entities to drop Umbral Spirits when killed with a Veil Dagger. It's always 100% for players.").defineInRange("umbralDropChance", 0.1, 0.0, 1.0);
    private static final ModConfigSpec.DoubleValue ENCROACHING_MALICE_INTEGRITY_MULTIPLIER = BUILDER.comment("How much Soul Ward Integrity for a single Armour Toughness point").defineInRange("integrityRatio", 5.0, 1.0, 10.0);
    public static final ModConfigSpec SPEC = BUILDER.build();
    public static boolean mobsDropUmbralsOnServer;
    public static boolean disableGazeRites;
    public static List<String> umbralDropEntities;
    public static double umbralDropChance;
    public static double integrityRatio;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        mobsDropUmbralsOnServer = (Boolean)DO_VILLAGER_UMBRALS_ON_SERVER.get();
        disableGazeRites = (Boolean)DISABLE_GAZE_RITES.get();
        umbralDropEntities = new ArrayList<String>((Collection)UMBRAL_DROP_ENTITIES.get());
        umbralDropChance = (Double)UMBRAL_DROP_CHANCE.get();
        integrityRatio = (Double)ENCROACHING_MALICE_INTEGRITY_MULTIPLIER.get();
    }
}

