/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.client.screens.codex.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.BookEntry;
import com.sammy.malum.client.screen.codex.BookWidgetStyle;
import com.sammy.malum.client.screen.codex.PlacedBookEntry;
import com.sammy.malum.client.screen.codex.entries.GeasEntries;
import com.sammy.malum.client.screen.codex.objects.BookObject;
import com.sammy.malum.client.screen.codex.objects.progression.RiteEntryObject;
import com.sammy.malum.client.screen.codex.objects.progression.ScreenOpenerObject;
import com.sammy.malum.client.screen.codex.pages.BookPage;
import com.sammy.malum.client.screen.codex.pages.EntryReference;
import com.sammy.malum.client.screen.codex.pages.recipe.RuneworkingPage;
import com.sammy.malum.client.screen.codex.pages.recipe.SpiritInfusionPage;
import com.sammy.malum.client.screen.codex.pages.recipe.SpiritRiteRecipePage;
import com.sammy.malum.client.screen.codex.pages.text.HeadlineTextPage;
import com.sammy.malum.client.screen.codex.pages.text.SpiritRiteTextPage;
import com.sammy.malum.client.screen.codex.pages.text.TextPage;
import com.sammy.malum.client.screen.codex.pages.text.WeepingWellTextPage;
import com.sammy.malum.client.screen.codex.screens.AbstractProgressionCodexScreen;
import com.sammy.malum.client.screen.codex.screens.ArcanaProgressionScreen;
import com.sammy.malum.common.item.codex.EncyclopediaEsotericaItem;
import com.sammy.malum.core.systems.events.SetupMalumCodexEntriesEvent;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.item.MalumItems;
import com.strawberry.gaze.Config;
import com.strawberry.gaze.GazeMod;
import com.strawberry.gaze.registry.GazeGeasEffectTypeRegistry;
import com.strawberry.gaze.registry.GazeRiteRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class GazeProgressionScreen
extends AbstractProgressionCodexScreen {
    public static final ResourceLocation BACKGROUND_TEXTURE = GazeMod.gazePath("textures/gui/book/backdrop.png");
    public static GazeProgressionScreen screen;
    public static final List<PlacedBookEntry> GAZE_ENTRIES;

    protected GazeProgressionScreen() {
        super((Supplier)MalumSoundEvents.ARCANA_SWEETENER_EVIL, 1024, 768);
        this.minecraft = Minecraft.getInstance();
        this.setupEntries();
        NeoForge.EVENT_BUS.post((Event)new SetupMalumCodexEntriesEvent());
        this.setupObjects();
    }

    public void renderBackground(PoseStack poseStack) {
        this.renderBackground(poseStack, BACKGROUND_TEXTURE, 0.3f, 0.3f);
    }

    public Collection<PlacedBookEntry> getEntries() {
        return GAZE_ENTRIES;
    }

    public static GazeProgressionScreen getScreenInstance() {
        if (screen == null) {
            screen = new GazeProgressionScreen();
        }
        return screen;
    }

    public static void openCodexViaItem() {
        GazeProgressionScreen.getScreenInstance().openScreen(true);
        screen.playSweetenedSound((Supplier)MalumSoundEvents.ARCANA_CODEX_OPEN, 1.25f);
    }

    public static void openCodexViaTransition() {
        GazeProgressionScreen.getScreenInstance().openScreen(false);
        screen.faceObject((BookObject)GazeProgressionScreen.screen.bookObjectHandler.get(0));
        screen.playSound((Supplier)MalumSoundEvents.ARCANA_TRANSITION_EVIL, 1.25f, 1.0f);
        ++GazeProgressionScreen.screen.timesTransitioned;
        GazeProgressionScreen.screen.transitionTimer = screen.getTransitionDuration();
        EncyclopediaEsotericaItem.shouldOpenVoidCodex = false;
    }

    public void setupEntries() {
        Item EMPTY = ItemStack.EMPTY.getItem();
        BookPage.isVoidThemed = true;
        this.addEntry("chronicles_of_the_soul", 0, 0, b -> b.setWidgetSupplier((e, x, y) -> new ScreenOpenerObject(e, x, y, ArcanaProgressionScreen::openCodexViaTransition, MalumMod.malumPath((String)"textures/gui/book/icons/arcana_button.png"), 20, 20)).configureWidget(w -> w.setStyle(BookWidgetStyle.DARK_GRAND_SOULWOOD)));
        this.addEntry("gaze.soul_imbuement", 0, 1, b -> b.configureWidget(w -> w.setIcon(GazeMod.ENCYCLOPEDIA_UNVEILED).setStyle(BookWidgetStyle.GILDED_SOULWOOD)).addPage((BookPage)new HeadlineTextPage("gaze.soul_imbuement", "gaze.soul_imbuement.1")).addPage((BookPage)new TextPage("gaze.soul_imbuement.2")).addPage((BookPage)new TextPage("gaze.soul_imbuement.3")).addPage((BookPage)new TextPage("gaze.soul_imbuement.4")).addPage((BookPage)SpiritInfusionPage.fromOutput((Item)((Item)GazeMod.ENCYCLOPEDIA_UNVEILED.get()))));
        this.addEntry("gaze.gift", 0, 2, b -> b.configureWidget(w -> w.setIcon(GazeMod.VEIL_DAGGER).setStyle(BookWidgetStyle.SMALL_SOULWOOD)).addPage((BookPage)new HeadlineTextPage("gaze.gift", "gaze.gift.1")).addPage((BookPage)new TextPage("gaze.gift.2")).addPage((BookPage)new TextPage("gaze.gift.3")).addPage((BookPage)SpiritInfusionPage.fromOutput((Item)((Item)GazeMod.VEIL_DAGGER.get()))));
        this.addEntry("gaze.veil_dagger_uses", 0, 3, b -> b.configureWidget(w -> w.setIcon((Supplier)MalumItems.UMBRAL_SPIRIT).setStyle(BookWidgetStyle.SOULWOOD)).addPage((BookPage)new HeadlineTextPage("gaze.veil_dagger_uses", "gaze.veil_dagger_uses.1")).addPage((BookPage)new TextPage("gaze.veil_dagger_uses.2")));
        this.addEntry("spirit_saber", -4, 14, b -> b.configureWidget(w -> w.setIcon(GazeMod.SPIRIT_SABER).setStyle(BookWidgetStyle.GILDED_SOULWOOD)).addPage((BookPage)new HeadlineTextPage("spirit_saber", "spirit_saber.1")).addPage((BookPage)new TextPage("spirit_saber.2")).addPage((BookPage)SpiritInfusionPage.fromOutput((Item)((Item)GazeMod.SPIRIT_SABER.get()))).afterUmbralCrystal());
        this.addEntry("swift_spiral", -4, 12, b -> b.configureWidget(w -> w.setIcon(GazeMod.SWIFT_SPIRAL).setStyle(BookWidgetStyle.GILDED_SOULWOOD)).addPage((BookPage)new HeadlineTextPage("swift_spiral", "swift_spiral.1")).addPage((BookPage)SpiritInfusionPage.fromOutput((Item)((Item)GazeMod.SWIFT_SPIRAL.get()))).afterUmbralCrystal());
        this.addEntry("spirit_fusion_enchanting", 0, 14, b -> b.configureWidget(w -> w.setIcon(Items.ENCHANTED_BOOK).setStyle(BookWidgetStyle.GILDED_SOULWOOD)).addPage((BookPage)new HeadlineTextPage("spirit_fusion_enchanting", "future_secret")));
        this.addEntry("rune_of_beyond_the_veil", -4, 5, b -> b.configureWidget(w -> w.setIcon(GazeMod.RUNE_OF_BEYOND_THE_VEIL).setStyle(BookWidgetStyle.WITHERED)).addPage((BookPage)new HeadlineTextPage("rune_of_beyond_the_veil", "rune_of_beyond_the_veil.1")).addPage((BookPage)RuneworkingPage.fromOutput((Item)((Item)GazeMod.RUNE_OF_BEYOND_THE_VEIL.get()))).afterUmbralCrystal());
        this.addEntry("rune_of_blighted_presence", -5, 6, b -> b.configureWidget(w -> w.setIcon(GazeMod.RUNE_OF_BLIGHTED_PRESENCE).setStyle(BookWidgetStyle.WITHERED)).addPage((BookPage)new HeadlineTextPage("rune_of_blighted_presence", "rune_of_blighted_presence.1")).addPage((BookPage)RuneworkingPage.fromOutput((Item)((Item)GazeMod.RUNE_OF_BLIGHTED_PRESENCE.get()))).afterUmbralCrystal());
        this.addEntry("rune_of_out_of_phase", -6, 7, b -> b.configureWidget(w -> w.setIcon(GazeMod.RUNE_OF_OUT_OF_PHASE).setStyle(BookWidgetStyle.WITHERED)).addPage((BookPage)new HeadlineTextPage("rune_of_out_of_phase", "rune_of_out_of_phase.1")).addPage((BookPage)RuneworkingPage.fromOutput((Item)((Item)GazeMod.RUNE_OF_OUT_OF_PHASE.get()))).afterUmbralCrystal());
        this.addEntry("rune_of_touch_of_void", -7, 8, b -> b.configureWidget(w -> w.setIcon(GazeMod.RUNE_OF_TOUCH_OF_VOID).setStyle(BookWidgetStyle.WITHERED)).addPage((BookPage)new HeadlineTextPage("rune_of_touch_of_void", "rune_of_touch_of_void.1")).addPage((BookPage)RuneworkingPage.fromOutput((Item)((Item)GazeMod.RUNE_OF_TOUCH_OF_VOID.get()))).afterUmbralCrystal());
        this.addEntry("rune_of_gymir", -5, 8, b -> b.configureWidget(w -> w.setIcon(GazeMod.RUNE_OF_GYMIR).setStyle(BookWidgetStyle.WITHERED)).addPage((BookPage)new HeadlineTextPage("rune_of_gymir", "rune_of_gymir.1")).addPage((BookPage)RuneworkingPage.fromOutput((Item)((Item)GazeMod.RUNE_OF_GYMIR.get()))).afterUmbralCrystal());
        this.addEntry("rune_of_ymir", -6, 9, b -> b.configureWidget(w -> w.setIcon(GazeMod.RUNE_OF_YMIR).setStyle(BookWidgetStyle.WITHERED)).addPage((BookPage)new HeadlineTextPage("rune_of_ymir", "rune_of_ymir.1")).addPage((BookPage)RuneworkingPage.fromOutput((Item)((Item)GazeMod.RUNE_OF_YMIR.get()))).afterUmbralCrystal());
        this.addEntry("rune_of_eir", -7, 10, b -> b.configureWidget(w -> w.setIcon(GazeMod.RUNE_OF_EIR).setStyle(BookWidgetStyle.WITHERED)).addPage((BookPage)new HeadlineTextPage("rune_of_eir", "rune_of_eir.1")).addPage((BookPage)RuneworkingPage.fromOutput((Item)((Item)GazeMod.RUNE_OF_EIR.get()))).afterUmbralCrystal());
        this.addEntry("rune_of_fafnir", -8, 11, b -> b.configureWidget(w -> w.setIcon(GazeMod.RUNE_OF_FAFNIR).setStyle(BookWidgetStyle.WITHERED)).addPage((BookPage)new HeadlineTextPage("rune_of_fafnir", "rune_of_fafnir.1")).addPage((BookPage)RuneworkingPage.fromOutput((Item)((Item)GazeMod.RUNE_OF_FAFNIR.get()))).afterUmbralCrystal());
        this.addEntry("meditation_ring", -1, 11, b -> b.withTraceFragmentEntry().configureWidget(w -> w.setIcon(GazeMod.MEDITATION_RING).setStyle(BookWidgetStyle.GILDED_SOULWOOD)).addPage((BookPage)new HeadlineTextPage("meditation_ring", "meditation_ring.1")).addPage((BookPage)new TextPage("meditation_ring.2")).addReference(new EntryReference(GazeMod.MEDITATION_RING, BookEntry.build((String)"meditation_ring.reexamination").addPage((BookPage)SpiritInfusionPage.fromOutput((Item)((Item)GazeMod.MEDITATION_RING.get()))))).addReference(new EntryReference(GazeMod.COMPROMISE_RING, BookEntry.build((String)"compromise_ring.reexamination").addPage((BookPage)SpiritInfusionPage.fromOutput((Item)((Item)GazeMod.COMPROMISE_RING.get()))))).afterUmbralCrystal());
        this.addEntry("charge_necklace", 0, 10, b -> b.withTraceFragmentEntry().configureWidget(w -> w.setIcon(GazeMod.CHARGE_NECKLACE).setStyle(BookWidgetStyle.SMALL_SOULWOOD)).addPage((BookPage)new HeadlineTextPage("charge_necklace", "charge_necklace.1")).addPage((BookPage)SpiritInfusionPage.fromOutput((Item)((Item)GazeMod.CHARGE_NECKLACE.get()))).afterUmbralCrystal());
        this.addEntry("sluggish_brooch", 1, 9, b -> b.withTraceFragmentEntry().configureWidget(w -> w.setIcon(GazeMod.SLUGGISH_BROOCH).setStyle(BookWidgetStyle.SMALL_SOULWOOD)).addPage((BookPage)new HeadlineTextPage("sluggish_brooch", "sluggish_brooch.1")).addPage((BookPage)SpiritInfusionPage.fromOutput((Item)((Item)GazeMod.SLUGGISH_BROOCH.get()))).afterUmbralCrystal());
        this.addEntry("seidhr", -5, 13, b -> b.withTraceFragmentEntry().configureWidget(w -> w.setIcon(GazeMod.SEIDHR).setStyle(BookWidgetStyle.GILDED_SOULWOOD)).addPage((BookPage)new WeepingWellTextPage("seidhr", "seidhr.1", (Item)GazeMod.SEIDHR.get())).addPage((BookPage)new TextPage("seidhr.2")).addPage((BookPage)new TextPage("seidhr.3")).addPage((BookPage)SpiritInfusionPage.fromOutput((Item)((Item)GazeMod.SEIDHR.get()))).addPage((BookPage)new TextPage("seidhr.4")).afterUmbralCrystal());
        this.addEntry("splintered_world", -3, 13, b -> b.withTraceFragmentEntry().configureWidget(w -> w.setIcon(GazeMod.ASTRAL_SPLINTERED_WORLD).setStyle(BookWidgetStyle.GILDED_SOULWOOD)).addPage((BookPage)new WeepingWellTextPage("splintered_world", "splintered_world.1", (Item)GazeMod.SPLINTERED_WORLD.get())).addPage((BookPage)new TextPage("splintered_world.2")).addPage((BookPage)new TextPage("splintered_world.3")).addPage((BookPage)SpiritInfusionPage.fromOutput((Item)((Item)GazeMod.SPLINTERED_WORLD.get()))).afterUmbralCrystal());
        GeasEntries.addGeasEntry((AbstractProgressionCodexScreen)this, GazeGeasEffectTypeRegistry.PACT_OF_ENCROACHING, (int)0, (int)6);
        this.addEntry("soul_rapier", -3, 9, b -> b.withTraceFragmentEntry().configureWidget(w -> w.setIcon(GazeMod.SOUL_RAPIER).setStyle(BookWidgetStyle.SOULWOOD)).addPage((BookPage)new HeadlineTextPage("soul_rapier", "soul_rapier.1")).addPage((BookPage)new TextPage("soul_rapier.2")).addPage((BookPage)SpiritInfusionPage.fromOutput((Item)((Item)GazeMod.SOUL_RAPIER.get()))).afterUmbralCrystal());
        if (!Config.disableGazeRites) {
            this.addEntry("gaze_rites_lore", 5, 7, b -> b.configureWidget(w -> w.setIcon((Supplier)MalumItems.SPIRIT_JAR).setStyle(BookWidgetStyle.RUNEWOOD)).addPage((BookPage)new HeadlineTextPage("gaze_rites_lore", "gaze_rites_lore.1")).addPage((BookPage)new TextPage("gaze_rites_lore.2")).afterUmbralCrystal());
            this.addEntry("gaze_lesser_arcane_rite", 4, 7, b -> b.setWidgetSupplier(RiteEntryObject::new).configureWidget(w -> w.setStyle(BookWidgetStyle.DARK_TOTEMIC_RUNEWOOD)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_LESSER_ARCANE_RITE, "gaze_lesser_arcane_rite")).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_LESSER_ARCANE_RITE)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_GREATER_ARCANE_RITE, "gaze_greater_arcane_rite")).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_GREATER_ARCANE_RITE)).afterUmbralCrystal());
            this.addEntry("gaze_lesser_sacred_rite", 4, 4, b -> b.setWidgetSupplier(RiteEntryObject::new).configureWidget(w -> w.setStyle(BookWidgetStyle.DARK_TOTEMIC_RUNEWOOD)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_LESSER_SACRED_RITE, "gaze_lesser_sacred_rite")).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_LESSER_SACRED_RITE)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_GREATER_SACRED_RITE, "gaze_greater_sacred_rite")).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_GREATER_SACRED_RITE)).afterUmbralCrystal());
            this.addEntry("corrupt_gaze_lesser_sacred_rite", 5, 4, b -> b.configureWidget(w -> w.setStyle(BookWidgetStyle.DARK_TOTEMIC_SOULWOOD)).setWidgetSupplier(RiteEntryObject::new).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_LESSER_SACRED_RITE, "corrupt_gaze_lesser_sacred_rite")).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_LESSER_SACRED_RITE)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_GREATER_SACRED_RITE, "corrupt_gaze_greater_sacred_rite")).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_GREATER_SACRED_RITE)).afterUmbralCrystal());
            this.addEntry("gaze_lesser_aerial_rite", 5, 5, b -> b.setWidgetSupplier(RiteEntryObject::new).configureWidget(w -> w.setStyle(BookWidgetStyle.DARK_TOTEMIC_RUNEWOOD)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_LESSER_AERIAL_RITE, "gaze_lesser_aerial_rite")).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_LESSER_AERIAL_RITE)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_GREATER_AERIAL_RITE, "gaze_greater_aerial_rite")).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_GREATER_AERIAL_RITE)).afterUmbralCrystal());
            this.addEntry("corrupt_gaze_lesser_aerial_rite", 6, 5, b -> b.configureWidget(w -> w.setStyle(BookWidgetStyle.DARK_TOTEMIC_SOULWOOD)).setWidgetSupplier(RiteEntryObject::new).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_LESSER_AERIAL_RITE, "corrupt_gaze_lesser_aerial_rite")).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_LESSER_AERIAL_RITE)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_GREATER_AERIAL_RITE, "corrupt_gaze_greater_aerial_rite")).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_GREATER_AERIAL_RITE)).afterUmbralCrystal());
            this.addEntry("gaze_lesser_aqueous_rite", 6, 6, b -> b.setWidgetSupplier(RiteEntryObject::new).configureWidget(w -> w.setStyle(BookWidgetStyle.DARK_TOTEMIC_RUNEWOOD)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_LESSER_AQUEOUS_RITE, "gaze_lesser_aqueous_rite")).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_LESSER_AQUEOUS_RITE)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_GREATER_AQUEOUS_RITE, "gaze_greater_aqueous_rite")).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_GREATER_AQUEOUS_RITE)).afterUmbralCrystal());
            this.addEntry("corrupt_gaze_lesser_aqueous_rite", 7, 6, b -> b.configureWidget(w -> w.setStyle(BookWidgetStyle.DARK_TOTEMIC_SOULWOOD)).setWidgetSupplier(RiteEntryObject::new).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_LESSER_AQUEOUS_RITE, "corrupt_gaze_lesser_aqueous_rite")).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_LESSER_AQUEOUS_RITE)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_GREATER_AQUEOUS_RITE, "corrupt_gaze_greater_aqueous_rite")).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_GREATER_AQUEOUS_RITE)).afterUmbralCrystal());
            this.addEntry("gaze_lesser_earthen_rite", 6, 8, b -> b.setWidgetSupplier(RiteEntryObject::new).configureWidget(w -> w.setStyle(BookWidgetStyle.DARK_TOTEMIC_RUNEWOOD)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_LESSER_EARTHEN_RITE, "gaze_lesser_earthen_rite")).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_LESSER_EARTHEN_RITE)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_GREATER_EARTHEN_RITE, "gaze_greater_earthen_rite")).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_GREATER_EARTHEN_RITE)).afterUmbralCrystal());
            this.addEntry("corrupt_gaze_lesser_earthen_rite", 7, 8, b -> b.configureWidget(w -> w.setStyle(BookWidgetStyle.DARK_TOTEMIC_SOULWOOD)).setWidgetSupplier(RiteEntryObject::new).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_LESSER_EARTHEN_RITE, "corrupt_gaze_lesser_earthen_rite")).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_LESSER_EARTHEN_RITE)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_GREATER_EARTHEN_RITE, "corrupt_gaze_greater_earthen_rite")).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_GREATER_EARTHEN_RITE)).afterUmbralCrystal());
            this.addEntry("gaze_lesser_infernal_rite", 5, 9, b -> b.setWidgetSupplier(RiteEntryObject::new).configureWidget(w -> w.setStyle(BookWidgetStyle.DARK_TOTEMIC_RUNEWOOD)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_LESSER_INFERNAL_RITE, "gaze_lesser_infernal_rite")).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_LESSER_INFERNAL_RITE)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_GREATER_INFERNAL_RITE, "gaze_greater_infernal_rite")).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_GREATER_INFERNAL_RITE)).afterUmbralCrystal());
            this.addEntry("corrupt_gaze_lesser_infernal_rite", 6, 9, b -> b.configureWidget(w -> w.setStyle(BookWidgetStyle.DARK_TOTEMIC_SOULWOOD)).setWidgetSupplier(RiteEntryObject::new).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_LESSER_INFERNAL_RITE, "corrupt_gaze_lesser_infernal_rite")).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_LESSER_INFERNAL_RITE)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_GREATER_INFERNAL_RITE, "corrupt_gaze_greater_infernal_rite")).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_GREATER_INFERNAL_RITE)).afterUmbralCrystal());
            this.addEntry("gaze_lesser_wicked_rite", 4, 10, b -> b.setWidgetSupplier(RiteEntryObject::new).configureWidget(w -> w.setStyle(BookWidgetStyle.DARK_TOTEMIC_RUNEWOOD)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_LESSER_WICKED_RITE, "gaze_lesser_wicked_rite")).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_LESSER_WICKED_RITE)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_GREATER_WICKED_RITE, "gaze_greater_wicked_rite")).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_GREATER_WICKED_RITE)).afterUmbralCrystal());
            this.addEntry("corrupt_gaze_lesser_wicked_rite", 5, 10, b -> b.configureWidget(w -> w.setStyle(BookWidgetStyle.DARK_TOTEMIC_SOULWOOD)).setWidgetSupplier(RiteEntryObject::new).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_LESSER_WICKED_RITE, "corrupt_gaze_lesser_wicked_rite")).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_LESSER_WICKED_RITE)).addPage((BookPage)new SpiritRiteTextPage(GazeRiteRegistry.GAZE_GREATER_WICKED_RITE, "corrupt_gaze_greater_wicked_rite")).addPage((BookPage)new SpiritRiteRecipePage(GazeRiteRegistry.GAZE_GREATER_WICKED_RITE)).afterUmbralCrystal());
        }
        BookPage.isVoidThemed = false;
    }

    static {
        GAZE_ENTRIES = new ArrayList<PlacedBookEntry>();
    }
}

