/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.item.curiosities.weapons;

import com.sammy.malum.common.data.attachment.SoulWardData;
import com.sammy.malum.common.item.IMalumEventResponder;
import com.sammy.malum.common.item.spirit.ISpiritAffiliatedItem;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.neoforged.neoforge.client.event.AddAttributeTooltipsEvent;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import team.lodestar.lodestone.systems.item.LodestoneItemProperties;
import team.lodestar.lodestone.systems.item.tools.LodestoneSwordItem;

public class SoulRapierItem
extends LodestoneSwordItem
implements IMalumEventResponder,
ISpiritAffiliatedItem {
    public SoulRapierItem(Tier tier, float attackDamage, float attackSpeed, LodestoneItemProperties properties) {
        super(tier, attackDamage, attackSpeed, properties);
    }

    public void modifyAttributeTooltipEvent(AddAttributeTooltipsEvent event) {
        event.addTooltipLines(new Component[]{ComponentHelper.positiveEffect((String)"soul_based_damage", (Object[])new Object[0])});
    }

    public MalumSpiritType getDefiningSpiritType() {
        return MalumSpiritTypes.INFERNAL_SPIRIT;
    }

    public void finalizedOutgoingDamageEvent(LivingDamageEvent.Post event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        SoulWardData data = (SoulWardData)target.getData(MalumAttachmentTypes.SOUL_WARD);
        ServerLevel serverLevel = (ServerLevel)attacker.level();
        if (data != null && data.getSoulWard() > 0.0) {
            data.reduceSoulWard((double)event.getOriginalDamage());
        }
        MalumParticleEffectTypes.TYRVING_SLASH.createEffect().originatesFrom((Entity)attacker).targets((Entity)target).verticalSlashRotation().color(stack.getItem()).horizontalOffset(0.2f).forwardOffset(0.8f).upwardOffset(-0.2f).spawn(serverLevel);
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return itemAbility.equals(ItemAbilities.SWORD_DIG);
    }
}

