/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.spiritrite.arcane;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.core.systems.rite.TotemicRiteEffect;
import com.sammy.malum.core.systems.rite.TotemicRiteType;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import com.strawberry.gaze.GazeMod;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class GazeGreaterAqueousRiteType
extends TotemicRiteType {
    public GazeGreaterAqueousRiteType() {
        super("gaze_greater_aqueous_rite", new MalumSpiritType[]{MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.WICKED_SPIRIT, MalumSpiritTypes.AQUEOUS_SPIRIT});
    }

    public TotemicRiteEffect getNaturalRiteEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.LIVING_ENTITY_EFFECT){

            protected void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                if (level.isRaining()) {
                    this.getNearbyEntities(totemBase, LivingEntity.class, e -> {
                        Player player;
                        return !(e instanceof Player && (player = (Player)e).isCreative());
                    }).forEach(entity -> entity.addEffect(new MobEffectInstance(GazeMod.DRENCHED, 200, 0)));
                }
            }
        };
    }

    public TotemicRiteEffect getCorruptedEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.LIVING_ENTITY_EFFECT){

            protected void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                if (level.isRaining()) {
                    this.getNearbyEntities(totemBase, LivingEntity.class, e -> {
                        Player p;
                        return !(e instanceof Player && (p = (Player)e).isCreative());
                    }).forEach(entity -> {
                        LightningBolt bolt = new LightningBolt(EntityType.LIGHTNING_BOLT, (Level)level);
                        bolt.setPos(entity.getX(), entity.getY(), entity.getZ());
                        bolt.setVisualOnly(false);
                        level.addFreshEntity((Entity)bolt);
                    });
                }
            }
        };
    }
}

