/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.spiritrite.arcane;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.core.systems.rite.TotemicRiteEffect;
import com.sammy.malum.core.systems.rite.TotemicRiteType;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;

public class GazeGreaterEarthenRiteType
extends TotemicRiteType {
    public GazeGreaterEarthenRiteType() {
        super("gaze_greater_earthen_rite", new MalumSpiritType[]{MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.EARTHEN_SPIRIT, MalumSpiritTypes.EARTHEN_SPIRIT});
    }

    public TotemicRiteEffect getNaturalRiteEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.RADIAL_BLOCK_EFFECT){

            protected void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                List items = this.getNearbyEntities(totemBase, ItemEntity.class, item -> item.getItem().is(ItemTags.VILLAGER_PLANTABLE_SEEDS)).toList();
                Stream farmlandBlocks = this.getNearbyBlocks(totemBase, FarmBlock.class);
                int count = 0;
                for (ItemEntity itemEntity : items) {
                    BlockItem blockItem;
                    Object object;
                    if (count > 10) {
                        return;
                    }
                    ++count;
                    ItemStack stack = itemEntity.getItem();
                    Item item2 = stack.getItem();
                    if (!(item2 instanceof BlockItem) || !((object = (blockItem = (BlockItem)item2).getBlock()) instanceof CropBlock)) continue;
                    CropBlock crop = (CropBlock)object;
                    object = farmlandBlocks.toList().iterator();
                    while (object.hasNext()) {
                        BlockPos farmlandPos = (BlockPos)object.next();
                        BlockPos above = farmlandPos.above();
                        BlockState aboveState = level.getBlockState(above);
                        if (!aboveState.isAir()) continue;
                        level.setBlockAndUpdate(above, crop.defaultBlockState());
                        stack.shrink(1);
                        if (stack.isEmpty()) {
                            itemEntity.discard();
                        }
                        return;
                    }
                }
            }
        };
    }

    public TotemicRiteEffect getCorruptedEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.RADIAL_BLOCK_EFFECT){

            protected void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                if (totemBase.activeRite == null) {
                    return;
                }
                BlockPos center = this.getRiteEffectCenter(totemBase);
                BlockPos baseBelow = totemBase.getBlockPos().below();
                BlockState baseBlock = level.getBlockState(baseBelow);
                List items = this.getNearbyEntities(totemBase, ItemEntity.class).toList();
                for (ItemEntity itemEntity : items) {
                    ItemStack stack = itemEntity.getItem();
                    Item item = stack.getItem();
                    if (!(item instanceof BlockItem)) continue;
                    BlockItem blockItem = (BlockItem)item;
                    BlockPos placePos = itemEntity.blockPosition();
                    BlockPos below = placePos.below();
                    if (!level.getBlockState(below).is(baseBlock.getBlock()) || !level.getBlockState(placePos).isAir()) continue;
                    level.setBlockAndUpdate(placePos, blockItem.getBlock().defaultBlockState());
                    stack.shrink(1);
                    if (!stack.isEmpty()) continue;
                    itemEntity.discard();
                }
            }
        };
    }
}

