/*
 * Decompiled with CFR 0.152.
 */
package com.strawberry.gaze.common.spiritrite.arcane;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.core.systems.rite.TotemicRiteEffect;
import com.sammy.malum.core.systems.rite.TotemicRiteType;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class GazeLesserAqueousRiteType
extends TotemicRiteType {
    public GazeLesserAqueousRiteType() {
        super("gaze_lesser_aqueous_rite", new MalumSpiritType[]{MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.AERIAL_SPIRIT, MalumSpiritTypes.AQUEOUS_SPIRIT});
    }

    public TotemicRiteEffect getNaturalRiteEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.ONE_TIME_EFFECT){

            protected void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                if (level.isRaining() || level.isThundering()) {
                    level.setWeatherParameters(0, 0, false, false);
                } else {
                    level.setWeatherParameters(100, 6000, true, false);
                }
                totemBase.setState(TotemBaseBlockEntity.TotemRiteState.IDLE);
            }
        };
    }

    public TotemicRiteEffect getCorruptedEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.RADIAL_BLOCK_EFFECT){

            protected void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                Stream blocks = this.getNearbyBlocks(totemBase, Object.class);
                blocks.forEach(pos -> {
                    BlockState state = level.getBlockState(pos);
                    if (!this.canAffectBlock(totemBase, state, (BlockPos)pos)) {
                        return;
                    }
                    if (state.is(Blocks.FIRE)) {
                        level.removeBlock(pos, false);
                    }
                    if (state.getBlock() instanceof CampfireBlock && ((Boolean)state.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
                        level.setBlock(pos, (BlockState)state.setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
                    }
                });
            }
        };
    }
}

