/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.georenouveau.entity.goal;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.AmethystGolem;
import com.shynieke.georenouveau.entity.GeOreGolem;
import com.shynieke.georenouveau.entity.LinkedGeOre;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;

public class GeOreConvertBuddingGoal
extends Goal {
    public GeOreGolem golem;
    public Supplier<Boolean> canUse;
    BlockPos targetCluster;
    int usingTicks;
    boolean isDone;

    public GeOreConvertBuddingGoal(GeOreGolem golem, Supplier<Boolean> canUse) {
        this.golem = golem;
        this.canUse = canUse;
    }

    public boolean canContinueToUse() {
        return this.targetCluster != null && !this.isDone;
    }

    public void tick() {
        super.tick();
        --this.usingTicks;
        this.golem.getNavigation().tryMoveToBlockPos(this.targetCluster, 1.0);
        if (this.usingTicks <= 0) {
            this.isDone = true;
            this.convert();
            return;
        }
        if (BlockUtil.distanceFrom((BlockPos)this.golem.blockPosition(), (BlockPos)this.targetCluster) <= 2.0) {
            this.golem.setImbuePos(this.targetCluster);
            this.golem.setImbueing(true);
            this.usingTicks = Math.min(this.usingTicks, 40);
        }
    }

    public void convert() {
        LinkedGeOre linked = this.golem.getLinkedGeOre();
        if (this.targetCluster != null && this.golem.level().getBlockState(this.targetCluster).is(linked.getBlock())) {
            this.golem.level().setBlock(this.targetCluster, linked.getBudding().defaultBlockState(), 3);
            ParticleUtil.spawnTouchPacket((Level)this.golem.level(), (BlockPos)this.targetCluster, (ParticleColor)ParticleColor.defaultParticleColor());
        }
        this.golem.convertCooldown = 6000;
        this.golem.setImbueing(false);
        this.golem.setImbuePos(BlockPos.ZERO);
    }

    public void start() {
        this.isDone = false;
        this.usingTicks = 120;
        LinkedGeOre linked = this.golem.getLinkedGeOre();
        for (BlockPos pos : this.golem.amethystBlocks) {
            if (!this.golem.level().getBlockState(pos).is(linked.getBlock())) continue;
            this.targetCluster = pos;
            break;
        }
        this.golem.goalState = AmethystGolem.AmethystGolemGoalState.CONVERT;
    }

    public void stop() {
        this.golem.setImbueing(false);
        this.golem.goalState = AmethystGolem.AmethystGolemGoalState.NONE;
    }

    public boolean isInterruptable() {
        return false;
    }

    public boolean canUse() {
        return this.canUse.get() != false && this.golem.convertCooldown <= 0 && !this.golem.amethystBlocks.isEmpty();
    }
}

