/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.client.handler;

import com.blakebr0.cucumber.helper.ColorHelper;
import com.blakebr0.cucumber.iface.IColored;
import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.soul.MobSoulType;
import com.blakebr0.mysticalagriculture.api.tinkering.Augment;
import com.blakebr0.mysticalagriculture.api.util.MobSoulUtils;
import com.blakebr0.mysticalagriculture.block.InfusedFarmlandBlock;
import com.blakebr0.mysticalagriculture.init.ModItems;
import com.blakebr0.mysticalagriculture.lib.ModCrops;
import com.blakebr0.mysticalagriculture.registry.AugmentRegistry;
import com.blakebr0.mysticalagriculture.registry.CropRegistry;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;

public final class ColorHandler {
    @SubscribeEvent
    public void onBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((BlockColor)new IColored.BlockColors(), (Block[])InfusedFarmlandBlock.FARMLANDS.toArray(new InfusedFarmlandBlock[0]));
        for (Crop crop : CropRegistry.getInstance().getCrops()) {
            if (!crop.isFlowerColored() || crop.getCropBlock() == null) continue;
            event.register((state, world, pos, tint) -> crop.getFlowerColor(), new Block[]{crop.getCropBlock()});
        }
    }

    @SubscribeEvent
    public void onItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((ItemColor)new IColored.ItemBlockColors(), (ItemLike[])InfusedFarmlandBlock.FARMLANDS.toArray(new InfusedFarmlandBlock[0]));
        event.register((stack, tint) -> {
            float damage = (float)(stack.getMaxDamage() - stack.getDamageValue()) / (float)stack.getMaxDamage();
            return ColorHelper.saturate((int)55769, (float)damage);
        }, new ItemLike[]{(ItemLike)ModItems.INFUSION_CRYSTAL.get()});
        event.register((stack, tint) -> ModCrops.AIR.getEssenceColor(), new ItemLike[]{(ItemLike)ModItems.AIR_AGGLOMERATIO.get()});
        event.register((stack, tint) -> ModCrops.EARTH.getEssenceColor(), new ItemLike[]{(ItemLike)ModItems.EARTH_AGGLOMERATIO.get()});
        event.register((stack, tint) -> ModCrops.WATER.getEssenceColor(), new ItemLike[]{(ItemLike)ModItems.WATER_AGGLOMERATIO.get()});
        event.register((stack, tint) -> ModCrops.FIRE.getEssenceColor(), new ItemLike[]{(ItemLike)ModItems.FIRE_AGGLOMERATIO.get()});
        event.register((stack, tint) -> {
            MobSoulType type = MobSoulUtils.getType(stack);
            return tint == 1 && type != null ? type.getColor() : -1;
        }, new ItemLike[]{(ItemLike)ModItems.SOUL_JAR.get()});
        for (Crop crop : CropRegistry.getInstance().getCrops()) {
            if (crop.isEssenceColored() && crop.getEssenceItem() != null) {
                event.register((stack, tint) -> crop.getEssenceColor(), new ItemLike[]{crop.getEssenceItem()});
            }
            if (!crop.isSeedColored() || crop.getSeedsItem() == null) continue;
            event.register((stack, tint) -> crop.getSeedColor(), new ItemLike[]{crop.getSeedsItem()});
        }
        for (Augment augment : AugmentRegistry.getInstance().getAugments()) {
            if (augment.getItem() == null) continue;
            event.register((stack, tint) -> tint == 0 ? augment.getSecondaryColor() : (tint == 1 ? augment.getPrimaryColor() : -1), new ItemLike[]{augment.getItem()});
        }
    }
}

