/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.client.tesr;

import com.blakebr0.cucumber.client.ModRenderTypes;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.mysticalagriculture.init.ModBlocks;
import com.blakebr0.mysticalagriculture.tileentity.AwakeningAltarTileEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.model.data.ModelData;

public class AwakeningAltarRenderer
implements BlockEntityRenderer<AwakeningAltarTileEntity> {
    public AwakeningAltarRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(AwakeningAltarTileEntity tile, float v, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        ItemStack stack;
        Minecraft minecraft = Minecraft.getInstance();
        BaseItemStackHandler inventory = tile.getInventory();
        ItemStack itemStack = stack = inventory.getStackInSlot(1).isEmpty() ? inventory.getStackInSlot(0) : inventory.getStackInSlot(1);
        if (!stack.isEmpty()) {
            matrix.pushPose();
            matrix.translate(0.5, 1.1, 0.5);
            float scale = stack.getItem() instanceof BlockItem ? 0.95f : 0.75f;
            matrix.scale(scale, scale, scale);
            double tick = (double)System.currentTimeMillis() / 800.0;
            matrix.translate(0.0, Math.sin(tick % (Math.PI * 2)) * 0.065, 0.0);
            matrix.mulPose(Axis.YP.rotationDegrees((float)(tick * 40.0 % 360.0)));
            minecraft.getItemRenderer().renderStatic(stack, ItemDisplayContext.GROUND, combinedLight, combinedOverlay, matrix, buffer, (Level)minecraft.level, 0);
            matrix.popPose();
        }
        BlockPos pos = tile.getBlockPos();
        Level level = tile.getLevel();
        VertexConsumer builder = buffer.getBuffer(ModRenderTypes.GHOST);
        matrix.pushPose();
        matrix.translate((float)(-pos.getX()), (float)(-pos.getY()), (float)(-pos.getZ()));
        List<BlockPos> positions = tile.getPedestalPositions();
        for (int i = 0; i < positions.size(); ++i) {
            BlockPos aoePos = positions.get(i);
            if (level == null || !level.isEmptyBlock(aoePos)) continue;
            matrix.pushPose();
            matrix.translate((float)aoePos.getX(), (float)aoePos.getY(), (float)aoePos.getZ());
            BlockState state = i % 2 == 0 ? ((Block)ModBlocks.AWAKENING_PEDESTAL.get()).defaultBlockState() : ((Block)ModBlocks.ESSENCE_VESSEL.get()).defaultBlockState();
            minecraft.getBlockRenderer().renderBatched(state, aoePos, (BlockAndTintGetter)level, matrix, builder, false, level.getRandom(), ModelData.EMPTY, null);
            matrix.popPose();
        }
        matrix.popPose();
    }

    public boolean shouldRenderOffScreen(AwakeningAltarTileEntity tile) {
        return true;
    }

    public AABB getRenderBoundingBox(AwakeningAltarTileEntity tile) {
        return AABB.INFINITE;
    }
}

