/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting.condition;

import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.registry.CropRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.conditions.ICondition;

public class CropHasMaterialCondition
implements ICondition {
    public static final MapCodec<CropHasMaterialCondition> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("crop").forGetter(condition -> condition.crop)).apply((Applicative)builder, CropHasMaterialCondition::new));
    private final ResourceLocation crop;

    public CropHasMaterialCondition(ResourceLocation crop) {
        this.crop = crop;
    }

    public boolean test(ICondition.IContext context) {
        Crop crop = CropRegistry.getInstance().getCropById(this.crop);
        if (crop == null) {
            return false;
        }
        Ingredient material = crop.getCraftingMaterial();
        return material != null && !material.isEmpty();
    }

    public MapCodec<? extends ICondition> codec() {
        return CODEC;
    }
}

